/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.io;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import org.jgrapht.Graph;
import org.jgrapht.io.AbstractBaseExporter;
import org.jgrapht.io.Attribute;
import org.jgrapht.io.AttributeType;
import org.jgrapht.io.ComponentAttributeProvider;
import org.jgrapht.io.ComponentNameProvider;
import org.jgrapht.io.DOTUtils;
import org.jgrapht.io.DefaultAttribute;
import org.jgrapht.io.GraphExporter;
import org.jgrapht.io.IntegerComponentNameProvider;

@Deprecated
public class DOTExporter<V, E>
extends AbstractBaseExporter<V, E>
implements GraphExporter<V, E> {
    public static final String DEFAULT_GRAPH_ID = "G";
    private final ComponentNameProvider<Graph<V, E>> graphIDProvider;
    private final ComponentNameProvider<V> vertexLabelProvider;
    private final ComponentNameProvider<E> edgeLabelProvider;
    private final ComponentAttributeProvider<V> vertexAttributeProvider;
    private final ComponentAttributeProvider<E> edgeAttributeProvider;
    private final Map<String, String> graphAttributes;
    private final Map<V, String> vertexIds;
    private static final String INDENT = "  ";

    public DOTExporter() {
        this(new IntegerComponentNameProvider(), null, null, null, null, null);
    }

    public DOTExporter(ComponentNameProvider<V> vertexIDProvider, ComponentNameProvider<V> vertexLabelProvider, ComponentNameProvider<E> edgeLabelProvider) {
        this(vertexIDProvider, vertexLabelProvider, edgeLabelProvider, null, null, null);
    }

    public DOTExporter(ComponentNameProvider<V> vertexIDProvider, ComponentNameProvider<V> vertexLabelProvider, ComponentNameProvider<E> edgeLabelProvider, ComponentAttributeProvider<V> vertexAttributeProvider, ComponentAttributeProvider<E> edgeAttributeProvider) {
        this(vertexIDProvider, vertexLabelProvider, edgeLabelProvider, vertexAttributeProvider, edgeAttributeProvider, null);
    }

    public DOTExporter(ComponentNameProvider<V> vertexIDProvider, ComponentNameProvider<V> vertexLabelProvider, ComponentNameProvider<E> edgeLabelProvider, ComponentAttributeProvider<V> vertexAttributeProvider, ComponentAttributeProvider<E> edgeAttributeProvider, ComponentNameProvider<Graph<V, E>> graphIDProvider) {
        super(vertexIDProvider);
        this.vertexLabelProvider = vertexLabelProvider;
        this.edgeLabelProvider = edgeLabelProvider;
        this.vertexAttributeProvider = vertexAttributeProvider;
        this.edgeAttributeProvider = edgeAttributeProvider;
        this.graphIDProvider = graphIDProvider == null ? any -> DEFAULT_GRAPH_ID : graphIDProvider;
        this.graphAttributes = new LinkedHashMap<String, String>();
        this.vertexIds = new HashMap<V, String>();
    }

    @Override
    public void exportGraph(Graph<V, E> g, Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        out.println(this.computeHeader(g));
        for (Map.Entry<String, String> attr : this.graphAttributes.entrySet()) {
            out.print(INDENT);
            out.print(attr.getKey());
            out.print('=');
            out.print(attr.getValue());
            out.println(";");
        }
        for (Map.Entry<String, String> v : g.vertexSet()) {
            out.print(INDENT);
            out.print(this.getVertexID(v));
            String labelName = null;
            if (this.vertexLabelProvider != null) {
                labelName = this.vertexLabelProvider.getName(v);
            }
            Map<String, Attribute> attributes = null;
            if (this.vertexAttributeProvider != null) {
                attributes = this.vertexAttributeProvider.getComponentAttributes(v);
            }
            this.renderAttributes(out, labelName, attributes);
            out.println(";");
        }
        String connector = this.computeConnector(g);
        for (E e2 : g.edgeSet()) {
            String source = this.getVertexID(g.getEdgeSource(e2));
            String target = this.getVertexID(g.getEdgeTarget(e2));
            out.print(INDENT);
            out.print(source);
            out.print(connector);
            out.print(target);
            String labelName = null;
            if (this.edgeLabelProvider != null) {
                labelName = this.edgeLabelProvider.getName(e2);
            }
            Map<String, Attribute> attributes = null;
            if (this.edgeAttributeProvider != null) {
                attributes = this.edgeAttributeProvider.getComponentAttributes(e2);
            }
            this.renderAttributes(out, labelName, attributes);
            out.println(";");
        }
        out.println(this.computeFooter(g));
        out.flush();
    }

    private String computeHeader(Graph<V, E> graph) {
        StringBuilder headerBuilder = new StringBuilder();
        if (!graph.getType().isAllowingMultipleEdges()) {
            headerBuilder.append("strict").append(" ");
        }
        if (graph.getType().isDirected()) {
            headerBuilder.append("digraph");
        } else {
            headerBuilder.append("graph");
        }
        headerBuilder.append(" ").append(this.computeGraphId(graph)).append(" {");
        return headerBuilder.toString();
    }

    public void removeGraphAttribute(String key) {
        Objects.requireNonNull(key, "Graph attribute key cannot be null");
        this.graphAttributes.remove(key);
    }

    public void putGraphAttribute(String key, String value) {
        Objects.requireNonNull(key, "Graph attribute key cannot be null");
        Objects.requireNonNull(value, "Graph attribute value cannot be null");
        this.graphAttributes.put(key, value);
    }

    private String computeFooter(Graph<V, E> graph) {
        return "}";
    }

    private String computeConnector(Graph<V, E> graph) {
        StringBuilder connectorBuilder = new StringBuilder();
        if (graph.getType().isDirected()) {
            connectorBuilder.append(" ").append("->").append(" ");
        } else {
            connectorBuilder.append(" ").append("--").append(" ");
        }
        return connectorBuilder.toString();
    }

    private String computeGraphId(Graph<V, E> graph) {
        String graphId = this.graphIDProvider.getName(graph);
        if (graphId == null || graphId.trim().isEmpty()) {
            graphId = DEFAULT_GRAPH_ID;
        }
        if (!DOTUtils.isValidID(graphId)) {
            throw new RuntimeException("Generated graph ID '" + graphId + "' is not valid with respect to the .dot language");
        }
        return graphId;
    }

    private void renderAttributes(PrintWriter out, String labelName, Map<String, Attribute> attributes) {
        if (labelName == null && attributes == null) {
            return;
        }
        out.print(" [ ");
        Attribute labelAttribute = labelName != null ? DefaultAttribute.createAttribute(labelName) : attributes.get("label");
        if (labelAttribute != null) {
            this.renderAttribute(out, "label", labelAttribute);
        }
        if (attributes != null) {
            for (Map.Entry<String, Attribute> entry : attributes.entrySet()) {
                String name = entry.getKey();
                if (name.equals("label")) continue;
                this.renderAttribute(out, name, entry.getValue());
            }
        }
        out.print("]");
    }

    private void renderAttribute(PrintWriter out, String attrName, Attribute attribute) {
        out.print(attrName + "=");
        String attrValue = attribute.getValue();
        if (AttributeType.HTML.equals((Object)attribute.getType())) {
            out.print("<" + attrValue + ">");
        } else {
            out.print("\"" + DOTExporter.escapeDoubleQuotes(attrValue) + "\"");
        }
        out.print(" ");
    }

    private static String escapeDoubleQuotes(String labelName) {
        return labelName.replaceAll("\"", Matcher.quoteReplacement("\\\""));
    }

    private String getVertexID(V v) {
        String vertexId = this.vertexIds.get(v);
        if (vertexId == null) {
            String idCandidate = this.vertexIDProvider.getName(v);
            if (!DOTUtils.isValidID(idCandidate)) {
                throw new RuntimeException("Generated id '" + idCandidate + "'for vertex '" + v + "' is not valid with respect to the .dot language");
            }
            this.vertexIds.put((String)v, idCandidate);
            vertexId = idCandidate;
        }
        return vertexId;
    }
}

