/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.io;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.jgrapht.Graph;
import org.jgrapht.io.AbstractBaseImporter;
import org.jgrapht.io.Attribute;
import org.jgrapht.io.CSVBaseListener;
import org.jgrapht.io.CSVFormat;
import org.jgrapht.io.CSVLexer;
import org.jgrapht.io.CSVParser;
import org.jgrapht.io.DSVUtils;
import org.jgrapht.io.EdgeProvider;
import org.jgrapht.io.GraphImporter;
import org.jgrapht.io.ImportException;
import org.jgrapht.io.VertexProvider;

@Deprecated
public class CSVImporter<V, E>
extends AbstractBaseImporter<V, E>
implements GraphImporter<V, E> {
    private static final char DEFAULT_DELIMITER = ',';
    private CSVFormat format;
    private char delimiter;
    private final Set<CSVFormat.Parameter> parameters;

    public CSVImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider) {
        this(vertexProvider, edgeProvider, CSVFormat.ADJACENCY_LIST, ',');
    }

    public CSVImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider, CSVFormat format) {
        this(vertexProvider, edgeProvider, format, ',');
    }

    public CSVImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider, CSVFormat format, char delimiter) {
        super(vertexProvider, edgeProvider);
        this.format = format;
        if (!DSVUtils.isValidDelimiter(delimiter)) {
            throw new IllegalArgumentException("Character cannot be used as a delimiter");
        }
        this.delimiter = delimiter;
        this.parameters = new HashSet<CSVFormat.Parameter>();
    }

    public CSVFormat getFormat() {
        return this.format;
    }

    public void setFormat(CSVFormat format) {
        this.format = format;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        if (!DSVUtils.isValidDelimiter(delimiter)) {
            throw new IllegalArgumentException("Character cannot be used as a delimiter");
        }
        this.delimiter = delimiter;
    }

    public boolean isParameter(CSVFormat.Parameter p) {
        return this.parameters.contains((Object)p);
    }

    public void setParameter(CSVFormat.Parameter p, boolean value) {
        if (value) {
            this.parameters.add(p);
        } else {
            this.parameters.remove((Object)p);
        }
    }

    @Override
    public void importGraph(Graph<V, E> graph, Reader input) throws ImportException {
        switch (this.format) {
            case EDGE_LIST: 
            case ADJACENCY_LIST: {
                this.read(graph, input, new AdjacencyListCSVListener(graph));
                break;
            }
            case MATRIX: {
                this.read(graph, input, new MatrixCSVListener(graph));
            }
        }
    }

    private void read(Graph<V, E> graph, Reader input, CSVBaseListener listener) throws ImportException {
        try {
            ThrowingErrorListener errorListener = new ThrowingErrorListener();
            CSVLexer lexer = new CSVLexer(CharStreams.fromReader(input));
            lexer.setSep(this.delimiter);
            lexer.removeErrorListeners();
            lexer.addErrorListener(errorListener);
            CSVParser parser2 = new CSVParser(new CommonTokenStream(lexer));
            parser2.removeErrorListeners();
            parser2.addErrorListener(errorListener);
            CSVParser.FileContext graphContext = parser2.file();
            ParseTreeWalker walker = new ParseTreeWalker();
            walker.walk(listener, graphContext);
        }
        catch (IOException e2) {
            throw new ImportException("Failed to import CSV graph: " + e2.getMessage(), e2);
        }
        catch (ParseCancellationException pe) {
            throw new ImportException("Failed to import CSV graph: " + pe.getMessage(), pe);
        }
        catch (IllegalArgumentException iae) {
            throw new ImportException("Failed to import CSV graph: " + iae.getMessage(), iae);
        }
    }

    private abstract class RowCSVListener
    extends CSVBaseListener {
        protected Graph<V, E> graph;
        protected List<String> row;
        protected Map<String, V> vertices;
        protected boolean header;

        public RowCSVListener(Graph<V, E> graph) {
            this.graph = graph;
            this.row = new ArrayList<String>();
            this.vertices = new HashMap();
            this.header = false;
        }

        @Override
        public void enterHeader(CSVParser.HeaderContext ctx) {
            this.header = true;
        }

        @Override
        public void exitHeader(CSVParser.HeaderContext ctx) {
            this.header = false;
        }

        @Override
        public void enterRecord(CSVParser.RecordContext ctx) {
            this.row.clear();
        }

        @Override
        public void exitRecord(CSVParser.RecordContext ctx) {
            if (this.row.isEmpty()) {
                throw new ParseCancellationException("Empty CSV record");
            }
            this.handleRow();
        }

        @Override
        public void exitTextField(CSVParser.TextFieldContext ctx) {
            this.row.add(ctx.TEXT().getText());
        }

        @Override
        public void exitStringField(CSVParser.StringFieldContext ctx) {
            this.row.add(DSVUtils.unescapeDSV(ctx.STRING().getText(), CSVImporter.this.delimiter));
        }

        @Override
        public void exitEmptyField(CSVParser.EmptyFieldContext ctx) {
            this.row.add("");
        }

        protected abstract void handleRow();
    }

    private class MatrixCSVListener
    extends RowCSVListener {
        private boolean assumeNodeIds;
        private boolean assumeEdgeWeights;
        private boolean assumeZeroWhenNoEdge;
        private int verticesCount;
        private int currentVertex;
        private String currentVertexName;
        private Map<Integer, String> columnIndex;

        public MatrixCSVListener(Graph<V, E> graph) {
            super(graph);
            this.assumeNodeIds = CSVImporter.this.parameters.contains((Object)CSVFormat.Parameter.MATRIX_FORMAT_NODEID);
            this.assumeEdgeWeights = CSVImporter.this.parameters.contains((Object)CSVFormat.Parameter.EDGE_WEIGHTS);
            this.assumeZeroWhenNoEdge = CSVImporter.this.parameters.contains((Object)CSVFormat.Parameter.MATRIX_FORMAT_ZERO_WHEN_NO_EDGE);
            this.verticesCount = 0;
            this.currentVertex = 1;
            this.currentVertexName = null;
            this.columnIndex = new HashMap<Integer, String>();
        }

        @Override
        protected void handleRow() {
            if (this.assumeNodeIds) {
                if (!this.header) {
                    this.currentVertexName = (String)this.row.get(0);
                }
                this.row.remove(0);
            } else {
                this.currentVertexName = String.valueOf(this.currentVertex);
            }
            if (this.header) {
                if (this.assumeNodeIds) {
                    this.createVerticesFromNodeIds();
                } else {
                    this.createVertices();
                    this.createEdges();
                    ++this.currentVertex;
                }
            } else {
                this.createEdges();
                ++this.currentVertex;
            }
        }

        private void createVerticesFromNodeIds() {
            this.verticesCount = this.row.size();
            if (this.verticesCount < 1) {
                throw new ParseCancellationException("Failed to parse header with vertices");
            }
            int v = 1;
            for (String vertexName : this.row) {
                if (vertexName.trim().isEmpty()) {
                    throw new ParseCancellationException("Failed to parse header with vertices (empty name)");
                }
                Object vertex = CSVImporter.this.vertexProvider.buildVertex(vertexName, new HashMap<String, Attribute>());
                this.vertices.put(vertexName, vertex);
                this.graph.addVertex(vertex);
                this.columnIndex.put(v, vertexName);
                ++v;
            }
        }

        private void createVertices() {
            this.verticesCount = this.row.size();
            if (this.verticesCount < 1) {
                throw new ParseCancellationException("Failed to parse header with vertices");
            }
            int v = 1;
            for (v = 1; v <= this.verticesCount; ++v) {
                String vertexName = String.valueOf(v);
                Object vertex = CSVImporter.this.vertexProvider.buildVertex(vertexName, new HashMap<String, Attribute>());
                this.vertices.put(vertexName, vertex);
                this.graph.addVertex(vertex);
                this.columnIndex.put(v, vertexName);
            }
        }

        private void createEdges() {
            if (this.row.size() != this.verticesCount) {
                throw new ParseCancellationException("Row contains fewer than " + this.verticesCount + " entries");
            }
            int target = 1;
            for (String entry : this.row) {
                try {
                    Integer entryAsInteger = Integer.parseInt(entry);
                    if (entryAsInteger == 0) {
                        if (!this.assumeZeroWhenNoEdge && this.assumeEdgeWeights) {
                            this.createEdge(this.currentVertexName, this.columnIndex.get(target), 0.0);
                        }
                    } else if (this.assumeEdgeWeights) {
                        this.createEdge(this.currentVertexName, this.columnIndex.get(target), (double)entryAsInteger);
                    } else {
                        this.createEdge(this.currentVertexName, this.columnIndex.get(target), null);
                    }
                    ++target;
                }
                catch (NumberFormatException entryAsInteger) {
                    try {
                        Double entryAsDouble = Double.parseDouble(entry);
                        if (!this.assumeEdgeWeights) {
                            throw new ParseCancellationException("Double entry found when expecting no weights");
                        }
                        this.createEdge(this.currentVertexName, this.columnIndex.get(target), entryAsDouble);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++target;
                }
            }
        }

        private void createEdge(String sourceName, String targetName, Double weight) {
            try {
                Object source = this.vertices.get(sourceName);
                Object target = this.vertices.get(targetName);
                String label = "e_" + source + "_" + target;
                Object e2 = CSVImporter.this.edgeProvider.buildEdge(source, target, label, new HashMap<String, Attribute>());
                this.graph.addEdge(source, target, e2);
                if (weight != null && this.graph.getType().isWeighted()) {
                    this.graph.setEdgeWeight(e2, weight);
                }
            }
            catch (IllegalArgumentException e3) {
                throw new ParseCancellationException("Provided graph does not support input: " + e3.getMessage(), e3);
            }
        }
    }

    private class AdjacencyListCSVListener
    extends RowCSVListener {
        private boolean assumeEdgeWeights;

        public AdjacencyListCSVListener(Graph<V, E> graph) {
            super(graph);
            this.assumeEdgeWeights = CSVImporter.this.parameters.contains((Object)CSVFormat.Parameter.EDGE_WEIGHTS);
        }

        @Override
        protected void handleRow() {
            String sourceKey = (String)this.row.get(0);
            if (sourceKey.isEmpty()) {
                throw new ParseCancellationException("Source vertex cannot be empty");
            }
            Object source = this.vertices.get(sourceKey);
            if (source == null) {
                source = CSVImporter.this.vertexProvider.buildVertex(sourceKey, new HashMap<String, Attribute>());
                this.vertices.put(sourceKey, source);
                this.graph.addVertex(source);
            }
            this.row.remove(0);
            int step = this.assumeEdgeWeights ? 2 : 1;
            for (int i = 0; i < this.row.size(); i += step) {
                String key = (String)this.row.get(i);
                if (key.isEmpty()) {
                    throw new ParseCancellationException("Target vertex cannot be empty");
                }
                Object target = this.vertices.get(key);
                if (target == null) {
                    target = CSVImporter.this.vertexProvider.buildVertex(key, new HashMap<String, Attribute>());
                    this.vertices.put(key, target);
                    this.graph.addVertex(target);
                }
                double weight = 1.0;
                if (this.assumeEdgeWeights) {
                    try {
                        weight = Double.parseDouble((String)this.row.get(i + 1));
                    }
                    catch (NumberFormatException nfe) {
                        throw new ParseCancellationException("Failed to parse edge weight");
                    }
                }
                try {
                    String label = "e_" + source + "_" + target;
                    Object e2 = CSVImporter.this.edgeProvider.buildEdge(source, target, label, new HashMap<String, Attribute>());
                    this.graph.addEdge(source, target, e2);
                    if (!this.assumeEdgeWeights) continue;
                    this.graph.setEdgeWeight(e2, weight);
                    continue;
                }
                catch (IllegalArgumentException e3) {
                    throw new ParseCancellationException("Provided graph does not support input: " + e3.getMessage(), e3);
                }
            }
        }
    }

    private class ThrowingErrorListener
    extends BaseErrorListener {
        private ThrowingErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e2) throws ParseCancellationException {
            throw new ParseCancellationException("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }
}

