/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.listener.ContainerInitializer;
import org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;

public class NativeWebSocketServletContainerInitializer
implements ServletContainerInitializer {
    public static final String ATTR_KEY = NativeWebSocketConfiguration.class.getName();

    public static NativeWebSocketConfiguration initialize(ServletContextHandler context2) {
        NativeWebSocketConfiguration configuration = (NativeWebSocketConfiguration)context2.getAttribute(ATTR_KEY);
        if (configuration == null) {
            configuration = new NativeWebSocketConfiguration(context2.getServletContext());
            context2.setAttribute(ATTR_KEY, configuration);
            context2.addManaged(configuration);
        }
        return configuration;
    }

    public static void configure(ServletContextHandler context2, Configurator configurator) {
        context2.addEventListener(ContainerInitializer.asContextListener(new NativeWebSocketServletContainerInitializer()).afterStartup(servletContext -> {
            if (configurator != null) {
                NativeWebSocketConfiguration configuration = (NativeWebSocketConfiguration)servletContext.getAttribute(ATTR_KEY);
                configurator.accept((ServletContext)servletContext, configuration);
            }
        }));
    }

    @Deprecated
    public static NativeWebSocketConfiguration getDefaultFrom(ServletContext context2) {
        ServletContextHandler handler = ServletContextHandler.getServletContextHandler(context2);
        if (handler == null) {
            throw new IllegalStateException("Unable to find ServletContextHandler for provided ServletContext");
        }
        return NativeWebSocketServletContainerInitializer.initialize(handler);
    }

    @Override
    public void onStartup(Set<Class<?>> c, ServletContext context2) {
        ServletContextHandler handler = ServletContextHandler.getServletContextHandler(context2);
        if (handler == null) {
            throw new IllegalStateException("Unable to find ServletContextHandler for provided ServletContext");
        }
        NativeWebSocketServletContainerInitializer.initialize(handler);
    }

    public static interface Configurator {
        public void accept(ServletContext var1, NativeWebSocketConfiguration var2);
    }
}

