/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.Map;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;

public class FragmentConfiguration
extends AbstractConfiguration {
    public static final String FRAGMENT_RESOURCES = "org.eclipse.jetty.webFragments";

    @Override
    public void preConfigure(WebAppContext context2) throws Exception {
        this.addWebFragments(context2, context2.getMetaData());
    }

    @Override
    public void postConfigure(WebAppContext context2) throws Exception {
        context2.setAttribute(FRAGMENT_RESOURCES, null);
    }

    public void findWebFragments(WebAppContext context2, MetaData metaData) throws Exception {
        this.addWebFragments(context2, metaData);
    }

    public void addWebFragments(WebAppContext context2, MetaData metaData) throws Exception {
        Map frags = (Map)context2.getAttribute(FRAGMENT_RESOURCES);
        if (frags != null) {
            for (Resource key : frags.keySet()) {
                if (key.isDirectory()) {
                    metaData.addFragment(key, (Resource)frags.get(key));
                    continue;
                }
                metaData.addFragment(key, (Resource)frags.get(key));
            }
        }
    }
}

