/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.sys;

import java.util.Properties;
import java.util.Set;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.tdb.TDB;

public class EnvTDB {
    static final String prefix = "tdb:";

    public static void processGlobalSystemProperties() {
        Context context2 = EnvTDB.processProperties(System.getProperties());
        TDB.getContext().putAll(context2);
    }

    public static Context processProperties(Properties properties) {
        Context context2 = new Context();
        Set<Object> keys = properties.keySet();
        for (Object key : keys) {
            if (!(key instanceof String)) continue;
            String keyStr = (String)key;
            if (keyStr.startsWith(prefix)) {
                keyStr = "http://jena.hpl.hp.com/TDB#" + keyStr.substring(prefix.length());
            }
            if (!keyStr.startsWith("http://jena.hpl.hp.com/TDB#")) continue;
            Object value = properties.get(key);
            Symbol symbol2 = Symbol.create(keyStr);
            context2.set(symbol2, value);
        }
        return context2;
    }
}

