/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.solver;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarAlloc;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.solver.BindingNodeId;
import org.apache.jena.tdb.solver.SolverLib;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.nodetable.NodeTable;
import org.apache.jena.tdb.store.nodetupletable.NodeTupleTable;

public class SolverRX {
    private static VarAlloc varAlloc(ExecutionContext execCxt) {
        Context context2 = execCxt.getContext();
        VarAlloc varAlloc = VarAlloc.get(context2, ARQConstants.sysVarAllocRDFStar);
        if (varAlloc == null) {
            varAlloc = new VarAlloc("~");
            context2.set(ARQConstants.sysVarAllocRDFStar, varAlloc);
        }
        return varAlloc;
    }

    public static Iterator<BindingNodeId> solveRX(NodeTupleTable nodeTupleTable, Tuple<Node> pattern, boolean anyGraph, Iterator<BindingNodeId> chain, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        if (!SolverRX.tripleHasNodeTriple(pattern)) {
            SolverLib.solve(nodeTupleTable, pattern, anyGraph, chain, filter, execCxt);
        }
        Args args = new Args(nodeTupleTable, anyGraph, filter, execCxt);
        return SolverRX.rdfStarTriple(chain, pattern, args);
    }

    private static Iterator<BindingNodeId> rdfStarTriple(Iterator<BindingNodeId> input, Tuple<Node> pattern, Args args) {
        if (!SolverRX.tripleHasNodeTriple(pattern)) {
            return SolverRX.matchData(input, pattern, args);
        }
        return SolverRX.rdfStarTripleSub(input, pattern, args);
    }

    private static Iterator<BindingNodeId> rdfStarTripleSub(Iterator<BindingNodeId> input, Tuple<Node> pattern, Args args) {
        Pair<Iterator<BindingNodeId>, Tuple<Node>> pair = SolverRX.preprocessForTripleTerms(input, pattern, args);
        Iterator<BindingNodeId> chain2 = SolverRX.matchData(pair.getLeft(), pair.getRight(), args);
        return chain2;
    }

    private static Iterator<BindingNodeId> matchTripleStar(Iterator<BindingNodeId> chain, Var var, Tuple<Node> pattern, Args args) {
        if (SolverRX.tripleHasNodeTriple(pattern)) {
            Pair<Iterator<BindingNodeId>, Tuple<Node>> pair = SolverRX.preprocessForTripleTerms(chain, pattern, args);
            chain = pair.getLeft();
            pattern = pair.getRight();
        }
        Iterator<BindingNodeId> qIter = SolverRX.bindTripleTerm(chain, var, pattern, args);
        return qIter;
    }

    private static Pair<Iterator<BindingNodeId>, Tuple<Node>> preprocessForTripleTerms(Iterator<BindingNodeId> chain, Tuple<Node> patternTuple, Args args) {
        Tuple<Node> patternTuple2;
        Var var;
        Triple tripleTerm;
        int sIdx = SolverRX.subjectIdx(patternTuple);
        int oIdx = SolverRX.objectIdx(patternTuple);
        Node subject = patternTuple.get(sIdx);
        Node object = patternTuple.get(oIdx);
        Var subject1 = null;
        Var object1 = null;
        if (subject.isNodeTriple() && !subject.isConcrete()) {
            tripleTerm = Node_Triple.triple(subject);
            var = args.varAlloc.allocVar();
            patternTuple = SolverRX.createTuple(patternTuple, var, sIdx);
            patternTuple2 = SolverRX.tuple(patternTuple, tripleTerm);
            chain = SolverRX.matchTripleStar(chain, var, patternTuple2, args);
            subject1 = var;
        }
        if (object.isNodeTriple() && !object.isConcrete()) {
            tripleTerm = Node_Triple.triple(object);
            var = args.varAlloc.allocVar();
            patternTuple = SolverRX.createTuple(patternTuple, var, oIdx);
            patternTuple2 = SolverRX.tuple(patternTuple, tripleTerm);
            chain = SolverRX.matchTripleStar(chain, var, patternTuple2, args);
            object1 = var;
        }
        if (subject1 == null && object1 == null) {
            return Pair.create(chain, patternTuple);
        }
        return Pair.create(chain, patternTuple);
    }

    private static Iterator<BindingNodeId> bindTripleTerm(Iterator<BindingNodeId> chain, Var var, Tuple<Node> pattern, Args args) {
        NodeTable nodeTable = args.nodeTupleTable.getNodeTable();
        chain = SolverRX.matchData(chain, pattern, args);
        chain = Iter.iter(chain).map(b -> SolverRX.bindVarTripleTerm(var, pattern, b, nodeTable)).removeNulls();
        return chain;
    }

    private static BindingNodeId bindVarTripleTerm(Var var, Tuple<Node> pattern, BindingNodeId binding, NodeTable nodeTable) {
        int idx = pattern.len() == 4 ? 1 : 0;
        Node s = pattern.get(idx);
        Node s1 = SolverRX.substitute(s, binding, nodeTable);
        if (s1 == null || !s1.isConcrete()) {
            return null;
        }
        Node p = pattern.get(idx + 1);
        Node p1 = SolverRX.substitute(p, binding, nodeTable);
        if (p1 == null || !p1.isConcrete()) {
            return null;
        }
        Node o = pattern.get(idx + 2);
        Node o1 = SolverRX.substitute(o, binding, nodeTable);
        if (o1 == null || !o1.isConcrete()) {
            return null;
        }
        Node t = NodeFactory.createTripleNode(s1, p1, o1);
        NodeId tid = nodeTable.getNodeIdForNode(t);
        if (NodeId.isDoesNotExist(tid)) {
            return null;
        }
        if (binding.containsKey(var)) {
            NodeId tid2 = (NodeId)binding.get(var);
            if (tid.equals(tid2)) {
                return binding;
            }
            return null;
        }
        BindingNodeId b2 = new BindingNodeId(binding);
        b2.put(var, tid);
        return b2;
    }

    private static Node substitute(Node node, BindingNodeId binding, NodeTable nodeTable) {
        if (!Var.isVar(node)) {
            return node;
        }
        Var var = Var.alloc(node);
        try {
            NodeId id = (NodeId)binding.get(var);
            if (id == null) {
                return null;
            }
            if (NodeId.isDoesNotExist(id)) {
                return null;
            }
            Node n = nodeTable.getNodeForNodeId(id);
            if (n == null) {
                throw new TDBException("No node in NodeTable for NodeId " + id);
            }
            return n;
        }
        catch (Exception ex) {
            FmtLog.error(SolverRX.class, (Throwable)ex, "SolverRX: substitute(%s) %s", node, binding);
            return null;
        }
    }

    private static Iterator<BindingNodeId> matchData(Iterator<BindingNodeId> chain, Tuple<Node> pattern, Args args) {
        return SolverLib.solve(args.nodeTupleTable, pattern, args.anyGraph, chain, args.filter, args.execCxt);
    }

    private static Tuple<Node> createTuple(Tuple<Node> tuple, Var var, int idx) {
        switch (idx) {
            case 0: {
                return TupleFactory.create3(var, tuple.get(1), tuple.get(2));
            }
            case 1: {
                return TupleFactory.create4(tuple.get(0), var, tuple.get(2), tuple.get(3));
            }
            case 2: {
                return TupleFactory.create3(tuple.get(0), tuple.get(1), var);
            }
            case 3: {
                return TupleFactory.create4(tuple.get(0), tuple.get(1), tuple.get(2), var);
            }
        }
        throw new TDBException("Index is not recognized: " + idx);
    }

    private static int subjectIdx(Tuple<Node> pattern) {
        switch (pattern.len()) {
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
        }
        throw new TDBException("Tuple not of length 3 or 4");
    }

    private static int objectIdx(Tuple<Node> pattern) {
        switch (pattern.len()) {
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        throw new TDBException("Tuple not of length 3 or 4");
    }

    private static NodeId idFor(NodeTable nodeTable, Node node) {
        if (Var.isVar(node)) {
            return null;
        }
        return nodeTable.getNodeIdForNode(node);
    }

    private static boolean tripleHasNodeTriple(Tuple<Node> pattern) {
        int sIdx = SolverRX.subjectIdx(pattern);
        if (pattern.get(sIdx).isNodeTriple()) {
            return true;
        }
        int oIdx = SolverRX.subjectIdx(pattern);
        return pattern.get(oIdx).isNodeTriple();
    }

    private static Tuple<Node> tuple(Tuple<Node> base, Triple triple) {
        switch (base.len()) {
            case 3: {
                return TupleFactory.create3(triple.getSubject(), triple.getPredicate(), triple.getObject());
            }
            case 4: {
                return TupleFactory.create4(base.get(0), triple.getSubject(), triple.getPredicate(), triple.getObject());
            }
        }
        throw new TDBException("Tuple not of length 3 or 4");
    }

    private static class Args {
        final NodeTupleTable nodeTupleTable;
        final boolean anyGraph;
        final Predicate<Tuple<NodeId>> filter;
        final ExecutionContext execCxt;
        final VarAlloc varAlloc;

        Args(NodeTupleTable nodeTupleTable, boolean anyGraph, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
            this.nodeTupleTable = nodeTupleTable;
            this.anyGraph = anyGraph;
            this.filter = filter;
            this.execCxt = execCxt;
            this.varAlloc = SolverRX.varAlloc(execCxt);
        }
    }
}

