/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.base.objectfile;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.tdb.base.file.BufferChannel;
import org.apache.jena.tdb.base.file.FileException;
import org.apache.jena.tdb.base.objectfile.ObjectFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectFileStorage
implements ObjectFile {
    private static Logger log = LoggerFactory.getLogger(ObjectFileStorage.class);
    public static boolean logging = false;
    private final Object lockWriteBuffer = new Object();
    private final ByteBuffer writeBuffer;
    private final BufferChannel file;
    private volatile long filesize;
    private ByteBuffer writeLengthBuffer = ByteBuffer.allocate(4);

    private void log(String fmt, Object ... args) {
        if (!logging) {
            return;
        }
        log.debug(this.state() + " " + String.format(fmt, args));
    }

    public ObjectFileStorage(BufferChannel file) {
        this(file, 8192);
    }

    public ObjectFileStorage(BufferChannel file, int bufferSize) {
        this.file = file;
        this.filesize = file.size();
        this.file.position(this.filesize);
        this.log("File size: 0x%X, posn: 0x%X", this.filesize, file.position());
        this.writeBuffer = bufferSize >= 0 ? ByteBuffer.allocate(bufferSize) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long write(ByteBuffer bb) {
        this.log("W", new Object[0]);
        if (this.writeBuffer == null) {
            long x = this.rawWrite(bb);
            this.log("W -> 0x%X", x);
            return x;
        }
        int len = bb.limit() - bb.position();
        int spaceNeeded = len + 4;
        Object object = this.lockWriteBuffer;
        synchronized (object) {
            if (this.writeBuffer.position() + spaceNeeded > this.writeBuffer.capacity()) {
                this.flushOutputBuffer();
            }
            if (this.writeBuffer.position() + spaceNeeded > this.writeBuffer.capacity()) {
                long x = this.rawWrite(bb);
                if (logging) {
                    this.log("W -> 0x%X", x);
                }
                return x;
            }
            long loc = (long)this.writeBuffer.position() + this.filesize;
            this.writeBuffer.putInt(len);
            this.writeBuffer.put(bb);
            if (logging) {
                this.log("W -> 0x%X", loc);
            }
            return loc;
        }
    }

    private long rawWrite(ByteBuffer bb) {
        if (logging) {
            this.log("RW %s", bb);
        }
        int len = bb.limit() - bb.position();
        this.writeLengthBuffer.rewind();
        this.writeLengthBuffer.putInt(len);
        this.writeLengthBuffer.flip();
        long location = this.file.position();
        this.file.write(this.writeLengthBuffer);
        int x = this.file.write(bb);
        if (x != len) {
            throw new FileException();
        }
        this.filesize = this.filesize + (long)x + 4L;
        if (logging) {
            this.log("Posn: %d", this.file.position());
            this.log("RW ->0x%X", location);
        }
        return location;
    }

    private void flushOutputBuffer() {
        if (logging) {
            this.log("Flush", new Object[0]);
        }
        if (this.writeBuffer == null) {
            return;
        }
        if (this.writeBuffer.position() == 0) {
            return;
        }
        long location = this.filesize;
        this.writeBuffer.flip();
        int x = this.file.write(this.writeBuffer);
        this.filesize += (long)x;
        this.writeBuffer.clear();
    }

    @Override
    public void reposition(long posn) {
        if (posn < 0L || posn > this.length()) {
            throw new IllegalArgumentException("reposition: Bad location: " + posn);
        }
        this.flushOutputBuffer();
        this.file.truncate(posn);
        this.filesize = posn;
    }

    @Override
    public void truncate(long size) {
        this.reposition(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer read(long loc) {
        if (logging) {
            this.log("R(0x%X)", loc);
        }
        if (loc < 0L) {
            throw new IllegalArgumentException("ObjectFile.read[" + this.file.getLabel() + "]: Bad read: " + loc + "\n" + "See https://jena.apache.org/documentation/tdb/faqs.html for more information.");
        }
        if (loc >= this.filesize) {
            Object object = this.lockWriteBuffer;
            synchronized (object) {
                if (loc >= this.filesize + (long)this.writeBuffer.position()) {
                    throw new IllegalArgumentException("ObjectFileStorage.read[" + this.file.getLabel() + "]: Bad read: location=" + loc + " >= max=" + (this.filesize + (long)this.writeBuffer.position()) + "\n" + "See https://jena.apache.org/documentation/tdb/faqs.html for more information.");
                }
                int offset = (int)(loc - this.filesize);
                int len = this.writeBuffer.getInt(offset);
                int posn = offset + 4;
                ByteBuffer bb1 = ByteBuffer.allocate(len);
                for (int i = 0; i < len; ++i) {
                    bb1.put(i, this.writeBuffer.get(posn + i));
                }
                return bb1;
            }
        }
        ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
        lengthBuffer.clear();
        int x = this.file.read(lengthBuffer, loc);
        if (x != 4) {
            String msg = "ObjectFileStorage.read[" + this.file.getLabel() + "](" + loc + ")[filesize=" + this.filesize + "][file.size()=" + this.file.size() + "]: Failed to read the length : got " + x + " bytes\n" + "See https://jena.apache.org/documentation/tdb/faqs.html for more information.";
            lengthBuffer.clear();
            int x1 = this.file.read(lengthBuffer, loc);
            throw new FileException(msg);
        }
        int len = lengthBuffer.getInt(0);
        if ((long)len > this.filesize - (loc + 4L)) {
            String msg = "ObjectFileStorage.read[" + this.file.getLabel() + "](" + loc + ")[filesize=" + this.filesize + "][file.size()=" + this.file.size() + "]: Impossibly large object : " + len + " bytes > filesize-(loc+SizeOfInt)=" + (this.filesize - (loc + 4L)) + "\n" + "See https://jena.apache.org/documentation/tdb/faqs.html for more information.";
            throw new FileException(msg);
        }
        ByteBuffer bb = ByteBuffer.allocate(len);
        if (len == 0) {
            return bb;
        }
        x = this.file.read(bb, loc + 4L);
        bb.flip();
        if (x != len) {
            throw new FileException("ObjectFileStorage.read: Failed to read the object (" + len + " bytes) : got " + x + " bytes\n" + "See https://jena.apache.org/documentation/tdb/faqs.html for more information.");
        }
        return bb;
    }

    @Override
    public long length() {
        if (this.writeBuffer == null) {
            return this.filesize;
        }
        return this.filesize + (long)this.writeBuffer.position();
    }

    @Override
    public boolean isEmpty() {
        if (this.writeBuffer == null) {
            return this.filesize == 0L;
        }
        return this.writeBuffer.position() == 0 && this.filesize == 0L;
    }

    @Override
    public void close() {
        this.flushOutputBuffer();
        this.file.close();
    }

    @Override
    public void sync() {
        this.flushOutputBuffer();
        this.file.sync();
    }

    @Override
    public String getLabel() {
        return this.file.getLabel();
    }

    public String toString() {
        return this.file.getLabel();
    }

    @Override
    public Iterator<Pair<Long, ByteBuffer>> all() {
        this.flushOutputBuffer();
        ObjectIterator iter = new ObjectIterator(0L, this.filesize);
        if (this.writeBuffer == null || this.writeBuffer.position() == 0) {
            return iter;
        }
        return Iter.concat(iter, new BufferIterator(this.writeBuffer));
    }

    private String state() {
        if (this.writeBuffer == null) {
            return String.format(this.getLabel() + ": filesize=0x%X, file=(0x%X, 0x%X)", this.filesize, this.file.position(), this.file.size());
        }
        return String.format(this.getLabel() + ": filesize=0x%X, file=(0x%X, 0x%X), writeBuffer=(0x%X,0x%X)", this.filesize, this.file.position(), this.file.size(), this.writeBuffer.position(), this.writeBuffer.limit());
    }

    private class ObjectIterator
    implements Iterator<Pair<Long, ByteBuffer>> {
        private final long start;
        private final long finish;
        private long current;

        public ObjectIterator(long start, long finish) {
            this.start = start;
            this.finish = finish;
            this.current = start;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.finish;
        }

        @Override
        public Pair<Long, ByteBuffer> next() {
            long x = this.current;
            long filePosn = ObjectFileStorage.this.file.position();
            ByteBuffer bb = ObjectFileStorage.this.read(this.current);
            ObjectFileStorage.this.file.position(filePosn);
            this.current = this.current + (long)bb.limit() + 4L;
            return new Pair<Long, ByteBuffer>(x, bb);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class BufferIterator
    extends IteratorSlotted<Pair<Long, ByteBuffer>>
    implements Iterator<Pair<Long, ByteBuffer>> {
        private ByteBuffer buffer;
        private int posn;

        public BufferIterator(ByteBuffer buffer) {
            this.buffer = buffer;
            this.posn = 0;
        }

        @Override
        protected Pair<Long, ByteBuffer> moveToNext() {
            if (this.posn >= this.buffer.limit()) {
                return null;
            }
            int x = this.buffer.getInt(this.posn);
            this.posn += 4;
            ByteBuffer bb = ByteBuffer.allocate(x);
            int p = this.buffer.position();
            this.buffer.position(this.posn);
            this.buffer.get(bb.array());
            this.buffer.position(p);
            this.posn += x;
            return new Pair<Long, ByteBuffer>(Long.valueOf(x), bb);
        }

        @Override
        protected boolean hasMore() {
            return this.posn < this.buffer.limit();
        }
    }
}

