/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.lang;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarAlloc;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemLocation;
import org.apache.jena.sparql.sse.SSEParseException;
import org.apache.jena.sparql.sse.lang.ParseHandler;

public class ParseHandlerPlain
implements ParseHandler {
    private Deque<Node> tripleTermStack = new ArrayDeque<Node>();
    private int inTripleTermDepth = 0;
    private ListStack listStack = new ListStack();
    private Item currentItem = null;
    private int depth = 0;
    private LabelToNode bNodeLabels = LabelToNode.createScopeGlobal();
    private VarAlloc varAlloc = new VarAlloc("_");
    private VarAlloc varAllocND = new VarAlloc("?");
    private VarAlloc varAllocIntern = new VarAlloc(".");

    @Override
    public Item getItem() {
        return this.currentItem;
    }

    @Override
    public void parseStart() {
        this.depth = 0;
    }

    @Override
    public void parseFinish() {
        if (this.depth != 0) {
            Log.warn(this, "Stack error: depth =" + this.depth + " at end of parse run");
        }
        this.depth = -1;
    }

    @Override
    public void listStart(int line, int column) {
        ItemList list = new ItemList(line, column);
        this.pushList(list);
        this.setCurrentItem(Item.createList(list));
    }

    @Override
    public void listFinish(int line, int column) {
        ItemList list = this.popList();
        Item item = Item.createList(list);
        this.listAdd(item);
    }

    protected void setCurrentItem(Item item) {
        this.currentItem = item;
    }

    protected void node(Node node, int line, int column) {
        if (this.inTripleTermDepth > 0) {
            this.tripleTermStack.addLast(node);
            return;
        }
        Item item = Item.createNode(node, line, column);
        this.listAdd(item);
    }

    protected void listAdd(Item item) {
        if (this.listStack.isEmpty()) {
            this.setCurrentItem(item);
            return;
        }
        if (item != null) {
            ItemList list = this.currentList();
            list.add(item);
        }
        this.setCurrentItem(item);
    }

    @Override
    public void emitSymbol(int line, int column, String symbol2) {
        this.listAdd(Item.createSymbol(symbol2, line, column));
    }

    @Override
    public void emitVar(int line, int column, String varName) {
        Var var = null;
        switch (varName) {
            case "": {
                var = this.varAlloc.allocVar();
                break;
            }
            case "?": {
                var = this.varAllocND.allocVar();
                break;
            }
            case ".": {
                var = this.varAllocIntern.allocVar();
                break;
            }
            default: {
                var = Var.alloc(varName);
            }
        }
        this.node(var, line, column);
    }

    @Override
    public void emitLiteral(int line, int column, String lexicalForm, String langTag, String datatypeIRI, String datatypePN) {
        Node n = null;
        if (datatypeIRI != null || datatypePN != null) {
            if (datatypePN != null) {
                datatypeIRI = this.resolvePrefixedName(datatypePN, line, column);
            }
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatypeIRI);
            n = NodeFactory.createLiteral(lexicalForm, dType);
        } else {
            n = NodeFactory.createLiteral(lexicalForm, langTag);
        }
        this.node(n, line, column);
    }

    @Override
    public final void emitBNode(int line, int column, String label) {
        Node n = null;
        n = label.equals("") ? NodeFactory.createBlankNode() : (Node)this.bNodeLabels.get(null, label);
        this.node(n, line, column);
    }

    @Override
    public void emitIRI(int line, int column, String iriStr) {
        Node n = RiotLib.createIRIorBNode(iriStr);
        this.node(n, line, column);
    }

    @Override
    public void emitPName(int line, int column, String pname) {
        String iriStr = this.resolvePrefixedName(pname, line, column);
        this.emitIRI(line, column, iriStr);
    }

    @Override
    public void tripleTermStart(int line, int column) {
        ++this.inTripleTermDepth;
    }

    @Override
    public void tripleTermFinish(int line, int column) {
        Node o = this.tripleTermStack.removeLast();
        Node p = this.tripleTermStack.removeLast();
        Node s = this.tripleTermStack.removeLast();
        Node n = NodeFactory.createTripleNode(s, p, o);
        --this.inTripleTermDepth;
        if (this.inTripleTermDepth == 0 && !this.tripleTermStack.isEmpty()) {
            Log.warn(this, "Triple Term Stack error: stack not empty");
        }
        this.node(n, line, column);
    }

    protected ItemList currentList() {
        return this.listStack.getCurrent();
    }

    protected ItemList popList() {
        --this.depth;
        this.setCurrentItem(null);
        return this.listStack.pop();
    }

    protected void pushList(ItemList list) {
        this.listStack.push(list);
        ++this.depth;
    }

    protected String resolvePrefixedName(String pname, int line, int column) {
        return "pname:" + pname;
    }

    protected static void throwException(String msg, int line, int column) {
        throw new SSEParseException("[" + line + ", " + column + "] " + msg, line, column);
    }

    protected static void throwException(String msg, ItemLocation loc) {
        ParseHandlerPlain.throwException(msg, loc.getLine(), loc.getColumn());
    }

    protected static class ListStack {
        private Deque<ItemList> stack = new ArrayDeque<ItemList>();

        protected ListStack() {
        }

        boolean isEmpty() {
            return this.stack.size() == 0;
        }

        ItemList getCurrent() {
            if (this.stack.size() == 0) {
                return null;
            }
            return this.stack.peek();
        }

        void push(ItemList list) {
            this.stack.push(list);
        }

        ItemList pop() {
            return this.stack.pop();
        }
    }
}

