/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.lang;

import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.lang.ParseHandler;

public class ParseHandlerDebug
implements ParseHandler {
    int count = 0;

    private void indent() {
        for (int i = 0; i < this.count; ++i) {
            System.out.print("  ");
        }
    }

    private void line(int line, int column) {
        System.out.print("[" + line + ", " + column + "]  ");
        this.indent();
    }

    @Override
    public Item getItem() {
        return null;
    }

    @Override
    public void parseStart() {
        System.out.println("<<<<");
    }

    @Override
    public void parseFinish() {
        System.out.println(">>>>");
    }

    @Override
    public void listStart(int line, int column) {
        this.line(line, column);
        ++this.count;
        System.out.println("(");
    }

    @Override
    public void listFinish(int line, int column) {
        --this.count;
        this.line(line, column);
        System.out.println(")");
    }

    @Override
    public void emitBNode(int line, int column, String label) {
        this.line(line, column);
        System.out.println("BNode: " + label);
    }

    @Override
    public void emitIRI(int line, int column, String iriStr) {
        this.line(line, column);
        System.out.println("IRI: " + iriStr);
    }

    @Override
    public void emitLiteral(int line, int column, String lex, String lang, String datatype_iri, String datatype_pn) {
        this.line(line, column);
        if (lang != null) {
            System.out.println("Literal: " + lex + " @" + lang);
        } else if (datatype_iri != null) {
            System.out.println("Literal: " + lex + " ^^" + datatype_iri);
        } else if (datatype_pn != null) {
            System.out.println("Literal: " + lex + " ^^" + datatype_pn);
        }
    }

    @Override
    public void emitPName(int line, int column, String pname) {
        this.line(line, column);
        System.out.println("PName: " + pname);
    }

    @Override
    public void emitSymbol(int line, int column, String symbol2) {
        this.line(line, column);
        System.out.println("Symbol: " + symbol2);
    }

    @Override
    public void emitVar(int line, int column, String varName) {
        this.line(line, column);
        System.out.println("Var: " + varName);
    }

    @Override
    public void tripleTermStart(int line, int column) {
        this.line(line, column);
        System.out.println("<<");
    }

    @Override
    public void tripleTermFinish(int line, int column) {
        this.line(line, column);
        System.out.println(">>");
    }
}

