/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemTransform;
import org.apache.jena.sparql.sse.ItemVisitor;

public class ItemTransformer {
    public static Item transform(ItemTransform transform, Item item) {
        TransformerApply v = new TransformerApply(transform);
        item.visit(v);
        return v.result();
    }

    static class TransformerApply
    implements ItemVisitor {
        Deque<Item> stack = new ArrayDeque<Item>();
        private ItemTransform transform;

        private void push(Item item) {
            this.stack.push(item);
        }

        private Item pop() {
            return this.stack.pop();
        }

        public TransformerApply(ItemTransform transform) {
            this.transform = transform;
        }

        public Item result() {
            return this.stack.peek();
        }

        @Override
        public void visit(Item item, ItemList list) {
            ItemList newList = new ItemList(item.getLine(), item.getColumn());
            for (Item subItem : list) {
                subItem.visit(this);
                Item newItem = this.pop();
                newList.add(newItem);
            }
            Item newItemList = Item.createList(newList, item.getLine(), item.getColumn());
            this.push(newItemList);
        }

        @Override
        public void visit(Item item, Node node) {
            Item newItem = this.transform.transform(item, node);
            this.push(newItem);
        }

        @Override
        public void visit(Item item, String symbol2) {
            Item newItem = this.transform.transform(item, symbol2);
            this.push(newItem);
        }

        @Override
        public void visitNil() {
            this.push(Item.nil);
        }
    }
}

