/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.path;

import java.io.StringReader;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.lang.arq.ARQParser;
import org.apache.jena.sparql.lang.arq.ParseException;
import org.apache.jena.sparql.lang.arq.TokenMgrError;
import org.apache.jena.sparql.path.Path;

public class PathParser {
    public static Path parse(String str2, PrefixMapping pmap) {
        return PathParser.parse(str2, new Prologue(pmap));
    }

    public static Path parse(String str2, Prologue prologue) {
        Query query = new Query(prologue);
        StringReader in = new StringReader(str2);
        ARQParser parser2 = new ARQParser(in);
        try {
            query.setStrict(true);
            parser2.setQuery(query);
            return parser2.PathUnit();
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser2.token.endColumn;
            int line = parser2.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), (Throwable)err, -1, -1);
        }
        catch (Throwable th) {
            Log.warn(PathParser.class, "Unexpected throwable: ", th);
            throw new QueryException(th.getMessage(), th);
        }
    }
}

