/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang;

import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.lang.UpdateParser;
import org.apache.jena.sparql.lang.sparql_11.ParseException;
import org.apache.jena.sparql.lang.sparql_11.SPARQLParser11;
import org.apache.jena.sparql.lang.sparql_11.TokenMgrError;
import org.apache.jena.sparql.modify.UpdateSink;
import org.apache.jena.update.UpdateException;
import org.slf4j.LoggerFactory;

public class ParserSPARQL11Update
extends UpdateParser {
    @Override
    protected void parse$(UpdateSink sink, String updateString) {
        StringReader r = new StringReader(updateString);
        this._parse(sink, r);
    }

    @Override
    protected void parse$(UpdateSink sink, Reader r) {
        this._parse(sink, r);
    }

    public void parse(UpdateSink sink, Reader r) {
        if (r instanceof FileReader) {
            LoggerFactory.getLogger(this.getClass()).warn("FileReader passed to ParserSPARQL11Update.parse - use a FileInputStream");
        }
        this._parse(sink, r);
    }

    private void _parse(UpdateSink sink, Reader r) {
        SPARQLParser11 parser2 = null;
        try {
            parser2 = new SPARQLParser11(r);
            parser2.setUpdateSink(sink);
            parser2.UpdateUnit();
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser2.token.endColumn;
            int line = parser2.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (UpdateException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), (Throwable)err, -1, -1);
        }
        catch (Throwable th) {
            Log.error(this, "Unexpected throwable: ", th);
            throw new QueryException(th.getMessage(), th);
        }
    }
}

