/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import java.util.List;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionBase;

public class FN_AdjustDateToTimezone
extends FunctionBase {
    @Override
    public void checkBuild(String uri, ExprList args) {
        if (args.size() != 1 && args.size() != 2) {
            throw new QueryBuildException("Function '" + Lib.className(this) + "' takes one or two arguments");
        }
    }

    @Override
    public NodeValue exec(List<NodeValue> args) {
        if (args.size() != 1 && args.size() != 2) {
            throw new ExprEvalException("fn:adjustDateToTimezone: Wrong number of arguments: " + args.size() + " : [wanted 1 or 2]");
        }
        NodeValue v1 = args.get(0);
        if (ARQ.isStrictMode() && !v1.isDate()) {
            throw new ExprEvalException("Not an xsd:date : " + v1);
        }
        if (args.size() == 2) {
            NodeValue v2 = args.get(1);
            return XSDFuncOp.adjustDatetimeToTimezone(v1, v2);
        }
        return XSDFuncOp.adjustDatetimeToTimezone(v1, null);
    }
}

