/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;
import org.apache.jena.sparql.util.FmtUtils;

public class NodeValueLang
extends NodeValue {
    private final String string;
    private final String lang;

    public NodeValueLang(String lex, String lang) {
        this.string = Objects.requireNonNull(lex);
        this.lang = Objects.requireNonNull(lang);
        if (lang.isEmpty()) {
            throw new IllegalArgumentException("lang is the empty string");
        }
    }

    public NodeValueLang(Node n) {
        super(Objects.requireNonNull(n));
        this.string = n.getLiteralLexicalForm();
        this.lang = n.getLiteralLanguage();
    }

    @Override
    public boolean isLangString() {
        return true;
    }

    @Override
    public String getString() {
        return this.string;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public String asString() {
        return this.string;
    }

    @Override
    protected Node makeNode() {
        return NodeFactory.createLiteral(this.string, this.lang);
    }

    @Override
    public String toString() {
        if (this.getNode() != null) {
            return FmtUtils.stringForNode(this.getNode());
        }
        return "'" + this.getString() + "'@" + this.lang;
    }

    @Override
    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

