/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalNotSupported;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeUtils;

public class DatasetImpl
implements Dataset {
    protected final DatasetGraph dsg;
    private final Transactional transactional;

    public static Dataset wrap(DatasetGraph datasetGraph) {
        return new DatasetImpl(datasetGraph);
    }

    protected DatasetImpl(DatasetGraph dsg) {
        this(dsg, dsg.supportsTransactions() ? dsg : new TransactionalNotSupported());
    }

    protected DatasetImpl(DatasetGraph dsg, Transactional transactional) {
        this.dsg = dsg;
        this.transactional = transactional;
    }

    public DatasetImpl(Model model) {
        this.dsg = DatasetGraphFactory.create(model.getGraph());
        this.transactional = this.dsg;
    }

    @Deprecated
    public DatasetImpl(Dataset ds) {
        this(DatasetGraphFactory.cloneStructure(ds.asDatasetGraph()));
    }

    @Override
    public Model getDefaultModel() {
        return ModelFactory.createModelForGraph(this.dsg.getDefaultGraph());
    }

    @Override
    public Model getUnionModel() {
        return ModelFactory.createModelForGraph(this.dsg.getUnionGraph());
    }

    @Override
    public Lock getLock() {
        return this.dsg.getLock();
    }

    @Override
    public Context getContext() {
        return this.dsg.getContext();
    }

    @Override
    public boolean supportsTransactions() {
        return this.dsg.supportsTransactions();
    }

    @Override
    public boolean supportsTransactionAbort() {
        return this.dsg.supportsTransactionAbort();
    }

    @Override
    public void begin() {
        this.checkTransactional();
        this.transactional.begin();
    }

    @Override
    public void begin(TxnType txnType) {
        this.checkTransactional();
        this.transactional.begin(txnType);
    }

    @Override
    public void begin(ReadWrite mode) {
        this.checkTransactional();
        this.transactional.begin(mode);
    }

    @Override
    public boolean promote(Transactional.Promote txnType) {
        this.checkTransactional();
        return this.transactional.promote(txnType);
    }

    @Override
    public ReadWrite transactionMode() {
        this.checkTransactional();
        return this.transactional.transactionMode();
    }

    @Override
    public TxnType transactionType() {
        this.checkTransactional();
        return this.transactional.transactionType();
    }

    @Override
    public boolean isInTransaction() {
        return this.transactional != null && this.transactional.isInTransaction();
    }

    @Override
    public void commit() {
        this.checkTransactional();
        this.transactional.commit();
    }

    @Override
    public void abort() {
        this.checkTransactional();
        this.transactional.abort();
    }

    @Override
    public void end() {
        this.checkTransactional();
        this.transactional.end();
    }

    private void checkTransactional() {
        if (!this.supportsTransactions()) {
            throw new UnsupportedOperationException("Transactions not supported");
        }
    }

    @Override
    public DatasetGraph asDatasetGraph() {
        return this.dsg;
    }

    @Override
    public Model getNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI(uri);
        return this.graph2model(this.dsg.getGraph(n));
    }

    @Override
    public Dataset addNamedModel(String uri, Model model) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI(uri);
        this.dsg.addGraph(n, model.getGraph());
        return this;
    }

    @Override
    public Dataset removeNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI(uri);
        this.dsg.removeGraph(n);
        return this;
    }

    @Override
    public Dataset replaceNamedModel(String uri, Model model) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI(uri);
        this.dsg.removeGraph(n);
        this.dsg.addGraph(n, model.getGraph());
        return this;
    }

    @Override
    public Dataset setDefaultModel(Model model) {
        if (model == null) {
            model = ModelFactory.createDefaultModel();
        }
        this.dsg.setDefaultGraph(model.getGraph());
        return this;
    }

    @Override
    public boolean containsNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI(uri);
        return this.dsg.containsGraph(n);
    }

    @Override
    public Iterator<String> listNames() {
        return NodeUtils.nodesToURIs(this.dsg.listGraphNodes());
    }

    @Override
    public void close() {
        this.dsg.close();
    }

    protected Model graph2model(Graph graph) {
        if (graph == null) {
            return null;
        }
        return ModelFactory.createModelForGraph(graph);
    }

    protected static void checkGraphName(String uri) {
        if (uri == null) {
            throw new ARQException("null for graph name");
        }
    }

    @Override
    public boolean isEmpty() {
        return this.dsg.isEmpty();
    }
}

