/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.thrift.RiotThriftException;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.ThriftConvert;
import org.apache.jena.riot.thrift.wire.RDF_DataTuple;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.jena.riot.thrift.wire.RDF_VAR;
import org.apache.jena.riot.thrift.wire.RDF_VarTuple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransportException;

public class Thift2Binding
extends IteratorSlotted<Binding>
implements Iterator<Binding> {
    private List<Var> vars = new ArrayList<Var>();
    private List<String> varNames = new ArrayList<String>();
    private final RDF_DataTuple row = new RDF_DataTuple();
    private InputStream in;
    private TProtocol protocol;

    public Thift2Binding(InputStream in) {
        this.in = in;
        TIOStreamTransport transport = new TIOStreamTransport(in);
        this.protocol = TRDF.protocol(transport);
        this.readVars();
    }

    public Thift2Binding(TProtocol out) {
        this.in = null;
        this.protocol = out;
        this.readVars();
    }

    private void readVars() {
        RDF_VarTuple vrow = new RDF_VarTuple();
        try {
            vrow.read(this.protocol);
        }
        catch (TException e2) {
            TRDF.exception(e2);
        }
        if (vrow.getVars() != null) {
            for (RDF_VAR rv : vrow.getVars()) {
                String vn = rv.getName();
                this.varNames.add(vn);
            }
        }
        this.vars = Var.varList(this.varNames);
    }

    public List<Var> getVars() {
        return this.vars;
    }

    public List<String> getVarNames() {
        return this.varNames;
    }

    @Override
    protected Binding moveToNext() {
        try {
            this.row.read(this.protocol);
        }
        catch (TTransportException e2) {
            return null;
        }
        catch (TException e3) {
            TRDF.exception(e3);
        }
        if (this.row.getRowSize() != this.vars.size()) {
            throw new RiotThriftException(String.format("Vars %d : Row length : %d", this.vars.size(), this.row.getRowSize()));
        }
        BindingMap b = BindingFactory.create();
        for (int i = 0; i < this.vars.size(); ++i) {
            Var v = this.vars.get(i);
            RDF_Term rt = this.row.getRow().get(i);
            if (rt.isSetUndefined()) continue;
            Node n = ThriftConvert.convert(rt);
            b.add(v, n);
        }
        this.row.clear();
        return b;
    }

    @Override
    protected boolean hasMore() {
        return true;
    }
}

