/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.vocabulary.RDF;

public class ReaderTriX
implements ReaderRIOT {
    private final ErrorHandler errorHandler;
    private final ParserProfile profile;
    private static String nsRDF = RDF.getURI();
    private static String nsXSD = "http://www.w3.org/2001/XMLSchema";
    private static String nsXML0 = "http://www.w3.org/XML/1998/namespace";
    private static String rdfXMLLiteral = RDF.xmlLiteral.getURI();

    public ReaderTriX(ParserProfile profile, ErrorHandler errorHandler) {
        this.profile = profile;
        this.errorHandler = errorHandler;
    }

    @Override
    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        XMLStreamReader xReader;
        XMLInputFactory xf = XMLInputFactory.newInstance();
        try {
            xReader = xf.createXMLStreamReader(in);
        }
        catch (XMLStreamException e2) {
            throw new RiotException("Can't initialize StAX parsing engine", e2);
        }
        this.read(xReader, baseURI, output);
    }

    @Override
    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        XMLStreamReader xReader;
        XMLInputFactory xf = XMLInputFactory.newInstance();
        try {
            xReader = xf.createXMLStreamReader(reader);
        }
        catch (XMLStreamException e2) {
            throw new ResultSetException("Can't initialize StAX parsing engine", e2);
        }
        this.read(xReader, baseURI, output);
    }

    private void read(XMLStreamReader parser2, String baseURI, StreamRDF output) {
        State state = State.OUTER;
        Node g = null;
        ArrayList<Node> terms = new ArrayList<Node>();
        try {
            while (parser2.hasNext()) {
                int event = parser2.next();
                block1 : switch (event) {
                    case 13: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        if (state != State.OUTER) {
                            this.staxError(parser2.getLocation(), "End of document while processing XML element");
                        }
                        return;
                    }
                    case 2: {
                        String tag;
                        switch (tag = parser2.getLocalName()) {
                            case "triple": {
                                int line = parser2.getLocation().getLineNumber();
                                int col = parser2.getLocation().getColumnNumber();
                                if (terms.size() != 3) {
                                    this.staxError(parser2.getLocation(), "Wrong number of terms for a triple. Want 3, got " + terms.size());
                                }
                                Node s = (Node)terms.get(0);
                                Node p = (Node)terms.get(1);
                                Node o = (Node)terms.get(2);
                                if (p.isLiteral()) {
                                    this.staxError(parser2.getLocation(), "Predicate is a literal");
                                }
                                if (s.isLiteral()) {
                                    this.staxError(parser2.getLocation(), "Subject is a literal");
                                }
                                if (g == null) {
                                    Triple t = this.profile.createTriple(s, p, o, line, col);
                                    output.triple(t);
                                } else {
                                    if (g.isLiteral()) {
                                        this.staxError(parser2.getLocation(), "graph name is a literal");
                                    }
                                    Quad q = this.profile.createQuad(g, s, p, o, line, col);
                                    output.quad(q);
                                }
                                terms.clear();
                                state = State.GRAPH;
                                break block1;
                            }
                            case "graph": {
                                state = State.TRIX;
                                g = null;
                                break block1;
                            }
                            case "trix": 
                            case "TriX": {
                                state = State.OUTER;
                            }
                        }
                        break;
                    }
                    case 1: {
                        String tag;
                        switch (tag = parser2.getLocalName()) {
                            case "trix": 
                            case "TriX": {
                                if (state != State.OUTER) {
                                    this.staxErrorOutOfPlaceElement(parser2);
                                }
                                state = State.TRIX;
                                break block1;
                            }
                            case "graph": {
                                if (state != State.TRIX) {
                                    this.staxErrorOutOfPlaceElement(parser2);
                                }
                                state = State.GRAPH;
                                break block1;
                            }
                            case "triple": {
                                if (state != State.GRAPH) {
                                    this.staxErrorOutOfPlaceElement(parser2);
                                }
                                state = State.TRIPLE;
                                break block1;
                            }
                            case "id": 
                            case "qname": 
                            case "uri": {
                                if (state != State.GRAPH && state != State.TRIPLE) {
                                    this.staxErrorOutOfPlaceElement(parser2);
                                }
                                Node n = this.term(parser2, this.profile);
                                if (state == State.GRAPH) {
                                    if (g != null) {
                                        this.staxError(parser2.getLocation(), "Duplicate graph name");
                                    }
                                    if (!(g = n).isLiteral()) break block1;
                                    this.staxError(parser2.getLocation(), "graph name is a literal");
                                    break block1;
                                }
                                this.add(terms, n, 3, parser2);
                                break block1;
                            }
                            case "plainLiteral": 
                            case "typedLiteral": {
                                if (state != State.TRIPLE) {
                                    this.staxErrorOutOfPlaceElement(parser2);
                                }
                                Node n = this.term(parser2, this.profile);
                                this.add(terms, n, 3, parser2);
                                break block1;
                            }
                        }
                        this.staxError(parser2.getLocation(), "Unrecognized XML element: " + this.qnameAsString(parser2.getName()));
                    }
                }
            }
            this.staxError("Premature end of file");
            return;
        }
        catch (XMLStreamException ex) {
            this.staxError(parser2.getLocation(), "XML error: " + ex.getMessage());
            return;
        }
    }

    private void add(Collection<Node> acc, Node node, int max2, XMLStreamReader parser2) {
        if (acc.size() >= max2) {
            this.staxError(parser2.getLocation(), "Too many terms for a triple: " + node);
        }
        acc.add(node);
    }

    private void staxErrorOutOfPlaceElement(XMLStreamReader parser2) {
        this.staxError(parser2.getLocation(), "Out of place XML element: " + this.tagName(parser2));
    }

    private Node term(XMLStreamReader parser2, ParserProfile profile) throws XMLStreamException {
        String tag = parser2.getLocalName();
        int line = parser2.getLocation().getLineNumber();
        int col = parser2.getLocation().getColumnNumber();
        switch (tag) {
            case "uri": {
                String x = parser2.getElementText();
                Node n = profile.createURI(x, line, col);
                return n;
            }
            case "qname": {
                String x = parser2.getElementText();
                int idx = x.indexOf(58);
                if (idx == -1) {
                    this.staxError(parser2.getLocation(), "Expected ':' in prefixed name.  Found " + x);
                }
                String[] y = x.split(":", 2);
                String prefUri = parser2.getNamespaceURI(y[0]);
                String local = y[1];
                return profile.createURI(prefUri + local, line, col);
            }
            case "id": {
                String x = parser2.getElementText();
                return profile.createBlankNode(null, x, line, col);
            }
            case "plainLiteral": {
                int x = parser2.getAttributeCount();
                if (x > 1) {
                    this.staxError(parser2.getLocation(), "Multiple attributes : only one allowed");
                }
                String lang = null;
                if (x == 1) {
                    lang = this.attribute(parser2, nsXML0, "lang");
                }
                String lex = parser2.getElementText();
                if (lang == null) {
                    return profile.createStringLiteral(lex, line, col);
                }
                return profile.createLangLiteral(lex, lang, line, col);
            }
            case "typedLiteral": {
                String dt;
                int nAttr = parser2.getAttributeCount();
                if (nAttr != 1) {
                    this.staxError(parser2.getLocation(), "Multiple attributes : only one allowed");
                }
                if ((dt = this.attribute(parser2, "http://www.w3.org/2004/03/trix/trix-1/", "datatype")) == null) {
                    this.staxError(parser2.getLocation(), "No datatype attribute");
                }
                RDFDatatype rdt = NodeFactory.getType(dt);
                String lex = rdfXMLLiteral.equals(dt) ? this.slurpRDFXMLLiteral(parser2) : parser2.getElementText();
                return profile.createTypedLiteral(lex, rdt, line, col);
            }
        }
        QName qname = parser2.getName();
        this.staxError(parser2.getLocation(), "Unrecognized tag -- " + this.qnameAsString(qname));
        return null;
    }

    private String slurpRDFXMLLiteral(XMLStreamReader parser2) throws XMLStreamException {
        StringBuffer content = new StringBuffer();
        int depth = 0;
        while (parser2.hasNext()) {
            int event = parser2.next();
            switch (event) {
                case 1: {
                    int i;
                    QName qname = parser2.getName();
                    content.append("<");
                    content.append(this.qnameAsString(qname));
                    int N = parser2.getNamespaceCount();
                    for (i = 0; i < N; ++i) {
                        String p = parser2.getNamespacePrefix(i);
                        p = p == null ? "xmlns" : "xmlns:" + p;
                        String v = parser2.getNamespaceURI(i);
                        content.append(" ");
                        content.append(p);
                        content.append("=\"");
                        content.append(v);
                        content.append("\"");
                    }
                    N = parser2.getAttributeCount();
                    for (i = 0; i < N; ++i) {
                        QName name = parser2.getAttributeName(i);
                        String a = this.qnameAsString(name);
                        String v = parser2.getAttributeValue(i);
                        content.append(" ");
                        content.append(a);
                        content.append("=\"");
                        content.append(v);
                        content.append("\"");
                    }
                    content.append(">");
                    ++depth;
                    break;
                }
                case 2: {
                    if (--depth == -1) {
                        return content.toString();
                    }
                    QName qname = parser2.getName();
                    String x = this.qnameAsString(qname);
                    content.append("</" + x + ">");
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 12: {
                    content.append(parser2.getText());
                    break;
                }
                case 8: {
                    this.staxError(parser2.getLocation(), "End of file");
                }
            }
        }
        this.staxError(parser2.getLocation(), "End of file");
        return null;
    }

    private String tagName(XMLStreamReader parser2) {
        return this.qnameAsString(parser2.getName());
    }

    private String qnameAsString(QName qname) {
        String x = qname.getPrefix();
        if (x == null || x.isEmpty()) {
            return qname.getLocalPart();
        }
        return x + ":" + qname.getLocalPart();
    }

    private String attribute(XMLStreamReader parser2, String nsURI, String localname2) {
        int x = parser2.getAttributeCount();
        if (x > 1) {
            this.staxError(parser2.getLocation(), "Multiple attributes : only one allowed : " + this.tagName(parser2));
        }
        if (x == 0) {
            return null;
        }
        String attrPX = parser2.getAttributePrefix(0);
        String attrNS = parser2.getAttributeNamespace(0);
        if (attrNS == null) {
            attrNS = parser2.getName().getNamespaceURI();
        }
        String attrLN = parser2.getAttributeLocalName(0);
        if (!Objects.equals(nsURI, attrNS) || !Objects.equals(attrLN, localname2)) {
            this.staxError(parser2.getLocation(), "Unexpected attribute : " + attrPX + ":" + attrLN + " at " + this.tagName(parser2));
        }
        String attrVal = parser2.getAttributeValue(0);
        return attrVal;
    }

    private void staxError(String msg) {
        this.staxError(-1, -1, msg);
    }

    private void staxError(Location loc, String msg) {
        this.staxError(loc.getLineNumber(), loc.getColumnNumber(), msg);
    }

    private void staxError(int line, int col, String msg) {
        this.errorHandler.error(msg, line, col);
    }

    static enum State {
        OUTER,
        TRIX,
        GRAPH,
        TRIPLE;

    }

    public static class ReaderRIOTFactoryTriX
    implements ReaderRIOTFactory {
        @Override
        public ReaderRIOT create(Lang language, ParserProfile profile) {
            return new ReaderTriX(profile, profile.getErrorHandler());
        }
    }
}

