/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.n3.N3JenaWriter;
import org.apache.jena.n3.N3TurtleJenaWriter;
import org.apache.jena.rdf.model.RDFWriter;
import org.apache.jena.rdf.model.RDFWriterF;
import org.apache.jena.rdf.model.impl.NTripleWriter;
import org.apache.jena.rdfxml.xmloutput.impl.Abbreviated;
import org.apache.jena.rdfxml.xmloutput.impl.Basic;
import org.apache.jena.shared.ConfigException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.NoWriterForLangException;

public class RDFWriterFImpl
implements RDFWriterF {
    public static final String DEFAULTLANG = "RDF/XML";
    private static Map<String, Class<? extends RDFWriter>> custom = new LinkedHashMap<String, Class<? extends RDFWriter>>();
    private static RDFWriterF rewiredAlternative = null;

    public static void alternative(RDFWriterF other) {
        rewiredAlternative = other;
    }

    @Override
    public RDFWriter getWriter() {
        return this.getWriter(DEFAULTLANG);
    }

    @Override
    public RDFWriter getWriter(String lang) {
        Class<? extends RDFWriter> c;
        if (rewiredAlternative != null) {
            return rewiredAlternative.getWriter(lang);
        }
        if (lang == null || lang.equals("")) {
            lang = DEFAULTLANG;
        }
        if ((c = custom.get(lang)) == null) {
            throw new NoWriterForLangException("Writer not found: " + lang);
        }
        try {
            return c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw new JenaException(e2);
        }
    }

    @Override
    @Deprecated
    public String setWriterClassName(String lang, String className) {
        return RDFWriterFImpl.setBaseWriterClassName(lang, className);
    }

    @Deprecated
    public static String setBaseWriterClassName(String lang, String className) {
        if (rewiredAlternative != null) {
            Log.error(RDFWriterFImpl.class, "Rewired RDFWriterFImpl2 - configuration changes have no effect on writing");
        }
        String oldClassName = RDFWriterFImpl.currentEntry(lang);
        try {
            Class<?> newClass = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            custom.put(lang, newClass);
            return oldClassName;
        }
        catch (ClassNotFoundException e2) {
            throw new ConfigException("Reader not found on classpath", e2);
        }
        catch (Exception e3) {
            throw new JenaException(e3);
        }
    }

    @Override
    public void resetRDFWriterF() {
        RDFWriterFImpl.reset();
    }

    @Override
    public String removeWriter(String lang) throws IllegalArgumentException {
        return RDFWriterFImpl.remove(lang);
    }

    private static void reset() {
        Class<Basic> rdfxmlWriter = Basic.class;
        Class<Abbreviated> rdfxmlAbbrevWriter = Abbreviated.class;
        Class<NTripleWriter> ntWriter = NTripleWriter.class;
        Class<N3TurtleJenaWriter> ttlWriter = N3TurtleJenaWriter.class;
        custom.put(DEFAULTLANG, rdfxmlWriter);
        custom.put("RDF/XML-ABBREV", rdfxmlAbbrevWriter);
        custom.put("N-TRIPLE", ntWriter);
        custom.put("N-TRIPLES", ntWriter);
        custom.put("N-Triples", ntWriter);
        custom.put("N3", N3JenaWriter.class);
        custom.put("TURTLE", ttlWriter);
        custom.put("Turtle", ttlWriter);
        custom.put("TTL", ttlWriter);
    }

    private static String currentEntry(String lang) {
        Class<? extends RDFWriter> oldClass = custom.get(lang);
        if (oldClass != null) {
            return oldClass.getName();
        }
        return null;
    }

    private static String remove(String lang) {
        if (rewiredAlternative != null) {
            Log.error(RDFWriterFImpl.class, "Rewired RDFWriterFImpl2 - configuration changes have no effect on writing");
        }
        String oldClassName = RDFWriterFImpl.currentEntry(lang);
        custom.remove(lang);
        return oldClassName;
    }

    static {
        RDFWriterFImpl.reset();
    }
}

