/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.n3.turtle;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Locale;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.n3.turtle.TurtleEventHandler;
import org.apache.jena.n3.turtle.TurtleParseException;

public class Turtle2NTriples
implements TurtleEventHandler {
    PrintStream out = System.out;
    static boolean applyUnicodeEscapes = true;

    public Turtle2NTriples(PrintStream out) {
        this.out = out;
    }

    @Override
    public void triple(int line, int col, Triple triple) {
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        if (!s.isURI() && !s.isBlank()) {
            throw new TurtleParseException("[" + line + ", " + col + "] : Error: Subject is not a URI or blank node");
        }
        if (!p.isURI()) {
            throw new TurtleParseException("[" + line + ", " + col + "] : Error: Predicate is not a URI");
        }
        if (!(o.isURI() || o.isBlank() || o.isLiteral())) {
            throw new TurtleParseException("[" + line + ", " + col + "] : Error: Object is not a URI, blank node or literal");
        }
        this.outputNode(s);
        this.out.print(" ");
        this.outputNode(p);
        this.out.print(" ");
        this.outputNode(o);
        this.out.print(" .");
        this.out.println();
        this.out.flush();
    }

    private void outputNode(Node node) {
        if (node.isURI()) {
            this.out.print("<");
            this.out.print(node.getURI());
            this.out.print(">");
            return;
        }
        if (node.isBlank()) {
            this.out.print("_:");
            this.out.print(node.getBlankNodeLabel());
            return;
        }
        if (node.isLiteral()) {
            this.out.print('\"');
            this.outputEsc(node.getLiteralLexicalForm());
            this.out.print('\"');
            if (node.getLiteralLanguage() != null && node.getLiteralLanguage().length() > 0) {
                this.out.print('@');
                this.out.print(node.getLiteralLanguage());
            }
            if (node.getLiteralDatatypeURI() != null) {
                this.out.print("^^<");
                this.out.print(node.getLiteralDatatypeURI());
                this.out.print(">");
            }
            return;
        }
        Log.error(this, "Illegal node: " + node);
    }

    @Override
    public void startFormula(int line, int col) {
        throw new TurtleParseException("[" + line + ", " + col + "] : Error: Formula found");
    }

    @Override
    public void endFormula(int line, int col) {
        throw new TurtleParseException("[" + line + ", " + col + "] : Error: Formula found");
    }

    @Override
    public void prefix(int line, int col, String prefix, String iri) {
    }

    private static void writeString(String s, PrintWriter writer) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                writer.print('\\');
                writer.print(c);
                continue;
            }
            if (c == '\n') {
                writer.print("\\n");
                continue;
            }
            if (c == '\r') {
                writer.print("\\r");
                continue;
            }
            if (c == '\t') {
                writer.print("\\t");
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                writer.print(c);
                continue;
            }
            String hexstr = Integer.toHexString(c).toUpperCase(Locale.ENGLISH);
            writer.print("\\u");
            for (int pad = 4 - hexstr.length(); pad > 0; --pad) {
                writer.print("0");
            }
            writer.print(hexstr);
        }
    }

    public void outputEsc(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                this.out.print('\\');
                this.out.print(c);
                continue;
            }
            if (c == '\n') {
                this.out.print("\\n");
                continue;
            }
            if (c == '\t') {
                this.out.print("\\t");
                continue;
            }
            if (c == '\r') {
                this.out.print("\\r");
                continue;
            }
            if (c == '\f') {
                this.out.print("\\f");
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                this.out.print(c);
                continue;
            }
            String hexstr = Integer.toHexString(c).toUpperCase();
            this.out.print("\\u");
            for (int pad = 4 - hexstr.length(); pad > 0; --pad) {
                this.out.print("0");
            }
            this.out.print(hexstr);
        }
    }
}

