/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.n3.turtle;

import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.graph.Graph;
import org.apache.jena.n3.turtle.TurtleParseException;
import org.apache.jena.n3.turtle.TurtleRDFGraphInserter;
import org.apache.jena.n3.turtle.parser.ParseException;
import org.apache.jena.n3.turtle.parser.TokenMgrError;
import org.apache.jena.n3.turtle.parser.TurtleParser;
import org.apache.jena.util.FileUtils;

public class ParserTurtle {
    public void parse(Graph graph, String baseURI, InputStream in) {
        Reader reader = FileUtils.asUTF8(in);
        this.parse(graph, baseURI, reader);
    }

    public void parse(Graph graph, String baseURI, Reader reader) {
        try {
            TurtleParser parser2 = new TurtleParser(reader);
            parser2.setEventHandler(new TurtleRDFGraphInserter(graph));
            parser2.setBaseURI(baseURI);
            parser2.parse();
        }
        catch (ParseException | TokenMgrError ex) {
            throw new TurtleParseException(ex.getMessage());
        }
        catch (TurtleParseException ex) {
            throw ex;
        }
        catch (Throwable th) {
            throw new TurtleParseException(th.getMessage(), th);
        }
    }
}

