/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.iri.ViolationCodes;
import org.apache.jena.iri.impl.ComponentPatternParser;
import org.apache.jena.iri.impl.GroupAction;
import org.apache.jena.iri.impl.Parser;

public class ComponentPattern
implements ViolationCodes {
    final Pattern pattern;
    final GroupAction[] actions;
    static final List<Pattern> allPatterns = new ArrayList<Pattern>();

    ComponentPattern(String p) {
        ComponentPatternParser parser2 = new ComponentPatternParser(p);
        this.pattern = parser2.get();
        this.actions = parser2.actions();
        allPatterns.add(this.pattern);
    }

    public void analyse(Parser parser2, int range) {
        Matcher m = this.pattern.matcher(parser2.get(range));
        if (!m.matches()) {
            parser2.recordError(range, 61);
            return;
        }
        for (int g = 1; g <= m.groupCount(); ++g) {
            if (m.start(g) == -1) continue;
            this.actions[g].check(m, parser2, range);
        }
    }
}

