/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.util;

public class SymbolTable {
    protected static final int TABLE_SIZE = 101;
    protected Entry[] fBuckets = null;
    protected int fTableSize;
    protected transient int fCount;
    protected int fThreshold;
    protected float fLoadFactor;

    public SymbolTable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.fLoadFactor = loadFactor;
        this.fTableSize = initialCapacity;
        this.fBuckets = new Entry[this.fTableSize];
        this.fThreshold = (int)((float)this.fTableSize * loadFactor);
        this.fCount = 0;
    }

    public SymbolTable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public SymbolTable() {
        this(101, 0.75f);
    }

    public String addSymbol(String symbol2) {
        int bucket = this.hash(symbol2) % this.fTableSize;
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            if (entry.symbol.equals(symbol2)) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            bucket = this.hash(symbol2) % this.fTableSize;
        }
        this.fBuckets[bucket] = entry = new Entry(symbol2, this.fBuckets[bucket]);
        ++this.fCount;
        return entry.symbol;
    }

    public String addSymbol(char[] buffer, int offset, int length) {
        int bucket = this.hash(buffer, offset, length) % this.fTableSize;
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            block5: {
                if (length == entry.characters.length) {
                    for (int i = 0; i < length; ++i) {
                        if (buffer[offset + i] == entry.characters[i]) {
                            continue;
                        }
                        break block5;
                    }
                    return entry.symbol;
                }
            }
            entry = entry.next;
        }
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            bucket = this.hash(buffer, offset, length) % this.fTableSize;
        }
        this.fBuckets[bucket] = entry = new Entry(buffer, offset, length, this.fBuckets[bucket]);
        ++this.fCount;
        return entry.symbol;
    }

    public int hash(String symbol2) {
        return symbol2.hashCode() & Integer.MAX_VALUE;
    }

    public int hash(char[] buffer, int offset, int length) {
        int code = 0;
        for (int i = 0; i < length; ++i) {
            code = code * 31 + buffer[offset + i];
        }
        return code & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.fBuckets.length;
        Entry[] oldTable = this.fBuckets;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newTable = new Entry[newCapacity];
        this.fThreshold = (int)((float)newCapacity * this.fLoadFactor);
        this.fBuckets = newTable;
        this.fTableSize = this.fBuckets.length;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e2 = old;
                old = old.next;
                int index = this.hash(e2.characters, 0, e2.characters.length) % newCapacity;
                e2.next = newTable[index];
                newTable[index] = e2;
            }
        }
    }

    public boolean containsSymbol(String symbol2) {
        int bucket = this.hash(symbol2) % this.fTableSize;
        int length = symbol2.length();
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            block4: {
                if (length == entry.characters.length) {
                    for (int i = 0; i < length; ++i) {
                        if (symbol2.charAt(i) == entry.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean containsSymbol(char[] buffer, int offset, int length) {
        int bucket = this.hash(buffer, offset, length) % this.fTableSize;
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            block4: {
                if (length == entry.characters.length) {
                    for (int i = 0; i < length; ++i) {
                        if (buffer[offset + i] == entry.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    protected static final class Entry {
        public final String symbol;
        public final char[] characters;
        public Entry next;

        public Entry(String symbol2, Entry next) {
            this.symbol = symbol2.intern();
            this.characters = new char[symbol2.length()];
            symbol2.getChars(0, this.characters.length, this.characters, 0);
            this.next = next;
        }

        public Entry(char[] ch, int offset, int length, Entry next) {
            this.characters = new char[length];
            System.arraycopy(ch, offset, this.characters, 0, length);
            this.symbol = new String(this.characters).intern();
            this.next = next;
        }
    }
}

