/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.jena.atlas.csv.CSVParseException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.iterator.Iter;

public class CSVParser
implements Iterable<List<String>> {
    private final org.apache.commons.csv.CSVParser parser;
    private final Iterator<CSVRecord> iterator;
    private static Function<CSVRecord, List<String>> transform = rec -> CSVParser.recordToList(rec);

    public static CSVParser create(String filename) {
        InputStream input = IO.openFile(filename);
        return CSVParser.create(input);
    }

    public static CSVParser create(InputStream input) {
        CSVParser parser2 = new CSVParser(IO.asBufferedUTF8(input));
        return parser2;
    }

    public static CSVParser create(Reader input) {
        CSVParser parser2 = new CSVParser(input);
        return parser2;
    }

    private CSVParser(Reader input) {
        try {
            this.parser = CSVFormat.RFC4180.parse(input);
            this.iterator = this.parser.iterator();
        }
        catch (IOException e2) {
            throw new CSVParseException("Failed to create the CSV parser: " + e2.getMessage(), e2);
        }
    }

    @Override
    public Iterator<List<String>> iterator() {
        return Iter.map(this.iterator, transform);
    }

    public List<String> parse1() {
        if (this.iterator.hasNext()) {
            return CSVParser.recordToList(this.iterator.next());
        }
        return null;
    }

    private static List<String> recordToList(CSVRecord record) {
        return Iter.toList(record.iterator());
    }
}

