/*
 * Decompiled with CFR 0.152.
 */
package org.ahocorasick.trie;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ahocorasick.trie.Payload;

public class PayloadState<T> {
    private final int depth;
    private final PayloadState<T> rootState;
    private final Map<Character, PayloadState<T>> success = new HashMap<Character, PayloadState<T>>();
    private PayloadState<T> failure;
    private Set<Payload<T>> emits;

    public PayloadState() {
        this(0);
    }

    public PayloadState(int depth) {
        this.depth = depth;
        this.rootState = depth == 0 ? this : null;
    }

    private PayloadState<T> nextState(Character character, boolean ignoreRootState) {
        PayloadState<T> nextState = this.success.get(character);
        if (!ignoreRootState && nextState == null && this.rootState != null) {
            nextState = this.rootState;
        }
        return nextState;
    }

    public PayloadState<T> nextState(Character character) {
        return this.nextState(character, false);
    }

    public PayloadState<T> nextStateIgnoreRootState(Character character) {
        return this.nextState(character, true);
    }

    public PayloadState<T> addState(Character character) {
        PayloadState<T> nextState = this.nextStateIgnoreRootState(character);
        if (nextState == null) {
            nextState = new PayloadState<T>(this.depth + 1);
            this.success.put(character, nextState);
        }
        return nextState;
    }

    public int getDepth() {
        return this.depth;
    }

    public void addEmit(Payload<T> payload) {
        if (this.emits == null) {
            this.emits = new TreeSet<Payload<T>>();
        }
        this.emits.add(payload);
    }

    public void addEmit(Collection<Payload<T>> emits) {
        for (Payload<T> emit2 : emits) {
            this.addEmit(emit2);
        }
    }

    public Collection<Payload<T>> emit() {
        return this.emits == null ? Collections.emptyList() : this.emits;
    }

    public PayloadState<T> failure() {
        return this.failure;
    }

    public void setFailure(PayloadState<T> failState) {
        this.failure = failState;
    }

    public Collection<PayloadState<T>> getStates() {
        return this.success.values();
    }

    public Collection<Character> getTransitions() {
        return this.success.keySet();
    }
}

