/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.Arrays;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import no.uib.cipr.matrix.sparse.Preconditioner;
import no.uib.cipr.matrix.sparse.SparseVector;

public class ILUT
implements Preconditioner {
    private final FlexCompRowMatrix LU;
    private Matrix L;
    private Matrix U;
    private final Vector y;
    private final double tau;
    private final int[] diagind;
    private final List<IntDoubleEntry> lower;
    private final List<IntDoubleEntry> upper;
    private final int p;

    public ILUT(FlexCompRowMatrix LU, double tau, int p) {
        if (!LU.isSquare()) {
            throw new IllegalArgumentException("ILU only applies to square matrices");
        }
        this.LU = LU;
        this.tau = tau;
        this.p = p;
        int n = LU.numRows();
        this.lower = new ArrayList<IntDoubleEntry>(n);
        this.upper = new ArrayList<IntDoubleEntry>(n);
        this.y = new DenseVector(n);
        this.diagind = new int[n];
    }

    public ILUT(FlexCompRowMatrix LU) {
        this(LU, 1.0E-6, 25);
    }

    @Override
    public Vector apply(Vector b, Vector x) {
        this.L.solve(b, this.y);
        return this.U.solve(this.y, x);
    }

    @Override
    public Vector transApply(Vector b, Vector x) {
        this.U.transSolve(b, this.y);
        return this.L.transSolve(this.y, x);
    }

    @Override
    public void setMatrix(Matrix A) {
        this.LU.set(A);
        this.LU.compact();
        this.factor();
    }

    private void factor() {
        int n = this.LU.numRows();
        double[] LUi = new double[n];
        for (int k = 0; k < n; ++k) {
            SparseVector row = this.LU.getRow(k);
            this.diagind[k] = this.findDiagonalIndex(row, k);
            if (this.diagind[k] >= 0) continue;
            throw new RuntimeException("Missing diagonal entry on row " + (k + 1));
        }
        for (int i = 1; i < n; ++i) {
            SparseVector rowi = this.LU.getRow(i);
            double taui = rowi.norm(Vector.Norm.Two) * this.tau;
            this.scatter(rowi, LUi);
            for (int k = 0; k < i; ++k) {
                SparseVector rowk = this.LU.getRow(k);
                int[] rowIndex = rowk.getIndex();
                int rowUsed = rowk.getUsed();
                double[] rowData = rowk.getData();
                if (rowData[this.diagind[k]] == 0.0) {
                    throw new RuntimeException("Zero diagonal entry on row " + (k + 1) + " during ILU process");
                }
                double LUik = LUi[k] / rowData[this.diagind[k]];
                if (Math.abs(LUik) <= taui) continue;
                for (int j = this.diagind[k] + 1; j < rowUsed; ++j) {
                    int n2 = rowIndex[j];
                    LUi[n2] = LUi[n2] - LUik * rowData[j];
                }
                LUi[k] = LUik;
            }
            this.gather(LUi, rowi, taui, i);
            int diagIndex = this.diagind[i];
            int[] rowiIndices = rowi.getIndex();
            if (diagIndex < rowiIndices.length && rowiIndices[diagIndex] == i) continue;
            this.diagind[i] = this.findDiagonalIndex(rowi, i);
            if (this.diagind[i] >= 0) continue;
            throw new RuntimeException("Missing diagonal entry on row " + (i + 1) + " during ILU process");
        }
        this.L = new UnitLowerFlexCompRowMatrix(this.LU, this.diagind);
        this.U = new UpperFlexCompRowMatrix(this.LU, this.diagind);
    }

    private int findDiagonalIndex(SparseVector v, int k) {
        return Arrays.binarySearch(v.getIndex(), k, 0, v.getUsed());
    }

    private void scatter(SparseVector v, double[] z) {
        int[] index = v.getIndex();
        int used = v.getUsed();
        double[] data = v.getData();
        java.util.Arrays.fill(z, 0.0);
        for (int i = 0; i < used; ++i) {
            z[index[i]] = data[i];
        }
    }

    private void gather(double[] z, SparseVector v, double taui, int d) {
        int i;
        Object e22;
        int nl = 0;
        int nu = 0;
        for (Object e22 : v) {
            if (e22.index() < d) {
                ++nl;
                continue;
            }
            if (e22.index() <= d) continue;
            ++nu;
        }
        v.zero();
        this.lower.clear();
        for (i = 0; i < d; ++i) {
            if (!(Math.abs(z[i]) > taui)) continue;
            this.lower.add(new IntDoubleEntry(i, z[i]));
        }
        this.upper.clear();
        for (i = d + 1; i < z.length; ++i) {
            if (!(Math.abs(z[i]) > taui)) continue;
            this.upper.add(new IntDoubleEntry(i, z[i]));
        }
        Collections.sort(this.lower);
        Collections.sort(this.upper);
        v.set(d, z[d]);
        for (i = 0; i < Math.min(nl + this.p, this.lower.size()); ++i) {
            e22 = this.lower.get(i);
            v.set(((IntDoubleEntry)e22).index, ((IntDoubleEntry)e22).value);
        }
        for (i = 0; i < Math.min(nu + this.p, this.upper.size()); ++i) {
            e22 = this.upper.get(i);
            v.set(((IntDoubleEntry)e22).index, ((IntDoubleEntry)e22).value);
        }
    }

    private static class UpperFlexCompRowMatrix
    extends AbstractMatrix {
        private final FlexCompRowMatrix LU;
        private final int[] diagind;

        public UpperFlexCompRowMatrix(FlexCompRowMatrix LU, int[] diagind) {
            super(LU);
            this.LU = LU;
            this.diagind = diagind;
        }

        @Override
        public Vector solve(Vector b, Vector x) {
            if (!(b instanceof DenseVector) || !(x instanceof DenseVector)) {
                return super.solve(b, x);
            }
            double[] bd = ((DenseVector)b).getData();
            double[] xd = ((DenseVector)x).getData();
            for (int i = this.numRows - 1; i >= 0; --i) {
                SparseVector row = this.LU.getRow(i);
                int[] index = row.getIndex();
                int used = row.getUsed();
                double[] data = row.getData();
                double sum = 0.0;
                for (int j = this.diagind[i] + 1; j < used; ++j) {
                    sum += data[j] * xd[index[j]];
                }
                xd[i] = (bd[i] - sum) / data[this.diagind[i]];
            }
            return x;
        }

        @Override
        public Vector transSolve(Vector b, Vector x) {
            if (!(x instanceof DenseVector)) {
                return super.transSolve(b, x);
            }
            x.set(b);
            double[] xd = ((DenseVector)x).getData();
            for (int i = 0; i < this.numRows; ++i) {
                SparseVector row = this.LU.getRow(i);
                int[] index = row.getIndex();
                int used = row.getUsed();
                double[] data = row.getData();
                int n = i;
                xd[n] = xd[n] / data[this.diagind[i]];
                for (int j = this.diagind[i] + 1; j < used; ++j) {
                    int n2 = index[j];
                    xd[n2] = xd[n2] - data[j] * xd[i];
                }
            }
            return x;
        }
    }

    private static class UnitLowerFlexCompRowMatrix
    extends AbstractMatrix {
        private final FlexCompRowMatrix LU;
        private final int[] diagind;

        public UnitLowerFlexCompRowMatrix(FlexCompRowMatrix LU, int[] diagind) {
            super(LU);
            this.LU = LU;
            this.diagind = diagind;
        }

        @Override
        public Vector solve(Vector b, Vector x) {
            if (!(b instanceof DenseVector) || !(x instanceof DenseVector)) {
                return super.solve(b, x);
            }
            double[] bd = ((DenseVector)b).getData();
            double[] xd = ((DenseVector)x).getData();
            for (int i = 0; i < this.numRows; ++i) {
                SparseVector row = this.LU.getRow(i);
                int[] index = row.getIndex();
                double[] data = row.getData();
                double sum = 0.0;
                for (int j = 0; j < this.diagind[i]; ++j) {
                    sum += data[j] * xd[index[j]];
                }
                xd[i] = bd[i] - sum;
            }
            return x;
        }

        @Override
        public Vector transSolve(Vector b, Vector x) {
            if (!(x instanceof DenseVector)) {
                return super.transSolve(b, x);
            }
            x.set(b);
            double[] xd = ((DenseVector)x).getData();
            for (int i = this.numRows - 1; i >= 0; --i) {
                SparseVector row = this.LU.getRow(i);
                int[] index = row.getIndex();
                double[] data = row.getData();
                for (int j = 0; j < this.diagind[i]; ++j) {
                    int n = index[j];
                    xd[n] = xd[n] - data[j] * xd[i];
                }
            }
            return x;
        }
    }

    private static class IntDoubleEntry
    implements Comparable<IntDoubleEntry> {
        public int index;
        public double value;

        public IntDoubleEntry(int index, double value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(IntDoubleEntry o) {
            if (Math.abs(this.value) < Math.abs(o.value)) {
                return 1;
            }
            if (Math.abs(this.value) == Math.abs(o.value)) {
                return 0;
            }
            return -1;
        }

        public String toString() {
            return "(" + this.index + "=" + this.value + ")";
        }
    }
}

