/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.lang;

import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Objects;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public final class Strings {
    private static final Strings INSTANCE = new Strings();
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";
    private static final char EXTENSION_SEPARATOR = '.';
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    private Strings() {
    }

    public static boolean hasLength(CharSequence str2) {
        return str2 != null && str2.length() > 0;
    }

    public static boolean hasLength(String str2) {
        return Strings.hasLength((CharSequence)str2);
    }

    public static boolean hasText(CharSequence str2) {
        if (!Strings.hasLength(str2)) {
            return false;
        }
        int strLen = str2.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(String str2) {
        return Strings.hasText((CharSequence)str2);
    }

    public static boolean containsWhitespace(CharSequence str2) {
        if (!Strings.hasLength(str2)) {
            return false;
        }
        int strLen = str2.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(str2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(String str2) {
        return Strings.containsWhitespace((CharSequence)str2);
    }

    public static String trimWhitespace(String str2) {
        return (String)Strings.trimWhitespace((CharSequence)str2);
    }

    private static CharSequence trimWhitespace(CharSequence str2) {
        int start;
        if (!Strings.hasLength(str2)) {
            return str2;
        }
        int length = str2.length();
        for (start = 0; start < length && Character.isWhitespace(str2.charAt(start)); ++start) {
        }
        int end = length;
        while (start < length && Character.isWhitespace(str2.charAt(end - 1))) {
            --end;
        }
        return start > 0 || end < length ? str2.subSequence(start, end) : str2;
    }

    public static String clean(String str2) {
        CharSequence result = Strings.clean((CharSequence)str2);
        return result != null ? result.toString() : null;
    }

    public static CharSequence clean(CharSequence str2) {
        if (!Strings.hasLength(str2 = Strings.trimWhitespace(str2))) {
            return null;
        }
        return str2;
    }

    public static String trimAllWhitespace(String str2) {
        if (!Strings.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        int index = 0;
        while (sb.length() > index) {
            if (Character.isWhitespace(sb.charAt(index))) {
                sb.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return sb.toString();
    }

    public static String trimLeadingWhitespace(String str2) {
        if (!Strings.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingWhitespace(String str2) {
        if (!Strings.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimLeadingCharacter(String str2, char leadingCharacter) {
        if (!Strings.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingCharacter(String str2, char trailingCharacter) {
        if (!Strings.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == trailingCharacter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean startsWithIgnoreCase(String str2, String prefix) {
        if (str2 == null || prefix == null) {
            return false;
        }
        if (str2.startsWith(prefix)) {
            return true;
        }
        if (str2.length() < prefix.length()) {
            return false;
        }
        String lcStr = str2.substring(0, prefix.length()).toLowerCase();
        String lcPrefix = prefix.toLowerCase();
        return lcStr.equals(lcPrefix);
    }

    public static boolean endsWithIgnoreCase(String str2, String suffix) {
        if (str2 == null || suffix == null) {
            return false;
        }
        if (str2.endsWith(suffix)) {
            return true;
        }
        if (str2.length() < suffix.length()) {
            return false;
        }
        String lcStr = str2.substring(str2.length() - suffix.length()).toLowerCase();
        String lcSuffix = suffix.toLowerCase();
        return lcStr.equals(lcSuffix);
    }

    public static boolean substringMatch(CharSequence str2, int index, CharSequence substring2) {
        for (int j = 0; j < substring2.length(); ++j) {
            int i = index + j;
            if (i < str2.length() && str2.charAt(i) == substring2.charAt(j)) continue;
            return false;
        }
        return true;
    }

    public static int countOccurrencesOf(String str2, String sub) {
        int idx;
        if (str2 == null || sub == null || str2.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str2.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!Strings.hasLength(inString) || !Strings.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String delete(String inString, String pattern) {
        return Strings.replace(inString, pattern, "");
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (!Strings.hasLength(inString) || !Strings.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String quote(String str2) {
        return str2 != null ? "'" + str2 + "'" : null;
    }

    public static Object quoteIfString(Object obj) {
        return obj instanceof String ? Strings.quote((String)obj) : obj;
    }

    public static String unqualify(String qualifiedName) {
        return Strings.unqualify(qualifiedName, '.');
    }

    public static String unqualify(String qualifiedName, char separator) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(separator) + 1);
    }

    public static String capitalize(String str2) {
        return Strings.changeFirstCharacterCase(str2, true);
    }

    public static String uncapitalize(String str2) {
        return Strings.changeFirstCharacterCase(str2, false);
    }

    private static String changeFirstCharacterCase(String str2, boolean capitalize) {
        if (str2 == null || str2.length() == 0) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2.length());
        if (capitalize) {
            sb.append(Character.toUpperCase(str2.charAt(0)));
        } else {
            sb.append(Character.toLowerCase(str2.charAt(0)));
        }
        sb.append(str2.substring(1));
        return sb.toString();
    }

    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String getFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return null;
        }
        return path.substring(extIndex + 1);
    }

    public static String stripFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return path;
        }
        int folderIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return path;
        }
        return path.substring(0, extIndex);
    }

    public static String applyRelativePath(String path, String relativePath) {
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (separatorIndex != -1) {
            String newPath = path.substring(0, separatorIndex);
            if (!relativePath.startsWith(FOLDER_SEPARATOR)) {
                newPath = newPath + FOLDER_SEPARATOR;
            }
            return newPath + relativePath;
        }
        return relativePath;
    }

    public static String cleanPath(String path) {
        int i;
        if (path == null) {
            return null;
        }
        String pathToUse = Strings.replace(path, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            pathToUse = pathToUse.substring(prefixIndex + 1);
        }
        if (pathToUse.startsWith(FOLDER_SEPARATOR)) {
            prefix = prefix + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = Strings.delimitedListToStringArray(pathToUse, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        return prefix + Strings.collectionToDelimitedString(pathElements, FOLDER_SEPARATOR);
    }

    public static boolean pathEquals(String path1, String path2) {
        return Strings.cleanPath(path1).equals(Strings.cleanPath(path2));
    }

    public static Locale parseLocaleString(String localeString) {
        int endIndexOfCountryCode;
        String[] parts = Strings.tokenizeToStringArray(localeString, "_ ", false, false);
        String language = parts.length > 0 ? parts[0] : "";
        String country = parts.length > 1 ? parts[1] : "";
        Strings.validateLocalePart(language);
        Strings.validateLocalePart(country);
        String variant = "";
        if (parts.length >= 2 && (variant = Strings.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country) + country.length()))).startsWith("_")) {
            variant = Strings.trimLeadingCharacter(variant, '_');
        }
        return language.length() > 0 ? new Locale(language, country, variant) : null;
    }

    private static void validateLocalePart(String localePart) {
        for (int i = 0; i < localePart.length(); ++i) {
            char ch = localePart.charAt(i);
            if (ch == '_' || ch == ' ' || Character.isLetterOrDigit(ch)) continue;
            throw new IllegalArgumentException("Locale part \"" + localePart + "\" contains invalid characters");
        }
    }

    public static String toLanguageTag(Locale locale) {
        return locale.getLanguage() + (Strings.hasText(locale.getCountry()) ? "-" + locale.getCountry() : "");
    }

    public static String[] addStringToArray(String[] array, String str2) {
        if (Objects.isEmpty(array)) {
            return new String[]{str2};
        }
        String[] newArr = new String[array.length + 1];
        System.arraycopy(array, 0, newArr, 0, array.length);
        newArr[array.length] = str2;
        return newArr;
    }

    public static String[] concatenateStringArrays(String[] array1, String[] array2) {
        if (Objects.isEmpty(array1)) {
            return array2;
        }
        if (Objects.isEmpty(array2)) {
            return array1;
        }
        String[] newArr = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, newArr, 0, array1.length);
        System.arraycopy(array2, 0, newArr, array1.length, array2.length);
        return newArr;
    }

    public static String[] mergeStringArrays(String[] array1, String[] array2) {
        if (Objects.isEmpty(array1)) {
            return array2;
        }
        if (Objects.isEmpty(array2)) {
            return array1;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(array1));
        for (String str2 : array2) {
            if (result.contains(str2)) continue;
            result.add(str2);
        }
        return Strings.toStringArray(result);
    }

    public static String[] sortStringArray(String[] array) {
        if (Objects.isEmpty(array)) {
            return new String[0];
        }
        Arrays.sort(array);
        return array;
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] toStringArray(Enumeration<String> enumeration) {
        if (enumeration == null) {
            return null;
        }
        ArrayList<String> list = java.util.Collections.list(enumeration);
        return list.toArray(new String[list.size()]);
    }

    public static String[] trimArrayElements(String[] array) {
        if (Objects.isEmpty(array)) {
            return new String[0];
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            String element = array[i];
            result[i] = element != null ? element.trim() : null;
        }
        return result;
    }

    public static String[] removeDuplicateStrings(String[] array) {
        if (Objects.isEmpty(array)) {
            return array;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (String element : array) {
            set.add(element);
        }
        return Strings.toStringArray(set);
    }

    public static String[] split(String toSplit, String delimiter) {
        if (!Strings.hasLength(toSplit) || !Strings.hasLength(delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static Properties splitArrayElementsIntoProperties(String[] array, String delimiter) {
        return Strings.splitArrayElementsIntoProperties(array, delimiter, null);
    }

    public static Properties splitArrayElementsIntoProperties(String[] array, String delimiter, String charsToDelete) {
        if (Objects.isEmpty(array)) {
            return null;
        }
        Properties result = new Properties();
        for (String element : array) {
            String[] splittedElement;
            if (charsToDelete != null) {
                element = Strings.deleteAny(element, charsToDelete);
            }
            if ((splittedElement = Strings.split(element, delimiter)) == null) continue;
            result.setProperty(splittedElement[0].trim(), splittedElement[1].trim());
        }
        return result;
    }

    public static String[] tokenizeToStringArray(String str2, String delimiters) {
        return Strings.tokenizeToStringArray(str2, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str2, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str2 == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str2, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return Strings.toStringArray(tokens);
    }

    public static String[] delimitedListToStringArray(String str2, String delimiter) {
        return Strings.delimitedListToStringArray(str2, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str2, String delimiter, String charsToDelete) {
        if (str2 == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str2};
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(delimiter)) {
            for (int i = 0; i < str2.length(); ++i) {
                result.add(Strings.deleteAny(str2.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str2.indexOf(delimiter, pos)) != -1) {
                result.add(Strings.deleteAny(str2.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str2.length() > 0 && pos <= str2.length()) {
                result.add(Strings.deleteAny(str2.substring(pos), charsToDelete));
            }
        }
        return Strings.toStringArray(result);
    }

    public static String[] commaDelimitedListToStringArray(String str2) {
        return Strings.delimitedListToStringArray(str2, ",");
    }

    public static Set<String> commaDelimitedListToSet(String str2) {
        String[] tokens;
        TreeSet<String> set = new TreeSet<String>();
        for (String token : tokens = Strings.commaDelimitedListToStringArray(str2)) {
            set.add(token);
        }
        return set;
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim, String prefix, String suffix) {
        if (Collections.isEmpty(coll)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim) {
        return Strings.collectionToDelimitedString(coll, delim, "", "");
    }

    public static String collectionToCommaDelimitedString(Collection<?> coll) {
        return Strings.collectionToDelimitedString(coll, ",");
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        if (Objects.isEmpty(arr)) {
            return "";
        }
        if (arr.length == 1) {
            return Objects.nullSafeToString(arr[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String arrayToCommaDelimitedString(Object[] arr) {
        return Strings.arrayToDelimitedString(arr, ",");
    }
}

