/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.stringanalyzer.string;

import de.dfki.sds.stringanalyzer.string.StringEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class StringEntityAnnotation
extends StringEntity {
    public static final String ANNOTATION = "annotation";
    public static final String GAP = "gap";
    private int begin;
    private int end;

    public StringEntityAnnotation() {
    }

    private void init() {
        this.setId(UUID.randomUUID().toString());
        this.getOrCreateJsonObject(ANNOTATION);
    }

    public StringEntityAnnotation(StringEntity parent, int begin, int end) {
        this.init();
        if (!parent.hasValue()) {
            throw new IllegalArgumentException("parent needs to have a value");
        }
        parent.addChild(this);
        this.begin = begin;
        this.end = end;
    }

    public StringEntityAnnotation(StringEntity parent, int begin, int end, StringEntity namedEntity) {
        this(parent, begin, end);
        this.addChild(namedEntity);
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + this.getBegin();
        hash = 23 * hash + this.getEnd();
        hash = 23 * hash + this.getParent().hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringEntityAnnotation other = (StringEntityAnnotation)obj;
        if (this.getBegin() != other.getBegin()) {
            return false;
        }
        if (this.getEnd() != other.getEnd()) {
            return false;
        }
        return Objects.equals(this.getParent(), other.getParent());
    }

    @Override
    public String getValue() {
        if (this.values == null || this.values.isEmpty()) {
            return this.getParents().get(0).getValue().substring(this.getBegin(), this.getEnd() + 1);
        }
        return super.getValue();
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public List<String> getValues() {
        if (this.values == null) {
            return Arrays.asList(this.getValue());
        }
        return super.getValues();
    }

    public StringEntity getTextEntity() {
        return this.getParents().get(0);
    }

    public List<StringEntity> getTextEntities() {
        return this.getParents();
    }

    public StringEntity getNamedEntity() {
        return this.getChildren().get(0);
    }

    public List<StringEntity> getNamedEntities() {
        return this.getChildren();
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public boolean isAnnotation() {
        return true;
    }

    @Override
    public String toString() {
        return "StringEntityAnnotation{pos=(" + this.getBegin() + "," + this.getEnd() + "), value=\"" + this.getValue() + "\", #textEntity=" + this.getParents().size() + (this.hasChildren() ? ", #namedEntity=" + this.getNamedEntities().size() : "") + (this.hasJsonMetadata() ? ", json=" + this.getJsonMetadata().toString() : "") + '}';
    }

    public String toStringAnnotated() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getParent().getValue());
        sb.append("\n");
        sb.append(StringUtils.repeat(' ', this.getBegin()));
        if (this.getLength() == 0) {
            sb.append("_");
        } else {
            sb.append("[");
            sb.append(StringUtils.repeat('-', this.getEnd() - 1 - this.getBegin()));
            sb.append("]");
        }
        sb.append(this.getChildCount());
        sb.append(" (");
        sb.append(this.getBegin());
        sb.append(",");
        sb.append(this.getEnd());
        sb.append(")");
        return sb.toString();
    }

    public String toHtmlTitle() {
        return this.getChildCount() + " (" + this.getBegin() + ", " + this.getEnd() + ")";
    }

    public String toHtmlAnnotated() {
        String title = this.toHtmlTitle();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getParent().getValue());
        sb.insert(this.getEnd() + 1, "</mark>");
        sb.insert(this.getBegin(), "<mark title=\"" + title + "\">");
        return sb.toString();
    }

    public String toHtmlTableData() {
        String[] split = this.split();
        return "<td style=\"padding: 0px; text-align:right;\"><code>" + StringEscapeUtils.escapeHtml4(split[0]) + "</code></td><td style=\"padding: 0px;\"><mark title=\"" + this.toHtmlTitle() + "\"><code>" + StringEscapeUtils.escapeHtml4(split[1]) + "</code></mark></td><td style=\"padding: 0px;\"><code>" + StringEscapeUtils.escapeHtml4(split[2]) + "</code></td><td style=\"padding-left: 5px;\">" + this.getSpanScore() + "</td><td style=\"padding-left: 5px;\"><code>" + this.getParent().getJsonMetadata().toString() + "</code></td><td style=\"padding-left: 5px;\"><code>" + StringEscapeUtils.escapeHtml4(this.getParent().getId()) + "</code></td>";
    }

    public String toHtmlSwingLabel() {
        String[] split = this.split();
        return "<html>" + split[0] + "<span style=\"background-color: #d9edf7\">" + split[1] + "</span>" + split[2] + "</html>";
    }

    public String[] split() {
        if (this.getParentCount() == 0) {
            return new String[]{"", "", ""};
        }
        String v = this.getParent().getValue();
        return new String[]{v.substring(0, this.getBegin()), v.substring(this.getBegin(), this.getEnd() + 1), v.substring(this.getEnd() + 1, v.length())};
    }

    public float getSpanScore() {
        if (this.getParentCount() == 0) {
            return Float.NaN;
        }
        return (this.getLeftSpanScore() + this.getRightSpanScore()) / 2.0f;
    }

    public float getLeftSpanScore() {
        if (this.getBegin() == 0) {
            return 1.0f;
        }
        String[] split = this.split();
        String left = split[0];
        String middle = split[1];
        String leftLast = left.substring(left.length() - 1);
        String middleFirst = middle.substring(0, 1);
        return this.getDisconnectness(middleFirst.charAt(0), leftLast.charAt(0), true);
    }

    public float getRightSpanScore() {
        if (this.getEnd() + 1 == this.getParent().length()) {
            return 1.0f;
        }
        String[] split = this.split();
        String middle = split[1];
        String right = split[2];
        String middleLast = middle.substring(middle.length() - 1);
        String rightFirst = right.substring(0, 1);
        return this.getDisconnectness(middleLast.charAt(0), rightFirst.charAt(0), false);
    }

    public int getSpanLength() {
        return this.getEnd() - this.getBegin() + 1;
    }

    public int getLength() {
        return this.getEnd() - this.getBegin();
    }

    public float getCoverage() {
        return (float)this.getSpanLength() / (float)this.getParent().length();
    }

    private float getDisconnectness(char internal, char external, boolean isFromLeft) {
        if (Character.isWhitespace(external) || external == '\n' || external == '\r' || external == '\t') {
            return 1.0f;
        }
        if (external == '_' || external == '.' || external == ',') {
            return 0.9f;
        }
        if (external == '-') {
            return 0.75f;
        }
        if (Character.isDigit(external)) {
            return 0.8f;
        }
        if (StringUtils.containsAny((CharSequence)String.valueOf(external), (CharSequence)"/*!@#$%^&*()\"{}_[]|\\?/<>")) {
            return 0.8f;
        }
        if (isFromLeft && Character.isLowerCase(external) && Character.isUpperCase(internal)) {
            return 0.8f;
        }
        if (!isFromLeft && Character.isLowerCase(internal) && Character.isUpperCase(external)) {
            return 0.8f;
        }
        return 0.0f;
    }

    public String getType() {
        return this.getJsonMetadata().getString("type");
    }

    public StringEntityAnnotation setType(String type) {
        if (!this.hasJsonMetadata()) {
            this.setJsonMetadata(new JSONObject());
        }
        this.getJsonMetadata().put("type", type);
        return this;
    }

    @Override
    public JSONObject toJson(boolean withChildren, boolean withParents) throws JSONException {
        JSONObject json = super.toJson(withChildren, withParents);
        json.put("begin", this.getBegin());
        json.put("end", this.getEnd());
        return json;
    }

    public static List<StringEntityAnnotation> getAnnotations(List<StringEntity> textEntities) {
        return textEntities.stream().flatMap(te -> te.getChildrenAnnotation().stream()).collect(Collectors.toList());
    }

    public static List<StringEntity> getNamedEntitiesList(List<StringEntity> textEntities) {
        return textEntities.stream().flatMap(te -> te.getChildrenAnnotation().stream()).flatMap(te -> te.getChildren().stream()).collect(Collectors.toList());
    }

    public static Set<StringEntity> getNamedEntitiesSet(List<StringEntity> textEntities) {
        return textEntities.stream().flatMap(te -> te.getChildrenAnnotation().stream()).flatMap(te -> te.getChildren().stream()).distinct().collect(Collectors.toSet());
    }

    public static float getSpanScore(String text, int begin, int end) {
        StringEntity se = StringEntity.withRandomUUID(text);
        StringEntityAnnotation anno = se.getOrCreateAnnotation(begin, end);
        return anno.getSpanScore();
    }
}

