/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.stringanalyzer.string;

import de.dfki.sds.stringanalyzer.string.StringEntityAnnotation;
import de.dfki.sds.stringanalyzer.string.StringEntitySequence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDFS;
import org.json.JSONObject;

public class StringEntity
implements Serializable {
    protected String id;
    protected String propertyId;
    protected List<String> values;
    protected transient Model rdfmetadata;
    protected JSONObject jsonmetadata;
    protected List<StringEntity> parents;
    protected List<StringEntity> children;
    protected transient DefaultMutableTreeNode treeNode;
    private static final int ABBREV_MAX_LEN = 100;

    public StringEntity() {
    }

    public StringEntity(String value) {
        this.setId(null);
        if (value != null) {
            this.initValues();
            this.getValues().add(value);
        }
    }

    public StringEntity(String id, String value) {
        this(value);
        this.setId(id);
    }

    public StringEntity(String id, String value, Model rdfmetadata) {
        this(id, value);
        this.rdfmetadata = rdfmetadata;
    }

    public StringEntity(String id, String label, String comment) {
        this(id, label);
        this.propertyId = RDFS.label.getURI();
        this.rdfmetadata = ModelFactory.createDefaultModel();
        Resource thisRes = this.asResource();
        this.rdfmetadata.add(thisRes, RDFS.label, label);
        this.rdfmetadata.add(thisRes, RDFS.comment, comment);
    }

    @Deprecated
    public StringEntity(StringEntity stringEntity) {
        this.setId(stringEntity.getId());
        this.setValues(stringEntity.getValues());
    }

    public static StringEntity withRandomUUID(String value) {
        return new StringEntity(UUID.randomUUID().toString(), value);
    }

    public static StringEntity withRandomString(int len, String value) {
        return new StringEntity(RandomStringUtils.randomAlphabetic(len), value);
    }

    public static StringEntity withRandomString(String value) {
        return StringEntity.withRandomString(6, value);
    }

    public static List<StringEntity> annoToSimple(List<StringEntityAnnotation> annos) {
        return annos.stream().map(anno -> anno).collect(Collectors.toList());
    }

    public static StringEntity fromCSVRecord(CSVRecord record, String valueColumnName) {
        StringEntity se = new StringEntity("" + record.getRecordNumber(), record.get(valueColumnName));
        JSONObject meta = se.getOrCreateJsonObject("csv");
        for (String name : record.getParser().getHeaderNames()) {
            if (valueColumnName.equals(name)) continue;
            String val = record.get(name);
            Object obj = val;
            try {
                obj = Double.parseDouble(val);
            }
            catch (NumberFormatException e1) {
                obj = val.equals("true") || val.equals("false") ? Boolean.valueOf(Boolean.parseBoolean(val)) : val;
            }
            meta.put(name, obj);
        }
        return se;
    }

    public int hashCode() {
        if (this.getId() == null) {
            int hash = 3;
            hash = 17 * hash + Objects.hashCode(this.getValues());
            return hash;
        }
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this.getId());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringEntity other = (StringEntity)obj;
        return !(this.getId() == null ? !Objects.equals(this.getValues(), other.getValues()) : !Objects.equals(this.getId(), other.getId()));
    }

    public boolean hasId() {
        return this.getId() != null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean hasPropertyId() {
        return this.propertyId != null;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    private void initValues() {
        if (this.getValues() == null) {
            this.initValueArray();
        }
    }

    private void initValueArray() {
        this.setValues(new ArrayList<String>());
    }

    public boolean hasValue() {
        return this.getValues() != null && !this.getValues().isEmpty();
    }

    public boolean isMultiValued() {
        return this.hasValue() && this.getValues().size() > 1;
    }

    public String getValue() {
        return this.getValues().get(0);
    }

    public boolean isEmpty() {
        return this.getValue().isEmpty();
    }

    public boolean isBlank() {
        return this.getValue().trim().isEmpty();
    }

    public void setValue(String value) {
        this.setValues(new ArrayList<String>(Arrays.asList(value)));
    }

    public List<String> getValues() {
        return this.values;
    }

    public void addValue(String value) {
        this.getValues().add(value);
    }

    public void setValues(List<String> values) {
        this.values = values == null ? null : new ArrayList<String>(values);
    }

    public void removeValuesIf(Predicate<String> filter) {
        this.values.removeIf(filter);
    }

    public void trimValues() {
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.set(i, this.values.get(i).trim());
        }
    }

    public void replaceValues(String target, String replacement) {
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.set(i, this.values.get(i).replace(target, replacement));
        }
    }

    public void lowercaseValues() {
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.set(i, this.values.get(i).toLowerCase());
        }
    }

    public void uppercaseValues() {
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.set(i, this.values.get(i).toUpperCase());
        }
    }

    public boolean hasRdfMetadata() {
        return this.rdfmetadata != null;
    }

    public Model getRdfMetadata() {
        return this.rdfmetadata;
    }

    public void setRdfMetadata(Model metadata) {
        this.rdfmetadata = metadata;
    }

    public boolean hasJsonMetadata() {
        return this.getJsonMetadata() != null;
    }

    public JSONObject getJsonMetadata() {
        return this.jsonmetadata;
    }

    private void initJsonMetadata() {
        if (this.getJsonMetadata() == null) {
            this.jsonmetadata = new JSONObject();
        }
    }

    public void setJsonMetadata(JSONObject jsonmetadata) {
        this.jsonmetadata = jsonmetadata;
    }

    public JSONObject getOrCreateJsonObject(String key) {
        JSONObject obj;
        JSONObject meta;
        if (!this.hasJsonMetadata()) {
            meta = new JSONObject();
            this.setJsonMetadata(meta);
        } else {
            meta = this.getJsonMetadata();
        }
        if (!meta.has(key)) {
            obj = new JSONObject();
            meta.put(key, obj);
        } else {
            obj = meta.getJSONObject(key);
        }
        return obj;
    }

    public JSONObject getJsonObject(String key) {
        return this.getJsonMetadata().getJSONObject(key);
    }

    public boolean hasJsonKey(String key) {
        return this.hasJsonMetadata() && this.getJsonMetadata().has(key);
    }

    public char getChar() {
        return this.getValue().charAt(0);
    }

    public int length() {
        return this.getValue().length();
    }

    public boolean isSequence() {
        return false;
    }

    public StringEntitySequence toSequence() {
        if (!this.isSequence()) {
            throw new RuntimeException("not an sequence StringEntity");
        }
        return (StringEntitySequence)this;
    }

    private void initParents() {
        if (this.parents == null) {
            this.parents = new ArrayList<StringEntity>();
        }
    }

    private void initChildren() {
        if (this.children == null) {
            this.children = new ArrayList<StringEntity>();
        }
    }

    public StringEntity getOrAddChild(StringEntity child, boolean addParentToChild, int index) {
        Map<String, StringEntity> map = this.getChildrenMap();
        if (map.containsKey(child.getId())) {
            return map.get(child.getId());
        }
        this.insertChildren(index, Arrays.asList(child), addParentToChild);
        return child;
    }

    public StringEntity getOrAddChild(StringEntity child) {
        return this.getOrAddChild(child, true, this.getChildCount());
    }

    public void getOrAddChildren(Collection<StringEntity> children) {
        children.forEach(child -> this.getOrAddChild((StringEntity)child, true, this.getChildCount()));
    }

    public StringEntity getOrCreateChild(String id, Supplier<StringEntity> creator, boolean addParentToChild, int index) {
        Map<String, StringEntity> map = this.getChildrenMap();
        if (map.containsKey(id)) {
            return map.get(id);
        }
        StringEntity se = creator.get();
        se.setId(id);
        this.insertChildren(index, Arrays.asList(se), addParentToChild);
        return se;
    }

    public StringEntity getOrCreateChild(String id, Supplier<StringEntity> creator) {
        return this.getOrCreateChild(id, creator, true, this.getChildCount());
    }

    public StringEntity getOrCreateChild(String value, Function<String, String> value2id, Consumer<JSONObject> jsonCreator) {
        String id = value2id.apply(value);
        return this.getOrCreateChild(id, () -> {
            StringEntity se = new StringEntity(value);
            se.initJsonMetadata();
            jsonCreator.accept(se.getJsonMetadata());
            return se;
        });
    }

    public StringEntity addChild(StringEntity stringEntity) {
        return this.addChild(stringEntity, true);
    }

    public StringEntity addChild(StringEntity stringEntity, boolean addParentToChild) {
        return this.addChildren(Arrays.asList(stringEntity), addParentToChild);
    }

    public StringEntity addChildren(Collection<StringEntity> stringEntity) {
        return this.addChildren(stringEntity, true);
    }

    public StringEntity addChildren(Collection<StringEntity> stringEntity, boolean addParentToChild) {
        return this.insertChildren(this.getChildren() == null ? 0 : this.getChildren().size(), stringEntity, addParentToChild);
    }

    public StringEntity insertChild(int index, StringEntity stringEntity) {
        return this.insertChildren(index, Arrays.asList(stringEntity), true);
    }

    public StringEntity insertChildren(int index, Collection<StringEntity> givenChildren, boolean addParentToChild) {
        this.initChildren();
        this.children.addAll(index, givenChildren);
        if (addParentToChild) {
            givenChildren.forEach(se -> se.addParent(this, false));
        }
        return this;
    }

    public StringEntity addParent(StringEntity parent) {
        return this.addParent(parent, true);
    }

    public StringEntity addParent(StringEntity parent, boolean addChildToParent) {
        return this.addParents(Arrays.asList(parent), addChildToParent);
    }

    public StringEntity addParents(Collection<StringEntity> parents) {
        return this.addParents(parents, true);
    }

    public StringEntity addParents(Collection<StringEntity> givenParents, boolean addChildToParent) {
        this.initParents();
        this.parents.addAll(givenParents);
        if (addChildToParent) {
            givenParents.forEach(se -> se.addChild(this, false));
        }
        return this;
    }

    public StringEntity removeFromParents() {
        for (StringEntity parent : this.getParents()) {
            parent.getChildren().remove(this);
        }
        this.getParents().clear();
        return this;
    }

    public StringEntity removeChild(StringEntity stringEntity) {
        return this.removeChild(stringEntity, true);
    }

    public StringEntity removeChild(StringEntity stringEntity, boolean removeParentFromChild) {
        if (this.hasChildren()) {
            this.children.remove(stringEntity);
        }
        if (removeParentFromChild) {
            stringEntity.removeParent(this, false);
        }
        return this;
    }

    public StringEntity removeParent(StringEntity stringEntity) {
        return this.removeParent(stringEntity, true);
    }

    public StringEntity removeParent(StringEntity stringEntity, boolean removeChildFromParent) {
        if (this.hasParents()) {
            this.getParents().remove(stringEntity);
        }
        if (removeChildFromParent) {
            stringEntity.removeChild(this, false);
        }
        return this;
    }

    public StringEntity removeChildrenIf(Predicate<StringEntity> childPredicate) {
        if (this.children == null) {
            return this;
        }
        this.children.removeIf(childPredicate);
        return this;
    }

    public StringEntity removeParentsIf(Predicate<StringEntity> parentPredicate) {
        if (this.parents == null) {
            return this;
        }
        this.parents.removeIf(parentPredicate);
        return this;
    }

    public boolean hasParent() {
        return this.getParents() != null && !this.getParents().isEmpty();
    }

    public boolean hasChild() {
        return this.getChildren() != null && !this.getChildren().isEmpty();
    }

    public boolean hasParents() {
        return this.parents != null;
    }

    public boolean hasChildren() {
        return this.children != null;
    }

    public StringEntity getParent() {
        return this.getParents().get(0);
    }

    public StringEntity setParent(StringEntity origin) {
        this.parents = null;
        this.initParents();
        this.getParents().add(origin);
        origin.addChild(this);
        return this;
    }

    public List<StringEntity> getChildren() {
        if (!this.hasChildren()) {
            return new ArrayList<StringEntity>();
        }
        return new ArrayList<StringEntity>(this.children);
    }

    public Map<String, StringEntity> getChildrenMap() {
        HashMap<String, StringEntity> m = new HashMap<String, StringEntity>();
        if (!this.hasChildren()) {
            return m;
        }
        for (StringEntity child : this.getChildren()) {
            m.put(child.getId(), child);
        }
        return m;
    }

    public List<StringEntity> getParents() {
        if (!this.hasParents()) {
            return new ArrayList<StringEntity>();
        }
        return new ArrayList<StringEntity>(this.parents);
    }

    public List<StringEntity> getParentPath() {
        return this.getParentPath(true);
    }

    public List<StringEntity> getParentPath(boolean ambigousCheck) {
        ArrayList<StringEntity> path = new ArrayList<StringEntity>();
        StringEntity cur = this;
        while (cur.hasParent()) {
            if (ambigousCheck && cur.getParentCount() > 1) {
                throw new RuntimeException("parent path is not possible because this string entity has more than one parent: " + cur);
            }
            StringEntity parent = cur.getParent();
            path.add(parent);
            cur = parent;
        }
        Collections.reverse(path);
        return path;
    }

    public Set<StringEntity> getNeighbors() {
        HashSet<StringEntity> neighbors = new HashSet<StringEntity>();
        if (this.hasParents()) {
            neighbors.addAll(this.getParents());
        }
        if (this.hasChildren()) {
            neighbors.addAll(this.getChildren());
        }
        return neighbors;
    }

    public List<StringEntity> getChildren(Predicate<JSONObject> metaFilter) {
        return this.getChildren().stream().filter(p -> p.hasJsonMetadata() ? metaFilter.test(p.getJsonMetadata()) : false).collect(Collectors.toList());
    }

    public List<StringEntity> getParents(Predicate<JSONObject> metaFilter) {
        return this.getParents().stream().filter(p -> p.hasJsonMetadata() ? metaFilter.test(p.getJsonMetadata()) : false).collect(Collectors.toList());
    }

    public int getChildCount() {
        if (this.hasChildren()) {
            return this.getChildren().size();
        }
        return 0;
    }

    public int getParentCount() {
        if (this.hasParents()) {
            return this.getParents().size();
        }
        return 0;
    }

    public List<StringEntity> descendants() {
        ArrayList<StringEntity> l = new ArrayList<StringEntity>();
        l.add(this);
        if (this.hasChildren()) {
            for (StringEntity child : this.getChildren()) {
                l.addAll(child.descendants());
            }
        }
        return l;
    }

    public List<StringEntity> descendantsWithoutThis() {
        ArrayList<StringEntity> l = new ArrayList<StringEntity>();
        if (this.hasChildren()) {
            for (StringEntity child : this.getChildren()) {
                l.addAll(child.descendants());
            }
        }
        return l;
    }

    public List<StringEntity> descendants(Predicate<JSONObject> metaFilter) {
        ArrayList<StringEntity> l = new ArrayList<StringEntity>();
        l.add(this);
        if (this.hasChildren()) {
            for (StringEntity child : this.getChildren(metaFilter)) {
                l.addAll(child.descendants(metaFilter));
            }
        }
        return l;
    }

    public List<StringEntity> descendantsCollect(Predicate<JSONObject> metaFilter) {
        ArrayList<StringEntity> l = new ArrayList<StringEntity>();
        if (metaFilter != null) {
            if (this.hasJsonMetadata() && metaFilter.test(this.getJsonMetadata())) {
                l.add(this);
            }
        } else {
            l.add(this);
        }
        if (this.hasChildren()) {
            for (StringEntity child : this.getChildren()) {
                l.addAll(child.descendantsCollect(metaFilter));
            }
        }
        return l;
    }

    public List<StringEntity> ancestorsCollect(Predicate<JSONObject> metaFilter) {
        ArrayList<StringEntity> l = new ArrayList<StringEntity>();
        if (metaFilter != null) {
            if (this.hasJsonMetadata() && metaFilter.test(this.getJsonMetadata())) {
                l.add(this);
            }
        } else {
            l.add(this);
        }
        if (this.hasParents()) {
            for (StringEntity parent : this.getParents()) {
                l.addAll(parent.ancestorsCollect(metaFilter));
            }
        }
        return l;
    }

    public Map<String, StringEntity> descendantsIdMap(Predicate<JSONObject> metaFilter) {
        List<StringEntity> descendants = this.descendantsCollect(metaFilter);
        HashMap<String, StringEntity> m = new HashMap<String, StringEntity>();
        for (StringEntity descendant : descendants) {
            m.put(descendant.getId(), descendant);
        }
        return m;
    }

    public Set<StringEntity> breadthFirstSearch() {
        return this.breadthFirstSearch(null);
    }

    public Set<StringEntity> breadthFirstSearch(Consumer<StringEntity> consumer) {
        LinkedList<StringEntity> q = new LinkedList<StringEntity>();
        q.add(this);
        HashSet<StringEntity> visited = new HashSet<StringEntity>();
        while (!q.isEmpty()) {
            StringEntity cur = (StringEntity)q.poll();
            if (visited.contains(cur)) continue;
            if (consumer != null) {
                consumer.accept(cur);
            }
            visited.add(cur);
            for (StringEntity neighbor : cur.getNeighbors()) {
                if (visited.contains(neighbor)) continue;
                q.add(neighbor);
            }
        }
        return visited;
    }

    public StringEntity breadthFirstSearchFor(Predicate<StringEntity> predicate) {
        LinkedList<StringEntity> q = new LinkedList<StringEntity>();
        q.add(this);
        HashSet<StringEntity> visited = new HashSet<StringEntity>();
        while (!q.isEmpty()) {
            StringEntity cur = (StringEntity)q.poll();
            if (visited.contains(cur)) continue;
            if (predicate.test(cur)) {
                return cur;
            }
            visited.add(cur);
            for (StringEntity neighbor : cur.getNeighbors()) {
                if (visited.contains(neighbor)) continue;
                q.add(neighbor);
            }
        }
        return null;
    }

    public TreeNode asSwingTreeNodes(Predicate<JSONObject> metaFilter, Comparator<StringEntity> childSorter, Integer maxDepth, int curDepth, boolean oneChildLayer) {
        DefaultMutableTreeNode treeNode;
        this.treeNode = treeNode = new DefaultMutableTreeNode(this);
        if (maxDepth != null && curDepth >= maxDepth) {
            if (oneChildLayer && this.hasChildren()) {
                for (StringEntity child : this.getChildren()) {
                    treeNode.add((MutableTreeNode)child.asSwingTreeNode());
                }
            }
            return treeNode;
        }
        if (this.hasChildren()) {
            Stream<Object> s = this.getChildren().stream();
            if (childSorter != null) {
                s = s.sorted(childSorter);
            }
            for (StringEntity child : s.collect(Collectors.toList())) {
                if (metaFilter != null && child.hasJsonMetadata() && !metaFilter.test(child.getJsonMetadata())) {
                    if (!oneChildLayer) continue;
                    treeNode.add((MutableTreeNode)child.asSwingTreeNode());
                    continue;
                }
                treeNode.add((MutableTreeNode)child.asSwingTreeNodes(metaFilter, childSorter, maxDepth, curDepth + 1, oneChildLayer));
            }
        }
        return treeNode;
    }

    public TreeNode asSwingTreeNodes(Predicate<JSONObject> metaFilter, Comparator<StringEntity> childSorter) {
        return this.asSwingTreeNodes(metaFilter, childSorter, null, 0, false);
    }

    public TreeNode asSwingTreeNode() {
        DefaultMutableTreeNode treeNode;
        this.treeNode = treeNode = new DefaultMutableTreeNode(this);
        return treeNode;
    }

    public TreeModel asSwingTreeModel(Predicate<JSONObject> metaFilter) {
        DefaultMutableTreeNode root2 = (DefaultMutableTreeNode)this.asSwingTreeNode();
        DefaultTreeModel dtm = new DefaultTreeModel(root2);
        LinkedList<DefaultMutableTreeNode> q = new LinkedList<DefaultMutableTreeNode>();
        q.add(root2);
        while (!q.isEmpty()) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)q.poll();
            StringEntity se = (StringEntity)tn.getUserObject();
            if (!se.hasChildren()) continue;
            for (StringEntity child : se.getChildren()) {
                if (metaFilter != null && child.hasJsonMetadata() && !metaFilter.test(child.getJsonMetadata())) continue;
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)child.asSwingTreeNode();
                tn.add(childNode);
                q.add(childNode);
            }
        }
        return dtm;
    }

    public boolean hasTreeNode() {
        return this.treeNode != null;
    }

    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    public static List<StringEntity> dragAndDrop(TreePath[] source, TreeModel sourceModel, TreePath target, TreeModel targetModel, boolean move, boolean insertFront) {
        if (target.getPathCount() == 0) {
            return Arrays.asList(new StringEntity[0]);
        }
        DefaultTreeModel sourceDtm = (DefaultTreeModel)sourceModel;
        DefaultTreeModel targetDtm = (DefaultTreeModel)targetModel;
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)target.getLastPathComponent();
        ArrayList<StringEntity> moved = new ArrayList<StringEntity>();
        for (TreePath path : source) {
            if (path.getPathCount() <= 1 || path == target) continue;
            DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
            DefaultMutableTreeNode nextToLast = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 2);
            if (move) {
                sourceDtm.removeNodeFromParent(last);
            }
            StringEntity lastSe = (StringEntity)last.getUserObject();
            StringEntity nextToLastSe = (StringEntity)nextToLast.getUserObject();
            if (move) {
                nextToLastSe.removeChild(lastSe);
            }
            int insertIndexNode = insertFront ? 0 : targetNode.getChildCount();
            targetDtm.insertNodeInto(last, targetNode, insertIndexNode);
            StringEntity targetSe = (StringEntity)targetNode.getUserObject();
            int insertIndexSe = insertFront ? 0 : targetSe.getChildCount();
            targetSe.insertChild(insertIndexSe, lastSe);
            moved.add(lastSe);
            targetDtm.nodeStructureChanged(nextToLast);
            targetDtm.nodeChanged(last);
        }
        return moved;
    }

    public boolean isAnnotation() {
        return false;
    }

    public StringEntityAnnotation toAnnotation() {
        if (!this.isAnnotation()) {
            throw new RuntimeException("not an annotation StringEntity");
        }
        return (StringEntityAnnotation)this;
    }

    public List<StringEntityAnnotation> getParentsAnnotation() {
        return this.getParents().stream().filter(se -> se.isAnnotation()).map(se -> se.toAnnotation()).collect(Collectors.toList());
    }

    public List<StringEntityAnnotation> getChildrenAnnotation() {
        return this.getChildren().stream().filter(se -> se.isAnnotation()).map(se -> se.toAnnotation()).collect(Collectors.toList());
    }

    public List<StringEntityAnnotation> getChildrenAnnotation(Predicate<JSONObject> metaFilter) {
        return this.getChildren().stream().filter(se -> se.isAnnotation()).filter(p -> p.hasJsonMetadata() ? metaFilter.test(p.getJsonMetadata()) : false).map(se -> se.toAnnotation()).collect(Collectors.toList());
    }

    public Map<String, StringEntityAnnotation> getAnnotationMap() {
        HashMap<String, StringEntityAnnotation> m = new HashMap<String, StringEntityAnnotation>();
        if (this.hasChildren()) {
            for (StringEntityAnnotation anno : this.getChildrenAnnotation()) {
                int b = anno.getBegin();
                int e2 = anno.getEnd();
                m.put(b + "-" + e2, anno);
            }
        }
        return m;
    }

    public StringEntity removeFromAnnotations() {
        for (StringEntityAnnotation parent : this.getParentsAnnotation().toArray(new StringEntityAnnotation[0])) {
            parent.getChildren().remove(this);
            this.getParents().remove(parent);
            if (!parent.getChildren().isEmpty()) continue;
            parent.removeFromParents();
        }
        return this;
    }

    public StringEntityAnnotation getOrCreateAnnotation(int begin, int end) {
        String key;
        Map<String, StringEntityAnnotation> map = this.getAnnotationMap();
        if (map.containsKey(key = begin + "-" + end)) {
            return map.get(key);
        }
        StringEntityAnnotation fresh = new StringEntityAnnotation(this, begin, end);
        return fresh;
    }

    public boolean hasAnnotationAt(int begin, int end) {
        return this.getAnnotationMap().containsKey(begin + "-" + end);
    }

    public Resource asResource() {
        if (!this.hasId()) {
            throw new RuntimeException("no id");
        }
        if (this.hasRdfMetadata()) {
            return this.getRdfMetadata().createResource(this.getId());
        }
        return ResourceFactory.createResource(this.getId());
    }

    public Property getProperty() {
        if (!this.hasPropertyId()) {
            throw new RuntimeException("no propery id");
        }
        if (this.hasRdfMetadata()) {
            return this.getRdfMetadata().createProperty(this.propertyId);
        }
        return ResourceFactory.createProperty(this.propertyId);
    }

    public Literal asLiteral() {
        if (!this.hasValue()) {
            throw new RuntimeException("no value");
        }
        return ResourceFactory.createPlainLiteral(this.getValue());
    }

    public Literal asLiteral(String lang) {
        if (!this.hasValue()) {
            throw new RuntimeException("no value");
        }
        return ResourceFactory.createLangLiteral(this.getValue(), lang);
    }

    public Statement asStatement() {
        Resource s = this.asResource();
        Property p = this.getProperty();
        Literal l = this.asLiteral();
        return ResourceFactory.createStatement(s, p, l);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StringEntity{");
        sb.append("hashCode=" + this.hashCode() + ", ");
        if (this.hasId()) {
            sb.append("id=" + this.getId() + ", ");
        }
        if (this.hasValue()) {
            sb.append("value='" + this.toShortValueString() + "' (" + this.getValues().size() + "), ");
        }
        if (this.hasRdfMetadata()) {
            sb.append("#metadata_triple=" + this.rdfmetadata.size() + ", ");
        }
        if (this.hasChildren()) {
            sb.append("#children=" + this.getChildren().size() + ", ");
        }
        if (this.hasParent()) {
            sb.append("#parent=" + this.getParents().size() + ", ");
        }
        if (this.hasJsonMetadata()) {
            sb.append("json=" + this.getJsonMetadata().toString() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public String toShortValueString() {
        return this.toShortValueString(100);
    }

    public String toShortValueString(int maxWidth) {
        String v = this.getValue();
        return StringUtils.abbreviate(v == null ? "(null)" : v, maxWidth).replace("\n", "\\n").replace("\t", "\\t").replace("\r", "\\r");
    }

    public String toStringTree() {
        StringBuilder sb = new StringBuilder();
        this.toStringTree("", true, sb);
        return sb.toString();
    }

    private void toStringTree(String prefix, boolean isTail, StringBuilder sb) {
        sb.append(prefix).append(isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(this.toString()).append("\n");
        if (this.getChildren() != null) {
            for (int i = 0; i < this.getChildren().size() - 1; ++i) {
                this.getChildren().get(i).toStringTree(prefix + (isTail ? "    " : "\u2502   "), false, sb);
            }
            if (this.getChildren().size() > 0) {
                this.getChildren().get(this.getChildren().size() - 1).toStringTree(prefix + (isTail ? "    " : "\u2502   "), true, sb);
            }
        }
    }

    public String toStringTreeParent() {
        StringBuilder sb = new StringBuilder();
        this.toStringTreeParent("", true, sb);
        return sb.toString();
    }

    private void toStringTreeParent(String prefix, boolean isTail, StringBuilder sb) {
        sb.append(prefix).append(isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(this.toString()).append("\n");
        if (this.getParents() != null) {
            for (int i = 0; i < this.getParents().size() - 1; ++i) {
                this.getParents().get(i).toStringTreeParent(prefix + (isTail ? "    " : "\u2502   "), false, sb);
            }
            if (this.getParents().size() > 0) {
                this.getParents().get(this.getParents().size() - 1).toStringTreeParent(prefix + (isTail ? "    " : "\u2502   "), true, sb);
            }
        }
    }

    public String toHtml() {
        StringBuilder sb = new StringBuilder();
        if (this.hasId() && this.hasValue()) {
            sb.append("<a href=\"" + StringEscapeUtils.escapeHtml4(this.getId()) + "\">" + StringEscapeUtils.escapeHtml4(this.getValue()) + "</a>");
        }
        if (this.hasChildren()) {
            sb.append(" " + this.getChildCount()).append("C");
        }
        if (this.hasParent()) {
            sb.append(" " + this.getParentCount()).append("P");
        }
        if (this.hasJsonMetadata()) {
            sb.append(" <code>" + StringEscapeUtils.escapeHtml4(this.getJsonMetadata().toString()) + "</code>");
        }
        return sb.toString();
    }

    public String toHtmlSimple() {
        StringBuilder sb = new StringBuilder();
        if (this.hasValue()) {
            sb.append(StringEscapeUtils.escapeHtml4(this.getValue()));
        }
        if (this.hasId()) {
            sb.append(" ");
            sb.append(StringEscapeUtils.escapeHtml4(this.getId()));
        }
        if (this.hasChildren()) {
            sb.append(" " + this.getChildCount()).append("Children");
        }
        if (this.hasParent()) {
            sb.append(" " + this.getParentCount()).append("Parents");
        }
        if (this.hasJsonMetadata()) {
            sb.append(" <code>" + StringEscapeUtils.escapeHtml4(this.getJsonMetadata().toString()) + "</code>");
        }
        return sb.toString();
    }

    public JSONObject toJson() {
        return this.toJson(true, false);
    }

    public JSONObject toJson(boolean withChildren, boolean withParents) {
        JSONObject jo = new JSONObject();
        if (this.hasId()) {
            jo.put("id", this.getId());
        }
        if (this.hasPropertyId()) {
            jo.put("prop", this.getPropertyId());
        }
        if (this.hasValue()) {
            jo.put("value", this.getValue());
        }
        if (this.hasJsonMetadata()) {
            jo.put("meta", this.getJsonMetadata());
        }
        return jo;
    }
}

