/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.stringanalyzer.helper;

import de.dfki.sds.stringanalyzer.string.StringEntity;
import de.dfki.sds.stringanalyzer.string.StringEntitySequence;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class GermaNet {
    public static final String GERMANET = "germanet";
    private File relationsFile;
    private List<File> wiktionaryParaphrasesFiles;
    private List<File> synsetFiles;
    private Map<String, SynSet> id2synset;
    private Map<String, LexUnit> id2lexunit;
    private Map<String, List<SynSet>> word2synsets;
    private List<SynSet> roots;
    private List<StringEntity> rootsStringEntity;
    private Map<SynSet, StringEntity> synset2se;

    public GermaNet(List<File> synsetFiles, List<File> wiktionaryParaphrasesFiles, File relationsFile) {
        this.relationsFile = relationsFile;
        this.wiktionaryParaphrasesFiles = wiktionaryParaphrasesFiles;
        this.synsetFiles = synsetFiles;
        this.id2synset = new HashMap<String, SynSet>();
        this.id2lexunit = new HashMap<String, LexUnit>();
        this.word2synsets = new HashMap<String, List<SynSet>>();
    }

    public GermaNet(InputStream inputStream) {
        this.id2synset = new HashMap<String, SynSet>();
        this.id2lexunit = new HashMap<String, LexUnit>();
        this.word2synsets = new HashMap<String, List<SynSet>>();
        this.load(inputStream);
    }

    private void initTree() {
        this.roots = this.id2synset.values().stream().filter(synset -> ((SynSet)synset).generalizations.isEmpty()).collect(Collectors.toList());
    }

    private void initStringEntityTree() {
        this.rootsStringEntity = new ArrayList<StringEntity>();
        this.synset2se = new HashMap<SynSet, StringEntity>();
        for (SynSet root2 : this.roots) {
            LinkedList<SynSet> q = new LinkedList<SynSet>();
            q.add(root2);
            while (!q.isEmpty()) {
                StringEntity se;
                SynSet cur = (SynSet)q.poll();
                if (this.synset2se.containsKey(cur)) {
                    se = this.synset2se.get(cur);
                } else {
                    se = cur.toStringEntity();
                    this.synset2se.put(cur, se);
                }
                if (cur == root2) {
                    this.rootsStringEntity.add(se);
                }
                for (SynSet child : cur.specializations) {
                    StringEntity seChild;
                    if (this.synset2se.containsKey(child)) {
                        seChild = this.synset2se.get(child);
                    } else {
                        seChild = child.toStringEntity();
                        this.synset2se.put(child, seChild);
                    }
                    se.addChild(seChild);
                    q.add(child);
                }
            }
        }
    }

    public static List<File> nomen(File germaNetFolder) {
        return Arrays.asList(germaNetFolder.listFiles(f -> f.getName().startsWith("nomen.")));
    }

    public static List<File> synsets(File germaNetFolder) {
        return Arrays.asList(germaNetFolder.listFiles(f -> f.getName().startsWith("nomen.") || f.getName().startsWith("verben.") || f.getName().startsWith("adj.")));
    }

    public static List<File> classes(File germaNetFolder, List<String> classes) {
        return GermaNet.synsets(germaNetFolder).stream().filter(f -> classes.contains(f.getName().split("\\.")[1])).collect(Collectors.toList());
    }

    public static List<File> categories(File germaNetFolder, List<String> categories) {
        return GermaNet.synsets(germaNetFolder).stream().filter(f -> categories.contains(f.getName().split("\\.")[0])).collect(Collectors.toList());
    }

    public int synsetCount() {
        return this.id2synset.size();
    }

    public int lexunitCount() {
        return this.id2lexunit.size();
    }

    public int wordCount() {
        return this.word2synsets.size();
    }

    public String getStatusLine() {
        return this.roots.size() + " roots, " + this.synsetCount() + " synsets, " + this.lexunitCount() + " lexunits, " + this.wordCount() + " words";
    }

    public List<SynSet> lookup(String word) {
        List<SynSet> synsets = this.word2synsets.get(word.toLowerCase());
        if (synsets == null) {
            return Arrays.asList(new SynSet[0]);
        }
        return synsets;
    }

    public List<StringEntity> lookupStringEntity(String word) {
        List<SynSet> synsets = this.word2synsets.get(word.toLowerCase());
        if (synsets == null) {
            return Arrays.asList(new StringEntity[0]);
        }
        return synsets.stream().map(ss -> this.synset2se.get(ss)).collect(Collectors.toList());
    }

    public List<StringEntity> getRootsStringEntity() {
        return this.rootsStringEntity;
    }

    public void save(OutputStream outputStream) {
        JSONObject id2synsetObj = new JSONObject();
        for (Map.Entry<String, SynSet> e2 : this.id2synset.entrySet()) {
            Object lu2;
            JSONObject synsetObj = new JSONObject();
            id2synsetObj.put(e2.getKey(), synsetObj);
            SynSet synset = e2.getValue();
            synsetObj.put("id", synset.id);
            synsetObj.put("category", synset.category);
            synsetObj.put("class", synset.clazz);
            JSONArray lexUnitArray = new JSONArray();
            synsetObj.put("lexUnits", lexUnitArray);
            for (Object lu2 : synset.lexUnits) {
                JSONObject luObj = new JSONObject();
                luObj.put("id", ((LexUnit)lu2).id);
                luObj.put("orthForm", ((LexUnit)lu2).orthForm);
                luObj.put("paraphrase", ((LexUnit)lu2).paraphrase);
                lexUnitArray.put(luObj);
            }
            JSONArray genArray = new JSONArray();
            synsetObj.put("gen", genArray);
            lu2 = synset.generalizations.iterator();
            while (lu2.hasNext()) {
                SynSet gen = (SynSet)lu2.next();
                genArray.put(gen.id);
            }
            JSONArray specArray = new JSONArray();
            synsetObj.put("spec", specArray);
            for (SynSet spec : synset.specializations) {
                specArray.put(spec.id);
            }
        }
        try {
            outputStream.write(id2synsetObj.toString(1).getBytes(StandardCharsets.UTF_8));
            outputStream.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void load(InputStream inputStream) {
        SynSet synset;
        JSONObject synsetObj;
        String content;
        try {
            content = IOUtils.toString(inputStream, StandardCharsets.UTF_8);
            inputStream.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        JSONObject id2synsetObj = new JSONObject(content);
        for (String key : id2synsetObj.keySet()) {
            synsetObj = id2synsetObj.getJSONObject(key);
            synset = new SynSet(synsetObj.getString("id"), synsetObj.getString("category"), synsetObj.getString("class"));
            JSONArray lexUnitArray = synsetObj.getJSONArray("lexUnits");
            for (int i = 0; i < lexUnitArray.length(); ++i) {
                JSONObject luObj = lexUnitArray.getJSONObject(i);
                LexUnit lu = new LexUnit(luObj.getString("id"), luObj.getString("orthForm"));
                lu.paraphrase = luObj.optString("paraphrase", null);
                String k = lu.orthForm.toLowerCase();
                SynSet v = synset;
                if (this.word2synsets.containsKey(k)) {
                    this.word2synsets.get(k).add(v);
                } else {
                    this.word2synsets.put(k, new ArrayList<SynSet>(Arrays.asList(v)));
                }
                synset.lexUnits.add(lu);
            }
            this.id2synset.put(key, synset);
        }
        for (String key : id2synsetObj.keySet()) {
            synsetObj = id2synsetObj.getJSONObject(key);
            synset = this.id2synset.get(key);
            JSONArray genArray = synsetObj.getJSONArray("gen");
            for (int i = 0; i < genArray.length(); ++i) {
                synset.generalizations.add(this.id2synset.get(genArray.getString(i)));
            }
            JSONArray specArray = synsetObj.getJSONArray("spec");
            for (int i = 0; i < specArray.length(); ++i) {
                synset.specializations.add(this.id2synset.get(specArray.getString(i)));
            }
        }
        this.initTree();
    }

    public class LexUnit {
        private String id;
        private String orthForm;
        private String paraphrase;
        private List<SynSet> synSets;

        public LexUnit(String id, String orthForm) {
            this.id = id;
            this.orthForm = orthForm;
            this.synSets = new ArrayList<SynSet>();
        }

        public String getOrthForm() {
            return this.orthForm;
        }

        public String toString() {
            return "LexUnit{id=" + this.id + ", orthForm=" + this.orthForm + ", paraphrase=" + this.paraphrase + '}';
        }

        public String getParaphrase() {
            return this.paraphrase;
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + Objects.hashCode(this.id);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LexUnit other = (LexUnit)obj;
            return Objects.equals(this.id, other.id);
        }
    }

    public class SynSet {
        private String id;
        private String category;
        private String clazz;
        private List<LexUnit> lexUnits;
        private List<SynSet> generalizations;
        private List<SynSet> specializations;

        public SynSet(String id, String category, String clazz) {
            this.id = id;
            this.category = category;
            this.clazz = clazz;
            this.lexUnits = new ArrayList<LexUnit>();
            this.generalizations = new ArrayList<SynSet>();
            this.specializations = new ArrayList<SynSet>();
        }

        public String getLexSimple() {
            return this.lexUnits.stream().map(lu -> ((LexUnit)lu).orthForm).collect(Collectors.joining(", "));
        }

        public String getLex() {
            return "[" + this.lexUnits.stream().map(lu -> ((LexUnit)lu).orthForm).collect(Collectors.joining(",")) + "]";
        }

        public String toString() {
            return "SynSet{id=" + this.id + ", category=" + this.category + ", clazz=" + this.clazz + ", lexUnits=" + this.getLex() + '}';
        }

        public String getId() {
            return this.id;
        }

        public String toStringTree() {
            StringBuilder sb = new StringBuilder();
            this.toStringTree("", true, sb);
            return sb.toString();
        }

        private void toStringTree(String prefix, boolean isTail, StringBuilder sb) {
            sb.append(prefix).append(isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(this.toString()).append("\n");
            for (int i = 0; i < this.specializations.size() - 1; ++i) {
                this.specializations.get(i).toStringTree(prefix + (isTail ? "    " : "\u2502   "), false, sb);
            }
            if (this.specializations.size() > 0) {
                this.specializations.get(this.specializations.size() - 1).toStringTree(prefix + (isTail ? "    " : "\u2502   "), true, sb);
            }
        }

        public List<SynSet> getParentPath() {
            ArrayList<SynSet> path = new ArrayList<SynSet>();
            SynSet cur = this;
            while (!cur.generalizations.isEmpty()) {
                if (cur.generalizations.size() > 1) {
                    throw new RuntimeException("parent path is not possible because this string entity has more than one parent: " + cur);
                }
                SynSet parent = cur.generalizations.get(0);
                path.add(parent);
                cur = parent;
            }
            Collections.reverse(path);
            return path;
        }

        public List<SynSet> getParentPathDisambig() {
            ArrayList<SynSet> path = new ArrayList<SynSet>();
            SynSet cur = this;
            while (!cur.generalizations.isEmpty()) {
                SynSet parent = cur.generalizations.get(0);
                path.add(parent);
                cur = parent;
            }
            Collections.reverse(path);
            return path;
        }

        public List<SynSet> getParentPathDisambig(int max2) {
            ArrayList<SynSet> path = new ArrayList<SynSet>();
            SynSet cur = this;
            while (!cur.generalizations.isEmpty()) {
                SynSet parent = cur.generalizations.get(0);
                path.add(parent);
                cur = parent;
                if (path.size() < max2) continue;
                break;
            }
            Collections.reverse(path);
            return path;
        }

        public List<LexUnit> getLexUnits() {
            return this.lexUnits;
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + Objects.hashCode(this.id);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SynSet other = (SynSet)obj;
            return Objects.equals(this.id, other.id);
        }

        public String getCategory() {
            return this.category;
        }

        public String getClazz() {
            return this.clazz;
        }

        public StringEntity toStringEntity() {
            StringEntity se = new StringEntity();
            se.setId(this.id);
            se.setValues(this.getLexUnits().stream().map(lu -> lu.getOrthForm()).collect(Collectors.toList()));
            JSONObject meta = se.getOrCreateJsonObject(GermaNet.GERMANET);
            meta.put("category", this.getCategory());
            meta.put("class", this.getClazz());
            meta.put("lex", this.getLex());
            return se;
        }

        public StringEntitySequence getParentPathStringEntitySequence() {
            StringEntitySequence seq2 = new StringEntitySequence();
            for (SynSet synset : this.getParentPathDisambig()) {
                seq2.getSequenceMembers().add(synset.toStringEntity());
            }
            return seq2;
        }
    }
}

