/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.stringanalyzer;

import de.dfki.sds.stringanalyzer.StringAnalyzerComponent;
import de.dfki.sds.stringanalyzer.string.StringEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ahocorasick.trie.PayloadEmit;
import org.ahocorasick.trie.PayloadTrie;

public class SAGazetteerVector
extends StringAnalyzerComponent {
    private PayloadTrie<String> trie;
    private PayloadTrie.PayloadTrieBuilder<String> builder;
    private Map<StringEntity, double[]> entityVector;
    private List<String> classLabels;
    private List<String> additionalClassLabels;
    private boolean lowercase;
    private boolean stringLengthWeight;

    public SAGazetteerVector() {
        this.clear();
        this.additionalClassLabels = new ArrayList<String>(Arrays.asList("_number", "_letter", "_lcletter", "_ucletter", "_space", "_braket", "_dot", "_separator", "_quote", "_slash", "_other"));
        this.classLabels = new ArrayList<String>();
        this.classLabels.addAll(this.additionalClassLabels);
        this.classLabels.remove("_lcletter");
        this.classLabels.remove("_ucletter");
        this.lowercase = true;
        this.stringLengthWeight = true;
        this.entityVector = new HashMap<StringEntity, double[]>();
    }

    public final void clear() {
        this.builder = PayloadTrie.builder();
        this.trie = null;
    }

    public void register(List<String> strings, String classLabel) {
        for (String str2 : strings) {
            if (this.lowercase) {
                str2 = str2.toLowerCase();
            }
            this.builder.addKeyword(str2, classLabel);
        }
        if (!this.classLabels.contains(classLabel)) {
            this.classLabels.add(classLabel);
        }
    }

    public void build() {
        this.build(true);
    }

    public void build(boolean ignoreOverlaps) {
        if (ignoreOverlaps) {
            this.builder.ignoreOverlaps();
        }
        this.trie = this.builder.build();
    }

    @Override
    public void add(StringEntity entity) {
        int index;
        if (this.trie == null) {
            throw new RuntimeException("build() first");
        }
        if (this.entityVector.containsKey(entity)) {
            return;
        }
        String val = entity.getValue();
        if (this.lowercase) {
            val = val.toLowerCase();
        }
        boolean[] covered = new boolean[val.length()];
        double[] vector = new double[this.classLabels.size()];
        for (PayloadEmit<String> emit2 : this.trie.parseText(val.toLowerCase())) {
            index = this.classLabels.indexOf(emit2.getPayload());
            if (this.stringLengthWeight) {
                int n = index;
                vector[n] = vector[n] + (double)emit2.getKeyword().length() / (double)val.length();
            } else {
                int n = index;
                vector[n] = vector[n] + 1.0;
            }
            for (int i = emit2.getStart(); i <= emit2.getEnd(); ++i) {
                covered[i] = true;
            }
        }
        for (String lbl : this.additionalClassLabels) {
            index = this.classLabels.indexOf(lbl);
            if (index < 0) continue;
            int count = 0;
            for (int i = 0; i < val.length(); ++i) {
                if (covered[i]) continue;
                char c = val.charAt(i);
                int countBefore = count++;
                if (lbl.equals("_number")) {
                    count += Character.isDigit(c) ? 1 : 0;
                } else if (lbl.equals("_space")) {
                    count += Character.isSpaceChar(c) ? 1 : 0;
                } else if (lbl.equals("_braket")) {
                    count += c == '(' || c == ')' || c == '{' || c == '}' || c == '<' || c == '>' || c == '[' || c == ']' ? 1 : 0;
                } else if (lbl.equals("_dot")) {
                    count += c == '(' || c == ')' || c == '.' || c == ',' || c == ';' || c == ':' ? 1 : 0;
                } else if (lbl.equals("_separator")) {
                    count += c == '-' || c == '_' || c == '~' ? 1 : 0;
                } else if (lbl.equals("_quote")) {
                    count += c == '\'' || c == '\"' ? 1 : 0;
                } else if (lbl.equals("_slash")) {
                    count += c == '\\' || c == '|' || c == '/' ? 1 : 0;
                } else if (lbl.equals("_letter")) {
                    count += Character.isLetter(c) ? 1 : 0;
                } else if (lbl.equals("_lcletter")) {
                    count += Character.isLowerCase(c) ? 1 : 0;
                } else if (lbl.equals("_ucletter")) {
                    count += Character.isUpperCase(c) ? 1 : 0;
                } else if (lbl.equals("_other")) {
                    // empty if block
                }
                if (count == countBefore) continue;
                covered[i] = true;
            }
            if (this.stringLengthWeight) {
                vector[index] = (double)count / (double)val.length();
                continue;
            }
            vector[index] = count;
        }
        this.entityVector.put(entity, vector);
    }

    public Map<StringEntity, double[]> getEntityVector() {
        return this.entityVector;
    }

    public List<String> getClassLabels() {
        return this.classLabels;
    }

    public boolean isLowercase() {
        return this.lowercase;
    }

    public void setLowercase(boolean lowercase) {
        this.lowercase = lowercase;
        int i = this.classLabels.size() - 1;
        if (!lowercase) {
            this.classLabels.add(i, "_lcletter");
            this.classLabels.add(i, "_ucletter");
            this.classLabels.remove("_letter");
        } else {
            this.classLabels.remove("_lcletter");
            this.classLabels.remove("_ucletter");
            this.classLabels.add(i, "_letter");
        }
    }

    public boolean isStringLengthWeight() {
        return this.stringLengthWeight;
    }

    public void setStringLengthWeight(boolean stringLengthWeight) {
        this.stringLengthWeight = stringLengthWeight;
    }
}

