/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.mschroeder.commons.lang.math;

import de.dfki.sds.mschroeder.commons.lang.math.Histogram;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MinAvgMaxSdDouble {
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;
    private double sum = 0.0;
    private double count = 0.0;
    private List<Double> ns = new ArrayList<Double>();
    private Histogram histogram = new Histogram();
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String SUM = "sum";
    public static final String COUNT = "count";
    public static final String AVG = "avg";
    public static final String VAR = "var";
    public static final String STDDEV = "stddev";
    public static final List<String> METRICS = Arrays.asList("min", "max", "sum", "count", "avg", "var", "stddev");

    public void add(double n) {
        this.min = Math.min(n, this.min);
        this.max = Math.max(n, this.max);
        this.sum += n;
        this.count += 1.0;
        this.ns.add(n);
        this.histogram.add(n);
    }

    public double get(String name) {
        switch (name) {
            case "min": {
                return this.getMin();
            }
            case "max": {
                return this.getMax();
            }
            case "sum": {
                return this.getSum();
            }
            case "count": {
                return this.getCount();
            }
            case "avg": {
                return this.getAvg();
            }
            case "var": {
                return this.getVariance();
            }
            case "stddev": {
                return this.getStdDev();
            }
        }
        throw new RuntimeException(name + " not found");
    }

    public String toString() {
        return this.getCount() == 0.0 ? "no statistics b.c. count:0" : "min:" + this.min + "/avg:" + String.format(Locale.US, "%.3f", this.getAvg()) + "/max:" + this.max + "/s.d.:" + String.format(Locale.US, "%.3f", this.getStdDev()) + "/sum:" + this.getSum() + "/count:" + this.getCount();
    }

    public String toStringInt() {
        return this.getCount() == 0.0 ? "no statistics b.c. count:0" : "min:" + (int)this.min + " | avg:" + (int)this.getAvg() + " | max:" + (int)this.max + " | s.d.:" + (int)this.getStdDev() + " | sum:" + (int)this.getSum() + " | count:" + (int)this.getCount();
    }

    public String toStringAvgSD(int decimalPoint) {
        return String.format(Locale.US, "%." + decimalPoint + "f", this.getAvg()) + "\u00b1" + String.format(Locale.US, "%." + decimalPoint + "f", this.getStdDev());
    }

    public String toStringAvgSDLatex(int decimalPoint) {
        return "$" + String.format(Locale.US, "%." + decimalPoint + "f", this.getAvg()) + "\\pm" + String.format(Locale.US, "%." + decimalPoint + "f", this.getStdDev()) + "$";
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getSum() {
        return this.sum;
    }

    public double getCount() {
        return this.count;
    }

    public double getAvg() {
        return this.sum / this.count;
    }

    public double getVariance() {
        if (this.count <= 1.0) {
            return 0.0;
        }
        double mean = this.getAvg();
        double temp = 0.0;
        for (double a : this.ns) {
            temp += (a - mean) * (a - mean);
        }
        return temp / (double)((float)(this.count - 1.0));
    }

    public double getStdDev() {
        return Math.sqrt(this.getVariance());
    }

    public String toCSV() {
        return this.min + "," + this.getAvg() + "," + this.max + "," + this.getStdDev();
    }

    public String toCSVHeader(String prefix) {
        return prefix + "-min," + prefix + "-avg," + prefix + "-max," + prefix + "-stddev";
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public void println(String prefix) {
        System.out.println(prefix + this.toString());
    }

    public void println(String prefix, String postfix) {
        System.out.println(prefix + this.toString() + postfix);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(COUNT, this.getCount());
        if (this.count == 0.0) {
            return m;
        }
        m.put(MIN, this.getMin());
        m.put(AVG, this.getAvg());
        m.put(MAX, this.getMax());
        m.put("sd", this.getStdDev());
        m.put(SUM, this.getSum());
        return m;
    }
}

