/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.mschroeder.commons.lang.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Histogram<T> {
    private int count = 0;
    private Map<Object, Integer> value2count = new HashMap<Object, Integer>();
    private Map<Object, List<T>> value2ses = new HashMap<Object, List<T>>();

    public static <T> Histogram fromList(List<T> l) {
        Histogram<T> h = new Histogram<T>();
        for (T o : l) {
            h.add(o);
        }
        return h;
    }

    public static <T> Histogram fromListOfList(List<List<T>> ll) {
        Histogram<T> h = new Histogram<T>();
        int index = 0;
        for (List<T> l : ll) {
            for (T o : l) {
                h.add(index);
            }
            ++index;
        }
        return h;
    }

    public void add(Object value) {
        if (this.value2count.containsKey(value)) {
            this.value2count.put(value, this.value2count.get(value) + 1);
        } else {
            this.value2count.put(value, 1);
        }
        ++this.count;
    }

    public void add(Object value, T relatedStringEntity) {
        this.add(value);
        if (this.value2ses.containsKey(value)) {
            this.value2ses.get(value).add(relatedStringEntity);
        } else {
            this.value2ses.put(value, new LinkedList<Object>(Arrays.asList(relatedStringEntity)));
        }
    }

    public boolean isEmpty() {
        return this.value2count.isEmpty();
    }

    public int size() {
        return this.value2count.size();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean desc) {
        return this.toString((o1, o2) -> (desc ? -1 : 1) * Integer.compare((Integer)o1.getValue(), (Integer)o2.getValue()));
    }

    public String toStringSortKey(boolean desc) {
        return this.toString((o1, o2) -> {
            Comparable c1 = (Comparable)o1.getKey();
            Comparable c2 = (Comparable)o2.getKey();
            return (desc ? -1 : 1) * c1.compareTo(c2);
        });
    }

    public String toString(Comparator<Map.Entry<Object, Integer>> comparator) {
        StringBuilder sb = new StringBuilder();
        sb.append("count").append("\t").append("prop%").append("\t").append("key").append("\n");
        this.value2count.entrySet().stream().sorted(comparator).forEach(e2 -> sb.append(e2.getValue()).append("\t").append(String.format("%.3f%%", (double)((Integer)e2.getValue()).intValue() / (double)this.count * 100.0)).append("\t").append(this.normalize(e2.getKey())).append("\n"));
        sb.append("=\t=\n");
        sb.append(this.count + "\t100%\n");
        return sb.toString();
    }

    private String normalize(Object key) {
        if (key == null) {
            return "null";
        }
        return key.toString().replace("\n", "\\n").replace("\t", "\\t").replace("\r", "\\r");
    }

    public Map<Object, Integer> getValue2Count() {
        return this.value2count;
    }

    public int getCount(T obj) {
        return this.value2count.getOrDefault(obj, 0);
    }

    public boolean contains(T obj) {
        return this.getCount(obj) > 0;
    }

    public <T> List<T> top(int k, Class<T> type) {
        boolean desc = true;
        ArrayList l = new ArrayList(k);
        this.value2count.entrySet().stream().sorted((o1, o2) -> (desc ? -1 : 1) * Integer.compare((Integer)o1.getValue(), (Integer)o2.getValue())).limit(k).forEach(e2 -> l.add(e2.getKey()));
        return l;
    }
}

