/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.mschroeder.commons.lang;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SetUtility {
    public static <T> List<List<T>> subsetsAsList(List<T> input) {
        int allMasks = 1 << input.size();
        ArrayList<List<T>> output = new ArrayList<List<T>>();
        for (int i = 0; i < allMasks; ++i) {
            ArrayList<T> sub = new ArrayList<T>();
            for (int j = 0; j < input.size(); ++j) {
                if ((i & 1 << j) <= 0) continue;
                sub.add(input.get(j));
            }
            output.add(sub);
        }
        return output;
    }

    public static <T> List<Set<T>> subsetsAsSet(List<T> input) {
        int allMasks = 1 << input.size();
        ArrayList<Set<T>> output = new ArrayList<Set<T>>();
        for (int i = 0; i < allMasks; ++i) {
            HashSet<T> sub = new HashSet<T>();
            for (int j = 0; j < input.size(); ++j) {
                if ((i & 1 << j) <= 0) continue;
                sub.add(input.get(j));
            }
            output.add(sub);
        }
        return output;
    }

    public static <T> Set<T> intersection(Set<T> a, Set<T> b) {
        a = new HashSet<T>(a);
        a.retainAll(b);
        return a;
    }

    public static <T> Set<T> subtract(Set<T> a, Set<T> b) {
        a = new HashSet<T>(a);
        a.removeAll(b);
        return a;
    }

    public static <T> Set<T> union(Set<T> a, Set<T> b) {
        a = new HashSet<T>(a);
        a.addAll(b);
        return a;
    }
}

