/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.mschroeder.commons.lang;

public class MemoryUtility {
    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String humanReadableByteCount(long bytes) {
        return MemoryUtility.humanReadableByteCount(bytes, true);
    }

    public static String memoryStatistics() {
        Runtime instance = Runtime.getRuntime();
        StringBuilder sb = new StringBuilder();
        long t = instance.totalMemory();
        long f = instance.freeMemory();
        long u = t - f;
        long m = instance.maxMemory();
        sb.append(MemoryUtility.humanReadableByteCount(u)).append(" used / ").append(MemoryUtility.humanReadableByteCount(t)).append(" total / ").append(MemoryUtility.humanReadableByteCount(m)).append(" max");
        return sb.toString();
    }
}

