/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.mschroeder.commons.lang;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class FileUtility {
    public static int countLines(File file) {
        if (file.isDirectory()) {
            return 0;
        }
        InputStream is = null;
        try {
            int i;
            byte[] c;
            int readChars;
            is = new FileInputStream(file);
            if (file.getName().endsWith("gz")) {
                is = new GZIPInputStream(is);
            }
            if ((readChars = (is = new BufferedInputStream(is)).read(c = new byte[1024])) == -1) {
                int n = 0;
                return n;
            }
            int count = 0;
            while (readChars == 1024) {
                i = 0;
                while (i < 1024) {
                    if (c[i++] != 10) continue;
                    ++count;
                }
                readChars = is.read(c);
            }
            while (readChars != -1) {
                for (i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
                readChars = is.read(c);
            }
            int n = count == 0 ? 1 : count;
            return n;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public static class FileDepth {
        public File file;
        public File parent;
        public int depth;

        public FileDepth(File file, File parent, int depth) {
            this.file = file;
            this.parent = parent;
            this.depth = depth;
        }
    }
}

