/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs.util;

import de.dfki.sds.kecs.util.ExceptionUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SQLiteUtility {
    public static String replaceTablename(String query, String tablename) {
        return query.replaceAll("\\$\\{tablename\\}", tablename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Connection connection, SQLRunnable runnable) {
        try {
            Connection connection2 = connection;
            synchronized (connection2) {
                runnable.run(connection);
            }
        }
        catch (SQLException e2) {
            ExceptionUtility.save(e2);
            throw new RuntimeException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T supply(Connection connection, SQLSupplier<T> runnable) {
        try {
            Connection connection2 = connection;
            synchronized (connection2) {
                return runnable.run(connection);
            }
        }
        catch (SQLException e2) {
            ExceptionUtility.save(e2);
            throw new RuntimeException(e2);
        }
    }

    public static void execute(Connection connection, String query) {
        SQLiteUtility.run(connection, c -> {
            PreparedStatement stmt = c.prepareStatement(query);
            stmt.execute();
            stmt.close();
        });
    }

    public static void executePrepared(Connection connection, String query, Preparer preparer) {
        SQLiteUtility.run(connection, c -> {
            PreparedStatement stmt = c.prepareStatement(query);
            preparer.prepare(stmt);
            stmt.execute();
            stmt.close();
        });
    }

    public static PreparedStatement prepare(Connection connection, String query, Preparer preparer) {
        return SQLiteUtility.supply(connection, c -> {
            PreparedStatement stmt = c.prepareStatement(query);
            preparer.prepare(stmt);
            return stmt;
        });
    }

    @FunctionalInterface
    public static interface Preparer {
        public void prepare(PreparedStatement var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface SQLSupplier<T> {
        public T run(Connection var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface SQLRunnable {
        public void run(Connection var1) throws SQLException;
    }
}

