/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs.util;

import de.dfki.sds.kecs.util.ExceptionUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;

public class Lemmatizer {
    private static Map<Long, String> word2lemma;
    private static Map<String, List<String>> word2lemmaList;
    File tmpFile = new File(System.getProperty("java.io.tmpdir"), "lemma.bin.gz");
    private File lemmatableTxtGz;

    public Lemmatizer(File lemmatableTxtGz) {
        this.lemmatableTxtGz = lemmatableTxtGz;
        this.load();
    }

    public Lemmatizer(String resourcePath) {
        try (ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(Lemmatizer.class.getResourceAsStream(resourcePath)));){
            word2lemma = (Map)ois.readObject();
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void rawToHashMap() {
        word2lemma = new HashMap<Long, String>();
        word2lemmaList = new HashMap<String, List<String>>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(this.lemmatableTxtGz)), "UTF-8"));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] split = line.split("\t");
                long h = Lemmatizer.hash(split[0].toLowerCase());
                if (word2lemma.containsKey(h)) continue;
                word2lemma.put(h, split[1]);
            }
        }
        catch (IOException ex) {
            ExceptionUtility.save(ex);
            throw new RuntimeException(ex);
        }
    }

    private void save() {
        this.save(this.tmpFile);
    }

    public void save(File binFile) {
        try (ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(binFile)));){
            oos.writeObject(word2lemma);
        }
        catch (IOException ex) {
            ExceptionUtility.save(ex);
            throw new RuntimeException(ex);
        }
    }

    private void load() {
        if (word2lemma != null) {
            return;
        }
        if (this.tmpFile.exists()) {
            try (ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(this.tmpFile)));){
                word2lemma = (Map)ois.readObject();
            }
            catch (Exception ex) {
                this.rawToHashMap();
                this.save();
            }
        } else {
            this.rawToHashMap();
            this.save();
        }
    }

    public static long hash(String string) {
        long h = 1125899906842597L;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            h = 31L * h + (long)string.charAt(i);
        }
        return h;
    }

    public String lookup(String word) {
        String lc = StringUtils.lowerCase(word);
        long hash = Lemmatizer.hash(lc);
        return word2lemma.get(hash);
    }

    public String lookupOrWord(String word) {
        String lemma = word2lemma.get(Lemmatizer.hash(StringUtils.lowerCase(word)));
        if (lemma != null) {
            return lemma;
        }
        return word;
    }

    public String lookupOr(String word, Function<String, String> transformer) {
        String lemma = word2lemma.get(Lemmatizer.hash(StringUtils.lowerCase(word)));
        if (lemma != null) {
            return lemma;
        }
        return transformer.apply(word);
    }

    public String lookupOrLowercaseWord(String word) {
        String lemma = word2lemma.get(Lemmatizer.hash(StringUtils.lowerCase(word)));
        if (lemma != null) {
            return lemma;
        }
        return word.toLowerCase();
    }
}

