/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs.util;

import de.dfki.sds.hephaistos.storage.excel.ExcelCell;
import de.dfki.sds.kecs.util.ExcelColumn;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class ExcelTable {
    private transient ExcelCell[][] data;
    private transient List<ExcelColumn> columns = new ArrayList<ExcelColumn>();
    private transient String sheetName;
    private String generationProvenance;
    private transient int index;
    private static final Model creator = ModelFactory.createDefaultModel();

    public ExcelCell[][] getData() {
        return this.data;
    }

    public void setData(ExcelCell[][] data) {
        this.data = data;
    }

    public List<ExcelColumn> getColumns() {
        return this.columns;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public String toCSV() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter p = CSVFormat.DEFAULT.print(sw);
        for (int i = 0; i < this.data.length; ++i) {
            block11: for (int j = 0; j < this.data[i].length; ++j) {
                ExcelCell cell = this.data[i][j];
                if (cell == null) {
                    p.print("");
                    continue;
                }
                if (cell.getCellType() == null) {
                    throw new RuntimeException("type is null in (" + j + "," + i + ")");
                }
                switch (cell.getCellType()) {
                    case "string": {
                        p.print(cell.getValueString());
                        continue block11;
                    }
                    case "numeric": {
                        p.print(cell.getValueNumeric());
                        continue block11;
                    }
                    case "boolean": {
                        p.print(cell.getValueBoolean());
                        continue block11;
                    }
                    default: {
                        throw new RuntimeException(cell.getCellType() + " type not implemented");
                    }
                }
            }
            p.println();
        }
        return sw.toString();
    }

    public String toString() {
        return "ExcelCell{(" + this.data[0].length + ", " + this.data.length + ")}";
    }

    public int getIndex() {
        return this.index;
    }

    public ExcelTable setIndex(int index) {
        this.index = index;
        return this;
    }
}

