/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs.util;

import de.dfki.sds.hephaistos.storage.excel.ExcelCell;
import de.dfki.sds.kecs.util.ExcelTable;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.rdf.model.Resource;
import org.apache.poi.ss.util.CellAddress;

public class ExcelColumn {
    private int index;
    private List<ExcelCell> headerCells = new ArrayList<ExcelCell>();
    private List<ExcelCell> dataCells = new ArrayList<ExcelCell>();
    private List<Resource> predicateObjectMaps = new ArrayList<Resource>();
    private ExcelTable table;
    private int maxColumn;
    private int maxRow;
    private String provenance;

    public ExcelColumn() {
    }

    public ExcelColumn(int index) {
        this();
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public String getLetter() {
        CellAddress addr = new CellAddress(0, this.getIndex());
        String columnLetter = addr.formatAsString().replaceAll("\\d+", "");
        return columnLetter;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public List<ExcelCell> getHeaderCells() {
        return this.headerCells;
    }

    public String getHeaderCellJoinedValues() {
        StringBuilder sb = new StringBuilder();
        for (ExcelCell cell : this.headerCells) {
            sb.append(cell.getValue()).append("\n");
        }
        return sb.toString().trim();
    }

    public void setHeaderCells(List<ExcelCell> headerCells) {
        this.headerCells = headerCells;
    }

    public List<ExcelCell> getDataCells() {
        return this.dataCells;
    }

    public List<ExcelCell> getAllCells() {
        ArrayList<ExcelCell> allCells = new ArrayList<ExcelCell>();
        allCells.addAll(this.getHeaderCells());
        allCells.addAll(this.getDataCells());
        return allCells;
    }

    public void setDataCells(List<ExcelCell> dataCells) {
        this.dataCells = dataCells;
    }

    public List<Resource> getPredicateObjectMaps() {
        return this.predicateObjectMaps;
    }

    public ExcelTable getTable() {
        return this.table;
    }

    public ExcelColumn setTable(ExcelTable table) {
        this.table = table;
        return this;
    }

    public int getMaxColumn() {
        return this.maxColumn;
    }

    public void setMaxColumn(int maxColumn) {
        this.maxColumn = maxColumn;
    }

    public int getMaxRow() {
        return this.maxRow;
    }

    public void setMaxRow(int maxRow) {
        this.maxRow = maxRow;
    }

    public String getProvenance() {
        return this.provenance;
    }

    public void setProvenance(String provenance) {
        this.provenance = provenance;
    }
}

