/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs.util;

import de.dfki.sds.hephaistos.storage.InternalStorageMetaData;
import de.dfki.sds.hephaistos.storage.StorageSummary;
import de.dfki.sds.hephaistos.storage.excel.ExcelCell;
import de.dfki.sds.hephaistos.storage.excel.ExcelSheet;
import de.dfki.sds.hephaistos.storage.excel.ExcelStorage;
import de.dfki.sds.hephaistos.storage.excel.ExcelTextStyle;
import de.dfki.sds.hephaistos.storage.file.FileInfo;
import de.dfki.sds.hephaistos.storage.file.FileInfoStorage;
import de.dfki.sds.hephaistos.storage.file.FolderInfo;
import de.dfki.sds.kecs.KecsSettings;
import de.dfki.sds.kecs.util.ExcelColumn;
import de.dfki.sds.kecs.util.ExcelTable;
import de.dfki.sds.mschroeder.commons.lang.data.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class ColumnMemoryExcelStorage
extends ExcelStorage {
    private Map<Integer, ExcelTable> sheetId2table = new HashMap<Integer, ExcelTable>();
    private Map<Pair<Integer>, ExcelColumn> sheetCol2Column = new HashMap<Pair<Integer>, ExcelColumn>();
    private int tblIndex;

    public ColumnMemoryExcelStorage(InternalStorageMetaData metaData) {
        super(metaData);
    }

    @Override
    public void addCellBulk(Collection<ExcelCell> items) {
        for (ExcelCell cell : items) {
            ExcelTable table = this.getTable(cell.getSheetId());
            ExcelColumn col = this.getColumn(cell.getSheetId(), cell.getColumn(), table);
            col.setIndex(cell.getColumn());
            col.getDataCells().add(cell);
        }
    }

    private ExcelTable getTable(int sheetId) {
        return this.sheetId2table.computeIfAbsent(sheetId, id -> new ExcelTable().setIndex(this.tblIndex++));
    }

    private ExcelColumn getColumn(int sheetId, int column, ExcelTable table) {
        return this.sheetCol2Column.computeIfAbsent(new Pair<Integer>(sheetId, column), id -> {
            ExcelColumn c = new ExcelColumn();
            c.setTable(table);
            table.getColumns().add(c);
            return c;
        });
    }

    @Override
    public void addBulk(Collection<ExcelSheet> items) {
        for (ExcelSheet sheet : items) {
            ExcelTable tbl = this.getTable(sheet.getId());
            tbl.setSheetName(sheet.getName());
        }
    }

    public List<ExcelTable> getTables() {
        return new ArrayList<ExcelTable>(this.sheetId2table.values());
    }

    public List<ExcelColumn> getColumns() {
        return new ArrayList<ExcelColumn>(this.sheetCol2Column.values());
    }

    public static void convertToTree(ColumnMemoryExcelStorage excelStorage, FileInfoStorage fileInfoStorage, KecsSettings settings) {
        ArrayList<FileInfo> bulk = new ArrayList<FileInfo>();
        FolderInfo excelFolder = new FolderInfo();
        excelFolder.setId(2);
        excelFolder.setDirectory(true);
        excelFolder.setParent(1);
        excelFolder.setName("");
        excelFolder.setPath("/Excel");
        JSONObject meta = new JSONObject();
        meta.put("uri", "urn:file:2");
        meta.put("basename", excelFolder.getName());
        excelFolder.setMeta(meta.toString());
        bulk.add(excelFolder);
        int id = 3;
        ArrayList<ExcelColumn> skippedColumnsContent = new ArrayList<ExcelColumn>();
        String whiteList = settings.getExcelWhitelist();
        HashMap<String, List<String>> sheet2letterWhitelist = null;
        if (whiteList != null && !whiteList.isEmpty()) {
            sheet2letterWhitelist = new HashMap<String, List<String>>();
            for (String segment : whiteList.split("\\;")) {
                if (segment.trim().isEmpty()) continue;
                String[] split = segment.split("\\:");
                String sheetName = split[0];
                String[] letters = split[1].split("\\,");
                sheet2letterWhitelist.put(sheetName, Arrays.asList(letters));
            }
        }
        for (ExcelTable table : excelStorage.getTables()) {
            FolderInfo tableFolder = new FolderInfo();
            tableFolder.setId(id);
            tableFolder.setDirectory(true);
            tableFolder.setParent(2);
            tableFolder.setPath(excelFolder.getPath() + "/" + table.getSheetName());
            tableFolder.setName(table.getSheetName());
            tableFolder.setSort(table.getIndex());
            meta = new JSONObject();
            meta.put("uri", "urn:file:" + id);
            meta.put("basename", table.getSheetName());
            tableFolder.setMeta(meta.toString());
            ++id;
            bulk.add(tableFolder);
            for (ExcelColumn column : table.getColumns()) {
                List list;
                ExcelCell head;
                List<ExcelCell> dataCells = column.getDataCells();
                if (dataCells.isEmpty() || (head = dataCells.remove(0)).getValueString() == null) continue;
                FolderInfo columnFolder = new FolderInfo();
                columnFolder.setId(id);
                columnFolder.setDirectory(true);
                columnFolder.setParent(tableFolder.getId());
                columnFolder.setSort(column.getIndex());
                String colName = head.getValueString().replace("\n", " ").replace("\t", " ");
                columnFolder.setPath(tableFolder.getPath() + "/" + colName);
                columnFolder.setName(colName);
                meta = new JSONObject();
                meta.put("uri", "urn:file:" + id);
                meta.put("basename", colName);
                columnFolder.setMeta(meta.toString());
                ++id;
                bulk.add(columnFolder);
                HashSet<String> contents = new HashSet<String>();
                for (ExcelCell excelCell : dataCells) {
                    String content;
                    if (excelCell.getValueString() == null || (content = excelCell.getValueString().replace("\n", " ").replace("\t", " ").trim()).isEmpty()) continue;
                    contents.add(content);
                }
                int charSum = 0;
                for (String content : contents) {
                    charSum += content.length();
                }
                if (sheet2letterWhitelist != null && (list = (List)sheet2letterWhitelist.get(table.getSheetName())) != null && !list.contains(column.getLetter())) {
                    System.out.println(table.getSheetName() + ":" + column.getLetter() + " skipped due to whitelist");
                    skippedColumnsContent.add(column);
                    continue;
                }
                if (!contents.isEmpty()) {
                    ArrayList arrayList = new ArrayList(contents);
                    arrayList.sort((a, b) -> a.compareToIgnoreCase((String)b));
                    int sortIndex = 0;
                    for (String content2 : arrayList) {
                        FileInfo cellFile = new FileInfo();
                        cellFile.setId(id);
                        cellFile.setDirectory(false);
                        cellFile.setParent(columnFolder.getId());
                        cellFile.setSort(sortIndex++);
                        cellFile.setPath(tableFolder.getPath() + "/" + content2);
                        cellFile.setName(content2);
                        meta = new JSONObject();
                        meta.put("uri", "urn:file:" + id);
                        meta.put("basename", content2);
                        cellFile.setMeta(meta.toString());
                        ++id;
                        bulk.add(cellFile);
                    }
                    continue;
                }
                skippedColumnsContent.add(column);
            }
        }
        fileInfoStorage.insertBulk(bulk);
        System.out.println(skippedColumnsContent.size() + " columns skipped");
    }

    @Override
    public void addTextStyleBulk(Collection<ExcelTextStyle> items) {
    }

    @Override
    public void removeCellBulk(Collection<ExcelCell> items) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void removeTextStyleBulk(Collection<ExcelTextStyle> items) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public Iterable<ExcelCell> getCellListIter(ExcelSheet sheet) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public Iterable<ExcelTextStyle> getTextStyleListIter(ExcelCell cell) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public ExcelSheet getSheet(int id) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public ExcelCell getCell(int id) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public List<ExcelCell> getRow(ExcelSheet sheet, int equalRow, int greaterEqualColumn) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void removeBulk(Collection<ExcelSheet> items) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public Iterable<ExcelSheet> getListIter() {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void clear() {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void remove() {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public StorageSummary summary() {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public long size() {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void close() {
        throw new RuntimeException("not implemented yet");
    }
}

