/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs.server;

import com.google.gson.GsonBuilder;
import com.r6lab.sparkjava.jwt.TokenService;
import com.r6lab.sparkjava.jwt.controller.AuthController;
import com.r6lab.sparkjava.jwt.user.UserPrincipal;
import com.r6lab.sparkjava.jwt.user.UserService;
import de.dfki.sds.hephaistos.storage.StorageItem;
import de.dfki.sds.hephaistos.storage.assertion.Assertion;
import de.dfki.sds.hephaistos.storage.assertion.AssertionPool;
import de.dfki.sds.hephaistos.storage.assertion.Intelligence;
import de.dfki.sds.hephaistos.storage.assertion.Phase;
import de.dfki.sds.hephaistos.storage.assertion.Rating;
import de.dfki.sds.hephaistos.storage.file.FileInfo;
import de.dfki.sds.hephaistos.storage.file.FolderInfo;
import de.dfki.sds.kecs.KecsApp;
import de.dfki.sds.kecs.KecsManager;
import de.dfki.sds.kecs.KecsSettings;
import de.dfki.sds.kecs.ml.StatusManager;
import de.dfki.sds.kecs.ml.VisualManager;
import de.dfki.sds.kecs.modules.ConceptDiscovery;
import de.dfki.sds.kecs.modules.DomainTerminologyExtraction;
import de.dfki.sds.kecs.modules.OntologyPopulation;
import de.dfki.sds.kecs.util.ExceptionUtility;
import de.dfki.sds.kecs.util.FileInfoSearchResult;
import de.dfki.sds.kecs.util.JsonUtility;
import de.dfki.sds.kecs.util.KecsUtils;
import de.dfki.sds.kecs.util.TypeWithIntel;
import de.dfki.sds.kecs.vocab.KECS;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.commons.io.IOUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.SKOS;
import org.json.JSONArray;
import org.json.JSONObject;
import spark.Request;
import spark.Response;
import spark.Spark;

public class KecsHumlServer {
    private static final String ROOT_PATH = "/de/dfki/sds/kecs";
    private static final String SECRET_JWT = "kO9nqmbYcMFzB0gUWofW";
    private TokenService tokenService;
    private AuthController authController;
    private UserService userService;
    private int port;
    private KecsManager manager;
    private File resultFolder;
    private final int defaultLimit = 10;
    private final int defaultSearchConceptLimit = 50;
    private int eventCounter = -1;
    private File userCsvFile;
    private KecsSettings.Language language;

    public KecsHumlServer(int port, File userCsvFile, KecsManager manager, File resultFolder, KecsSettings.Language language) {
        this.port = port;
        this.userCsvFile = userCsvFile;
        this.manager = manager;
        this.resultFolder = resultFolder;
        this.language = language;
    }

    public void start() {
        Spark.port(this.port);
        Spark.exception(Exception.class, (exception, request, response) -> {
            ExceptionUtility.save(exception);
            exception.printStackTrace();
            response.body(exception.getMessage());
        });
        Spark.staticFiles.location("/de/dfki/sds/kecs/web");
        Spark.before((req, res) -> {
            String path = req.pathInfo();
            if (!path.equals("/") && path.endsWith("/")) {
                res.redirect(path.substring(0, path.length() - 1));
            }
        });
        Spark.get("/", this::getRoot);
        Spark.get("/app", this::getApp);
        Spark.post("/getChildren", this::getChildren);
        Spark.post("/browseChild", this::browseChild);
        Spark.post("/getTypes", this::getTypes);
        Spark.post("/getProperties", this::getProperties);
        Spark.post("/getPositiveTypes", this::getPositiveTypes);
        Spark.post("/getPositiveProperties", this::getPositiveProperties);
        Spark.post("/getSuggestions", this::getSuggestions);
        Spark.post("/getStatus", this::getStatus);
        Spark.post("/addType", this::addType);
        Spark.post("/addProperty", this::addProperty);
        Spark.post("/sendAssertion", this::sendAssertion);
        Spark.post("/assertType", this::assertType);
        Spark.post("/assertTypes", this::assertTypes);
        Spark.post("/assertMerge", this::assertMerge);
        Spark.post("/assertMerges", this::assertMerges);
        Spark.post("/assertNegativeTermsRecursively", this::assertNegativeTermsRecursively);
        Spark.post("/assertNewConcept", this::assertNewConcept);
        Spark.post("/sendEvent", this::sendEvent);
        Spark.post("/searchConcepts", this::searchConcepts);
        Spark.post("/browseConcept", this::browseConcept);
        Spark.post("/explorerSearch", this::explorerSearch);
        Spark.post("/explorerSearchCreate", this::explorerSearchCreate);
        Spark.get("/download/:name", this::download);
        Spark.get("/visual/:name", this::visual);
        this.initJsonWebToken();
        Spark.awaitInitialization();
        System.out.println("server running at localhost:" + this.port);
    }

    private void initJsonWebToken() {
        this.tokenService = new TokenService(SECRET_JWT);
        this.userService = new UserService(this.userCsvFile);
        this.authController = new AuthController(new GsonBuilder().create(), this.userService, this.tokenService, this.resultFolder);
        this.authController.init();
    }

    private Object getRoot(Request req, Response resp) throws IOException {
        this.saveRequest(req);
        String html = IOUtils.toString(KecsHumlServer.class.getResourceAsStream("/de/dfki/sds/kecs/web/root_" + this.language.name() + ".html"), StandardCharsets.UTF_8);
        boolean unauthorized = req.queryMap().hasKey("unauthorized");
        html = html.replace("${extraMessage}", unauthorized ? "<div class=\"alert alert-warning\" role=\"alert\">Sie m\u00fcssen sich zuerst anmelden.</div>" : "");
        resp.type("text/html");
        return html;
    }

    private Object getApp(Request req, Response resp) throws IOException {
        this.saveRequest(req);
        String html = IOUtils.toString(KecsHumlServer.class.getResourceAsStream("/de/dfki/sds/kecs/web/app.html"), StandardCharsets.UTF_8);
        html = html.replace("${locale}", this.language.name());
        resp.type("text/html");
        return html;
    }

    private JSONObject getChildren(String parentUri) {
        FolderInfo folderInfo;
        JSONObject result = new JSONObject();
        JSONArray children = new JSONArray();
        result.put("children", children);
        if (parentUri == null) {
            folderInfo = (FolderInfo)this.manager.getFileInfoStorage().getRoot();
        } else {
            int id = 2;
            if (!parentUri.isEmpty()) {
                id = KecsUtils.getId(parentUri);
            }
            folderInfo = (FolderInfo)this.manager.getFileInfoStorage().get(id);
        }
        Optional parentOfParent = this.manager.getFileInfoStorage().getParentOf(folderInfo);
        ArrayList<FolderInfo> childrenList = new ArrayList<FolderInfo>();
        childrenList.addAll(this.manager.getFileInfoStorage().getBranchChildren(folderInfo));
        childrenList.addAll(this.manager.getFileInfoStorage().getLeafChildren(folderInfo));
        JSONObject parentObj = this.toJson(folderInfo);
        result.put("parent", parentObj);
        for (FileInfo fileInfo : childrenList) {
            JSONObject obj = this.toJson(fileInfo);
            Resource resource = ResourceFactory.createResource(obj.getString("uri"));
            List<Assertion> domainTermAssertions = this.manager.getAssertionPool().getAssertions(resource, KECS.containsDomainTerm, null, Phase.DomainTerminologyExtraction, null, null, null, 0.0);
            domainTermAssertions.sort((a, b) -> {
                int iA = fn.getName().indexOf(a.getStatement().getString());
                int iB = fn.getName().indexOf(b.getStatement().getString());
                return Integer.compare(iA, iB);
            });
            HashMap<String, Integer> domainTerm2index = new HashMap<String, Integer>();
            for (int i = 0; i < domainTermAssertions.size(); ++i) {
                domainTerm2index.put(domainTermAssertions.get(i).getStatement().getString(), i);
            }
            JSONObject terms = Assertion.toJson(domainTermAssertions);
            if (terms.has(Rating.Positive.toString())) {
                JSONArray array = terms.getJSONArray(Rating.Positive.toString());
                List<JSONObject> l = JsonUtility.getList(array, JSONObject.class);
                for (int i = array.length() - 1; i >= 1; --i) {
                    JSONObject mergeObject = new JSONObject();
                    mergeObject.put("merge", true);
                    l.add(i, mergeObject);
                }
            }
            obj.put("terms", terms);
            List<Assertion> topicAssertions = this.manager.getAssertionPool().getAssertions(resource, FOAF.topic, null, Phase.ConceptDiscovery, null, null, null, 0.0);
            HashMap<Resource, Integer> topic2index = new HashMap<Resource, Integer>();
            block3: for (Assertion topicAssertion : topicAssertions) {
                Resource topic = topicAssertion.getObject();
                for (Assertion hiddenLbl : this.manager.getAssertionPool().getAssertions(topic, SKOS.hiddenLabel, null, Phase.ConceptDiscovery, null, null, null, 0.0)) {
                    Integer index = (Integer)domainTerm2index.get(hiddenLbl.getStatement().getString());
                    if (index == null) continue;
                    topic2index.put(topic, index);
                    continue block3;
                }
            }
            topicAssertions.sort((a, b) -> {
                Resource topicA = a.getObject();
                Resource topicB = b.getObject();
                Integer indexA = (Integer)topic2index.get(topicA);
                Integer indexB = (Integer)topic2index.get(topicB);
                if (indexA == null || indexB == null) {
                    return 0;
                }
                return Integer.compare(indexA, indexB);
            });
            JSONObject topics = Assertion.toJson(topicAssertions);
            for (String rating : topics.keySet()) {
                JSONArray ratingArray = topics.getJSONArray(rating);
                for (int i = 0; i < ratingArray.length(); ++i) {
                    JSONObject entry = ratingArray.getJSONObject(i);
                    Resource target = ResourceFactory.createResource(entry.getJSONObject("statement").getString("topic"));
                    List<Assertion> targetPrefLabels = this.manager.getAssertionPool().getAssertions(target, SKOS.prefLabel, null, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0);
                    String targetPrefLabel = AssertionPool.getPrefLabelString(targetPrefLabels);
                    entry.put("targetPrefLabel", targetPrefLabel);
                }
            }
            obj.put("concepts", topics);
            children.put(obj);
        }
        if (parentOfParent.isPresent()) {
            result.put("parentOfParent", new JSONObject(((FolderInfo)parentOfParent.get()).getMeta()).getString("uri"));
        }
        return result;
    }

    private Object getChildren(Request req, Response resp) {
        JSONObject json = new JSONObject(req.body());
        String parentUri = json.getString("parent");
        JSONObject result = this.getChildren(parentUri);
        resp.type("application/json");
        return result.toString(2);
    }

    private Object browseChild(Request req, Response resp) {
        this.saveRequest(req);
        JSONObject json = new JSONObject(req.body());
        String childUri = json.getString("child");
        JSONObject result = this.browseChild(childUri);
        if (result != null) {
            resp.type("application/json");
        }
        return result.toString(2);
    }

    private JSONObject browseChild(String childUri) {
        int childId = KecsUtils.getId(childUri);
        FileInfo child = (FileInfo)this.manager.getFileInfoStorage().get(childId);
        Optional parentOpt = this.manager.getFileInfoStorage().getParentOf(child);
        if (parentOpt.isPresent()) {
            String parentUri = new JSONObject(((FolderInfo)parentOpt.get()).getMeta()).getString("uri");
            JSONObject result = this.getChildren(parentUri);
            return result;
        }
        return null;
    }

    private Object searchConcepts(Request req, Response resp) {
        this.saveRequest(req);
        JSONObject reqJson = new JSONObject(req.body());
        String conceptName = reqJson.optString("conceptName").toLowerCase();
        boolean hasConceptName = conceptName != null && !conceptName.trim().isEmpty();
        String conceptType = reqJson.getString("conceptType");
        boolean hasConceptType = conceptType != null && !conceptType.trim().isEmpty();
        Resource conceptTypeResource = hasConceptType ? ResourceFactory.createResource(conceptType) : null;
        boolean alsoNegative = reqJson.getBoolean("alsoNegative");
        int offset = reqJson.optInt("offset", 0);
        JSONObject result = new JSONObject();
        Rating ratingFilter = alsoNegative ? null : Rating.Positive;
        JSONArray conceptResult = new JSONArray();
        result.put("concepts", conceptResult);
        List<Assertion> conceptAssertions = this.manager.getAssertionPool().getAssertions(null, RDF.type, ConceptDiscovery.DEFAULT_TYPE, Phase.ConceptDiscovery, null, null, ratingFilter, 0.0);
        result.put("total", conceptAssertions.size());
        Map<Resource, String> typeMap = null;
        if (!conceptAssertions.isEmpty()) {
            typeMap = this.manager.getAssertionPool().getTypePrefLabelMap();
        }
        if (!hasConceptName && !hasConceptType) {
            conceptAssertions.sort((a, b) -> b.getWhen().compareTo(a.getWhen()));
            List<Assertion> sublist = this.calculateList(offset, 50, conceptAssertions, result);
            for (Assertion conceptAssertion : sublist) {
                List<Assertion> prefLabels = this.manager.getAssertionPool().getAssertions(conceptAssertion.getSubject(), SKOS.prefLabel, null, Phase.ConceptDiscovery, null, null, null, 0.0);
                List<Assertion> list = this.manager.getAssertionPool().getAssertions(conceptAssertion.getSubject(), RDF.type, null, Phase.OntologyPopulation, null, null, null, 0.0);
                TypeWithIntel typeWithIntel = KecsUtils.getType(list);
                JSONObject resultEntry = new JSONObject();
                this.conceptToJson(AssertionPool.getPrefLabelString(prefLabels), conceptAssertion, typeWithIntel, typeMap, resultEntry);
                conceptResult.put(resultEntry);
            }
            result.put("paginationMode", true);
            resp.type("application/json");
            return result.toString(2);
        }
        HashSet<Resource> hasBroader = new HashSet<Resource>();
        HashSet<Resource> hasNonTaxRel = new HashSet<Resource>();
        if (hasConceptType) {
            String predicateUri = reqJson.optString("predicate", "");
            if (conceptTypeResource.equals(OntologyPopulation.CONCEPT_TYPE)) {
                for (Assertion assertion : this.manager.getAssertionPool().getAssertions(null, SKOS.broader, null, Phase.ConceptHierarchyDerivation, null, null, Rating.Positive, 0.0)) {
                    hasBroader.add(assertion.getSubject());
                }
            } else if (!predicateUri.isEmpty()) {
                Property predicate = KecsApp.creator.createProperty(predicateUri);
                for (Assertion nonTaxAssertion : this.manager.getAssertionPool().getAssertions(null, predicate, null, Phase.NonTaxonomicRelationLearning, Intelligence.NI, null, Rating.Positive, 0.0)) {
                    hasNonTaxRel.add(nonTaxAssertion.getSubject());
                }
            }
        }
        for (Assertion conceptAssertion : conceptAssertions) {
            boolean oneIsGiven;
            List<Assertion> list = this.manager.getAssertionPool().getAssertions(conceptAssertion.getSubject(), SKOS.prefLabel, null, Phase.ConceptDiscovery, null, null, null, 0.0);
            List<Assertion> hiddenLabels = this.manager.getAssertionPool().getAssertions(conceptAssertion.getSubject(), SKOS.hiddenLabel, null, Phase.ConceptDiscovery, null, null, null, 0.0);
            List<Assertion> types = this.manager.getAssertionPool().getAssertions(conceptAssertion.getSubject(), RDF.type, null, Phase.OntologyPopulation, null, null, null, 0.0);
            JSONObject resultEntry = new JSONObject();
            TypeWithIntel typeWithIntel = KecsUtils.getType(types);
            String prefLabel = AssertionPool.getPrefLabelString(list);
            HashSet<String> allLabels = new HashSet<String>();
            for (Assertion prefLabelAssertion : list) {
                if (!alsoNegative && prefLabelAssertion.getRating() != Rating.Positive) continue;
                allLabels.add(prefLabelAssertion.getStatement().getString());
            }
            for (Assertion techLabelAssertion : hiddenLabels) {
                if (!alsoNegative && techLabelAssertion.getRating() != Rating.Positive) continue;
                allLabels.add(techLabelAssertion.getStatement().getString());
            }
            boolean labelMatch = false;
            if (hasConceptName) {
                boolean oneMatch = false;
                for (String lbl : allLabels) {
                    int i = lbl.toLowerCase().indexOf(conceptName);
                    if (i == -1) continue;
                    oneMatch = true;
                    resultEntry.put("left", lbl.substring(0, i));
                    resultEntry.put("middle", lbl.substring(i, i + conceptName.length()));
                    resultEntry.put("right", lbl.substring(i + conceptName.length(), lbl.length()));
                    resultEntry.put("matchesPrefLbl", lbl.equals(prefLabel));
                    break;
                }
                if (oneMatch) {
                    labelMatch = true;
                }
            }
            boolean typeMatch = false;
            if (typeWithIntel != null && conceptTypeResource != null) {
                typeMatch = typeWithIntel.getType().equals(conceptTypeResource);
            }
            boolean bothAreGiven = hasConceptName && hasConceptType;
            boolean bl = oneIsGiven = (hasConceptName || hasConceptType) && !bothAreGiven;
            if ((!oneIsGiven || !labelMatch && !typeMatch) && (!bothAreGiven || !labelMatch || !typeMatch)) continue;
            this.conceptToJson(prefLabel, conceptAssertion, typeWithIntel, typeMap, resultEntry);
            if (hasConceptType) {
                if (hasBroader.contains(conceptAssertion.getSubject())) {
                    resultEntry.put("showTree", true);
                } else if (hasNonTaxRel.contains(conceptAssertion.getSubject())) {
                    resultEntry.put("showArrow", true);
                } else if (typeWithIntel.getType().equals(OntologyPopulation.CONCEPT_TYPE)) {
                    boolean isNotAnnotated = this.manager.getAssertionPool().getAssertions(null, FOAF.topic, conceptAssertion.getSubject(), Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0).isEmpty();
                    resultEntry.put("showLeaf", isNotAnnotated);
                }
            }
            conceptResult.put(resultEntry);
        }
        List<JSONObject> list = JsonUtility.getList(conceptResult, JSONObject.class);
        list.sort((a, b) -> {
            Object whenA = a.getJSONObject("assertion").get("when");
            Object whenB = b.getJSONObject("assertion").get("when");
            LocalDateTime ldtA = (LocalDateTime)whenA;
            LocalDateTime ldtB = (LocalDateTime)whenB;
            return ldtB.compareTo(ldtA);
        });
        resp.type("application/json");
        return result.toString(2);
    }

    private Object browseConcept(Request req, Response resp) {
        this.saveRequest(req);
        JSONObject reqJson = new JSONObject(req.body());
        String uri = reqJson.getString("uri");
        Resource conceptResource = uri != null && !uri.isEmpty() ? ResourceFactory.createResource(uri) : null;
        int offsetP = reqJson.optInt("offsetP", 0);
        int limitP = reqJson.optInt("limitP", 10);
        int offsetN = reqJson.optInt("offsetN", 0);
        int limitN = reqJson.optInt("limitN", 10);
        if (conceptResource == null) {
            return null;
        }
        JSONObject conceptObj = this.browseConcept(conceptResource, offsetP, limitP, offsetN, limitN);
        if (conceptObj == null) {
            return null;
        }
        resp.type("application/json");
        return conceptObj.toString(2);
    }

    private JSONObject browseConcept(Resource conceptResource, int offsetP, int limitP, int offsetN, int limitN) {
        List<Assertion> concepts = this.manager.getAssertionPool().getAssertions(conceptResource, RDF.type, ConceptDiscovery.DEFAULT_TYPE, Phase.ConceptDiscovery, null, null, null, 0.0);
        if (concepts.isEmpty()) {
            return null;
        }
        Assertion conceptAssertion = concepts.get(0);
        JSONObject conceptObj = new JSONObject();
        conceptObj.put("userEntryAltLabel", "");
        conceptObj.put("uri", conceptAssertion.getStatement().getSubject().getURI());
        conceptObj.put("assertion", Assertion.toJson(conceptAssertion));
        List<Assertion> types = this.manager.getAssertionPool().getAssertions(conceptAssertion.getSubject(), RDF.type, null, Phase.OntologyPopulation, null, null, null, 0.0);
        Assertion.orderByRatingIntelConfidence(types);
        conceptObj.put("types", Assertion.toJsonArray(types));
        TypeWithIntel typeWithIntel = KecsUtils.getType(types);
        conceptObj.put("type", typeWithIntel.getType().getURI());
        conceptObj.put("typeIntelligence", typeWithIntel.getIntel().name());
        List<Assertion> prefLabels = this.manager.getAssertionPool().getAssertions(conceptAssertion.getSubject(), SKOS.prefLabel, null, Phase.ConceptDiscovery, null, null, null, 0.0);
        conceptObj.put("prefLabels", Assertion.toJsonArrayOrderByRating(prefLabels));
        conceptObj.put("prefLabel", AssertionPool.getPrefLabelString(prefLabels));
        List<Assertion> hiddenLabels = this.manager.getAssertionPool().getAssertions(conceptAssertion.getSubject(), SKOS.hiddenLabel, null, Phase.ConceptDiscovery, null, null, null, 0.0);
        hiddenLabels.sort((a, b) -> a.getStatement().getString().compareToIgnoreCase(b.getStatement().getString()));
        conceptObj.put("hiddenLabels", Assertion.toJsonArrayOrderByRating(hiddenLabels));
        List<Assertion> isTopicOfs = this.manager.getAssertionPool().getAssertions(null, FOAF.topic, conceptAssertion.getSubject(), Phase.ConceptDiscovery, null, null, null, 0.0);
        ArrayList isTopicOfsPositive = new ArrayList();
        ArrayList isTopicOfsNegative = new ArrayList();
        isTopicOfs.forEach(a -> {
            if (a.getRating() == Rating.Positive) {
                isTopicOfsPositive.add(a);
            } else {
                isTopicOfsNegative.add(a);
            }
        });
        JSONObject topicPaginationPositive = new JSONObject();
        conceptObj.put("isTopicOfsPositive", topicPaginationPositive);
        List<Assertion> isTopicOfsPositiveSublist = this.calculateList(offsetP, limitP, isTopicOfsPositive, topicPaginationPositive);
        JSONObject topicPaginationNegative = new JSONObject();
        conceptObj.put("isTopicOfsNegative", topicPaginationNegative);
        List<Assertion> isTopicOfsNegativeSublist = this.calculateList(offsetN, limitN, isTopicOfsNegative, topicPaginationNegative);
        JSONArray isTopicOfsPositiveArray = Assertion.toJsonArrayOrderByIntel(isTopicOfsPositiveSublist);
        JSONArray isTopicOfsNegativeArray = Assertion.toJsonArrayOrderByRating(isTopicOfsNegativeSublist);
        List<JSONArray> listOfArrays = Arrays.asList(isTopicOfsPositiveArray, isTopicOfsNegativeArray);
        topicPaginationPositive.put("list", isTopicOfsPositiveArray);
        topicPaginationNegative.put("list", isTopicOfsNegativeArray);
        for (JSONArray isTopicOfsArray : listOfArrays) {
            for (int i = 0; i < isTopicOfsArray.length(); ++i) {
                JSONObject isTopicOf = isTopicOfsArray.getJSONObject(i);
                int id = KecsUtils.getId(isTopicOf.getJSONObject("statement").getString("@id"));
                FileInfo fi = (FileInfo)this.manager.getFileInfoStorage().get(id);
                Optional parentOpt = this.manager.getFileInfoStorage().getParentOf(fi);
                JSONObject fileObj = this.toJson(fi);
                isTopicOf.put("child", fileObj);
                if (!parentOpt.isPresent()) continue;
                JSONObject parentObj = this.toJson((FileInfo)parentOpt.get());
                isTopicOf.put("parent", parentObj);
            }
        }
        return conceptObj;
    }

    private Object explorerSearch(Request req, Response resp) {
        this.saveRequest(req);
        JSONObject reqJson = new JSONObject(req.body());
        String search = reqJson.getString("search");
        boolean regex = reqJson.getBoolean("regex");
        Resource folderResource = null;
        DomainTerminologyExtraction dte = this.manager.getDomainTerminologyExtraction();
        List<FileInfoSearchResult> searchResult = dte.search(search, regex, folderResource);
        JSONObject result = new JSONObject();
        JSONArray matches = new JSONArray();
        result.put("matches", matches);
        int limit = 500;
        result.put("limit", limit);
        result.put("total", searchResult.size());
        if (searchResult.size() > limit) {
            searchResult = searchResult.subList(0, limit);
        }
        result.put("regex", regex);
        for (FileInfoSearchResult sr : searchResult) {
            JSONObject srObj = new JSONObject();
            srObj.put("prefLabel", sr.getFileInfo().getName());
            srObj.put("isFile", !sr.getFileInfo().isDirectory());
            srObj.put("left", sr.getLeft());
            srObj.put("middle", sr.getMiddle());
            srObj.put("right", sr.getRight());
            srObj.put("uri", KecsUtils.getURI(sr.getFileInfo()));
            srObj.put("selected", true);
            matches.put(srObj);
        }
        resp.type("application/json");
        return result.toString(2);
    }

    private Object getTypes(Request req, Response resp) {
        this.saveRequest(req);
        JSONObject result = new JSONObject();
        JSONArray typeArray = new JSONArray();
        result.put("types", typeArray);
        List<Assertion> typeAssertions = this.manager.getAssertionPool().getAssertions(null, RDF.type, RDFS.Class, Phase.OntologyPopulation, null, null, null, 0.0);
        typeAssertions.sort((a, b) -> {
            int cmp = a.getRating().compareTo(b.getRating());
            if (cmp == 0) {
                List<Assertion> prefLabelsA = this.manager.getAssertionPool().getAssertions(a.getSubject(), SKOS.prefLabel, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
                List<Assertion> prefLabelsB = this.manager.getAssertionPool().getAssertions(b.getSubject(), SKOS.prefLabel, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
                if (prefLabelsA.isEmpty() || prefLabelsB.isEmpty()) {
                    return 0;
                }
                return prefLabelsA.get(0).getStatement().getString().compareTo(prefLabelsB.get(0).getStatement().getString());
            }
            return cmp;
        });
        for (Assertion typeAssertion : typeAssertions) {
            List<Assertion> prefLabels;
            if (typeAssertion.getSubject().equals(ConceptDiscovery.DEFAULT_TYPE) || typeAssertion.getSubject().equals(OntologyPopulation.CONCEPT_TYPE) || (prefLabels = this.manager.getAssertionPool().getAssertions(typeAssertion.getSubject(), SKOS.prefLabel, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0)).isEmpty()) continue;
            JSONObject typeObj = new JSONObject();
            typeObj.put("assertion", Assertion.toJson(typeAssertion));
            typeObj.put("prefLabelAssertion", Assertion.toJson(prefLabels.get(0)));
            typeArray.put(typeObj);
        }
        resp.type("application/json");
        return result.toString(2);
    }

    private Object getProperties(Request req, Response resp) {
        this.saveRequest(req);
        JSONObject result = new JSONObject();
        JSONArray propArray = new JSONArray();
        result.put("properties", propArray);
        List<Assertion> propAssertions = this.manager.getAssertionPool().getAssertions(null, RDF.type, RDF.Property, Phase.OntologyPopulation, null, null, null, 0.0);
        propAssertions.sort((a, b) -> {
            int cmp = a.getRating().compareTo(b.getRating());
            if (cmp == 0) {
                List<Assertion> prefLabelsA = this.manager.getAssertionPool().getAssertions(a.getSubject(), SKOS.prefLabel, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
                List<Assertion> prefLabelsB = this.manager.getAssertionPool().getAssertions(b.getSubject(), SKOS.prefLabel, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
                if (prefLabelsA.isEmpty() || prefLabelsB.isEmpty()) {
                    return 0;
                }
                return prefLabelsA.get(0).getStatement().getString().compareTo(prefLabelsB.get(0).getStatement().getString());
            }
            return cmp;
        });
        for (Assertion propAssertion : propAssertions) {
            List<Assertion> prefLabels = this.manager.getAssertionPool().getAssertions(propAssertion.getSubject(), SKOS.prefLabel, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
            List<Assertion> domains = this.manager.getAssertionPool().getAssertions(propAssertion.getSubject(), RDFS.domain, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
            List<Assertion> ranges = this.manager.getAssertionPool().getAssertions(propAssertion.getSubject(), RDFS.range, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
            JSONObject typeObj = new JSONObject();
            typeObj.put("assertion", Assertion.toJson(propAssertion));
            typeObj.put("prefLabelAssertion", Assertion.toJson(prefLabels.get(0)));
            if (!domains.isEmpty()) {
                typeObj.put("domainAssertion", Assertion.toJson(domains.get(0)));
            }
            if (!ranges.isEmpty()) {
                typeObj.put("rangeAssertion", Assertion.toJson(ranges.get(0)));
            }
            propArray.put(typeObj);
        }
        resp.type("application/json");
        return result.toString(2);
    }

    public Object getPositiveTypes(Request req, Response resp) {
        this.saveRequest(req);
        JSONObject result = new JSONObject();
        JSONArray typeArray = new JSONArray();
        result.put("types", typeArray);
        List<Assertion> typeAssertions = this.manager.getAssertionPool().getAssertions(null, RDF.type, RDFS.Class, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
        for (Assertion typeAssertion : typeAssertions) {
            List<Assertion> prefLabels = this.manager.getAssertionPool().getAssertions(typeAssertion.getSubject(), SKOS.prefLabel, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
            if (prefLabels.isEmpty()) continue;
            JSONObject typeObj = new JSONObject();
            typeObj.put("uri", typeAssertion.getSubject().getURI());
            typeObj.put("prefLabel", prefLabels.get(0).getStatement().getString());
            typeArray.put(typeObj);
        }
        List<JSONObject> l = JsonUtility.getList(typeArray, JSONObject.class);
        l.sort((a, b) -> a.getString("prefLabel").compareToIgnoreCase(b.getString("prefLabel")));
        resp.type("application/json");
        return result.toString(2);
    }

    public Object getPositiveProperties(Request req, Response resp) {
        this.saveRequest(req);
        JSONObject result = new JSONObject();
        JSONArray propArray = new JSONArray();
        result.put("properties", propArray);
        List<Assertion> propAssertions = this.manager.getAssertionPool().getAssertions(null, RDF.type, RDF.Property, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
        for (Assertion propAssertion : propAssertions) {
            List<Assertion> prefLabels = this.manager.getAssertionPool().getAssertions(propAssertion.getSubject(), SKOS.prefLabel, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
            if (prefLabels.isEmpty()) continue;
            JSONObject typeObj = new JSONObject();
            typeObj.put("uri", propAssertion.getSubject().getURI());
            typeObj.put("prefLabel", prefLabels.get(0).getStatement().getString());
            propArray.put(typeObj);
        }
        List<JSONObject> l = JsonUtility.getList(propArray, JSONObject.class);
        l.sort((a, b) -> a.getString("prefLabel").compareToIgnoreCase(b.getString("prefLabel")));
        resp.type("application/json");
        return result.toString(2);
    }

    public Object getSuggestions(Request req, Response resp) {
        this.saveRequest(req);
        JSONObject reqJson = new JSONObject(req.body());
        String typeArg = reqJson.getString("type");
        HashMap<String, Phase> type2phase = new HashMap<String, Phase>();
        type2phase.put("merge", Phase.ConceptDiscovery);
        type2phase.put("typing", Phase.OntologyPopulation);
        type2phase.put("taxonomy", Phase.ConceptHierarchyDerivation);
        type2phase.put("relations", Phase.NonTaxonomicRelationLearning);
        int offsetP = reqJson.optInt("offsetP", 0);
        int offsetN = reqJson.optInt("offsetN", 0);
        Phase phase = (Phase)((Object)type2phase.get(typeArg));
        if (phase == null) {
            return null;
        }
        HashMap<Resource, String> prefLabelMap = new HashMap<Resource, String>();
        prefLabelMap.putAll(this.manager.getAssertionPool().getTypePrefLabelMap());
        prefLabelMap.putAll(this.manager.getAssertionPool().getPropertyPrefLabelMap());
        prefLabelMap.putAll(this.manager.getAssertionPool().getConceptPrefLabelMap(ConceptDiscovery.DEFAULT_TYPE, null));
        JSONObject result = new JSONObject();
        AssertionPool pool = this.manager.getAssertionPool();
        Property prop = null;
        switch (phase) {
            case ConceptDiscovery: {
                prop = OWL.sameAs;
                break;
            }
            case OntologyPopulation: {
                prop = RDF.type;
                break;
            }
            case ConceptHierarchyDerivation: {
                prop = SKOS.broader;
                break;
            }
            case NonTaxonomicRelationLearning: {
                prop = null;
            }
        }
        List<Assertion> suggested = pool.getAssertions(null, prop, null, phase, Intelligence.AI, null, null, 0.0);
        List<Assertion> accepted = pool.getAssertions(null, prop, null, phase, Intelligence.NI, null, Rating.Positive, 0.0);
        List<Assertion> declined = pool.getAssertions(null, prop, null, phase, Intelligence.NI, null, Rating.Negative, 0.0);
        suggested.removeIf(sug -> sug.getRating() == Rating.Negative);
        if (phase == Phase.OntologyPopulation) {
            for (List list : Arrays.asList(suggested, accepted, declined)) {
                list.removeIf(sug -> sug.getObject().equals(RDFS.Class) || sug.getObject().equals(RDF.Property));
            }
            suggested.removeIf(sug -> pool.getAssertions(sug.getSubject(), RDF.type, ConceptDiscovery.DEFAULT_TYPE, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0).isEmpty());
        }
        BiConsumer<Assertion, JSONObject> extra = (assertion, json) -> {
            JSONObject prefLabels = new JSONObject();
            prefLabels.put("subject", prefLabelMap.get(assertion.getSubject()));
            prefLabels.put("predicate", prefLabelMap.get(assertion.getStatement().getPredicate()));
            prefLabels.put("object", prefLabelMap.get(assertion.getObject()));
            json.put("prefLabels", prefLabels);
            JSONObject uris = new JSONObject();
            uris.put("subject", assertion.getSubject().getURI());
            uris.put("predicate", assertion.getStatement().getPredicate().getURI());
            uris.put("object", assertion.getObject().getURI());
            json.put("uris", uris);
        };
        JSONObject acceptedPagination = new JSONObject();
        result.put("acceptedPagination", acceptedPagination);
        accepted.sort((a, b) -> b.getWhen().compareTo(a.getWhen()));
        List<Assertion> acceptedSublist = this.calculateList(offsetP, 5, accepted, acceptedPagination);
        result.put("accepted", Assertion.toJsonArray(acceptedSublist, extra));
        JSONObject declinedPagination = new JSONObject();
        result.put("declinedPagination", declinedPagination);
        declined.sort((a, b) -> b.getWhen().compareTo(a.getWhen()));
        List<Assertion> declinedSublist = this.calculateList(offsetN, 5, declined, declinedPagination);
        result.put("declined", Assertion.toJsonArray(declinedSublist, extra));
        result.put("suggested", Assertion.toJsonArrayOrderByConfidence(suggested, extra));
        resp.type("application/json");
        return result.toString(2);
    }

    public Object getStatus(Request req, Response resp) {
        this.saveRequest(req);
        UserPrincipal userP = this.authController.getUserPrincipal(req);
        JSONObject result = new JSONObject();
        result.put("username", userP.getUserName());
        StatusManager status = this.manager.getStatusManager();
        status.calculateAll(true);
        status.fillJSON(result);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        result.put("time", formatter.format(LocalDateTime.now()));
        resp.type("application/json");
        return result.toString(2);
    }

    public Object download(Request req, Response resp) {
        String name = req.params("name");
        if (name.endsWith("ttl")) {
            Model model;
            StatusManager status = this.manager.getStatusManager();
            switch (name) {
                case "terminology.ttl": {
                    model = status.getTerminologyModel();
                    break;
                }
                case "assertions.ttl": {
                    model = status.getAssertionModel();
                    break;
                }
                case "topic-statements.ttl": {
                    model = status.getTopicModel();
                    break;
                }
                default: {
                    model = ModelFactory.createDefaultModel();
                }
            }
            StringWriter sw = new StringWriter();
            model.write(sw, "TTL");
            resp.type("text/turtle; charset=utf-8");
            return sw.toString();
        }
        return null;
    }

    public Object visual(Request req, Response resp) {
        String content;
        String name = req.params("name");
        VisualManager visualManager = this.manager.getVisualManager();
        switch (name) {
            case "graph": {
                content = visualManager.getNonTaxGraph();
                break;
            }
            case "taxonomy": {
                content = visualManager.getTaxonomy();
                break;
            }
            default: {
                content = "";
            }
        }
        resp.type("text/html; charset=utf-8");
        return content;
    }

    private Object addType(Request req, Response resp) {
        this.saveRequest(req);
        UserPrincipal userP = this.authController.getUserPrincipal(req);
        JSONObject reqJson = new JSONObject(req.body());
        String typeName = reqJson.getString("typeName").trim();
        HashSet<String> labelSet = new HashSet<String>(this.manager.getAssertionPool().getTypePrefLabelMap().values());
        if (labelSet.contains(typeName)) {
            return this.getTypes(req, resp);
        }
        Resource type = this.manager.getAssertionPool().createType();
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        Assertion typeAssertion = new Assertion();
        typeAssertion.setStatement(KecsApp.creator.createStatement(type, RDF.type, RDFS.Class));
        typeAssertion.setPhase(Phase.OntologyPopulation);
        typeAssertion.setOpinion(Intelligence.NI, userP.getUserName(), LocalDateTime.now(), Rating.Positive, 1.0);
        assertions.add(typeAssertion);
        Assertion prefLabelAssertion = new Assertion();
        prefLabelAssertion.setStatement(KecsApp.creator.createStatement(type, SKOS.prefLabel, typeName));
        prefLabelAssertion.setPhase(Phase.OntologyPopulation);
        prefLabelAssertion.setOpinion(Intelligence.NI, userP.getUserName(), LocalDateTime.now(), Rating.Positive, 1.0);
        assertions.add(prefLabelAssertion);
        this.sendAssertion(assertions, userP.getUserName());
        return this.getTypes(req, resp);
    }

    private Object addProperty(Request req, Response resp) {
        this.saveRequest(req);
        UserPrincipal userP = this.authController.getUserPrincipal(req);
        JSONObject reqJson = new JSONObject(req.body());
        String propName = reqJson.getString("propertyName").trim();
        HashSet<String> labelSet = new HashSet<String>(this.manager.getAssertionPool().getPropertyPrefLabelMap().values());
        if (labelSet.contains(propName)) {
            return this.getTypes(req, resp);
        }
        Resource prop = this.manager.getAssertionPool().createProperty();
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        Assertion typeAssertion = new Assertion();
        typeAssertion.setStatement(KecsApp.creator.createStatement(prop, RDF.type, RDF.Property));
        typeAssertion.setPhase(Phase.OntologyPopulation);
        typeAssertion.setOpinion(Intelligence.NI, userP.getUserName(), LocalDateTime.now(), Rating.Positive, 1.0);
        assertions.add(typeAssertion);
        Assertion prefLabelAssertion = new Assertion();
        prefLabelAssertion.setStatement(KecsApp.creator.createStatement(prop, SKOS.prefLabel, propName));
        prefLabelAssertion.setPhase(Phase.OntologyPopulation);
        prefLabelAssertion.setOpinion(Intelligence.NI, userP.getUserName(), LocalDateTime.now(), Rating.Positive, 1.0);
        assertions.add(prefLabelAssertion);
        Assertion domainAssertion = new Assertion();
        domainAssertion.setStatement(KecsApp.creator.createStatement(prop, RDFS.domain, ConceptDiscovery.DEFAULT_TYPE));
        domainAssertion.setPhase(Phase.OntologyPopulation);
        domainAssertion.setOpinion(Intelligence.NI, userP.getUserName(), LocalDateTime.now(), Rating.Positive, 1.0);
        assertions.add(domainAssertion);
        Assertion rangeAssertion = new Assertion();
        rangeAssertion.setStatement(KecsApp.creator.createStatement(prop, RDFS.range, ConceptDiscovery.DEFAULT_TYPE));
        rangeAssertion.setPhase(Phase.OntologyPopulation);
        rangeAssertion.setOpinion(Intelligence.NI, userP.getUserName(), LocalDateTime.now(), Rating.Positive, 1.0);
        assertions.add(rangeAssertion);
        this.sendAssertion(assertions, userP.getUserName());
        return this.getProperties(req, resp);
    }

    private Object assertType(Request req, Response resp) {
        this.saveRequest(req);
        UserPrincipal userP = this.authController.getUserPrincipal(req);
        JSONObject reqJson = new JSONObject(req.body());
        String conceptUri = reqJson.getString("conceptUri");
        String typeUri = reqJson.getString("typeUri");
        String ratingArg = reqJson.optString("rating");
        Rating rating = Rating.Positive;
        if (!ratingArg.isEmpty()) {
            rating = Rating.valueOf(ratingArg);
        }
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        Resource concept = KecsApp.creator.createResource(conceptUri);
        Resource type = KecsApp.creator.createResource(typeUri);
        KecsHumlServer.addTypeAssertion(concept, type, rating, userP.getUserName(), assertions, this.manager.getAssertionPool());
        this.sendAssertion(assertions, userP.getUserName());
        resp.status(200);
        return "";
    }

    private Object assertMerge(Request req, Response resp) {
        this.saveRequest(req);
        UserPrincipal userP = this.authController.getUserPrincipal(req);
        JSONObject reqJson = new JSONObject(req.body());
        String conceptUriLeft = reqJson.getString("conceptUriLeft");
        String conceptUriRight = reqJson.getString("conceptUriRight");
        String ratingArg = reqJson.optString("rating");
        Rating rating = Rating.Positive;
        if (!ratingArg.isEmpty()) {
            rating = Rating.valueOf(ratingArg);
        }
        Resource left = KecsApp.creator.createResource(conceptUriLeft);
        Resource right = KecsApp.creator.createResource(conceptUriRight);
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        this.addMergeAssertion(left, right, rating, userP.getUserName(), assertions);
        this.sendAssertion(assertions, userP.getUserName());
        resp.status(200);
        return "";
    }

    private Object assertNegativeTermsRecursively(Request req, Response resp) {
        List<Object> list;
        this.saveRequest(req);
        UserPrincipal userP = this.authController.getUserPrincipal(req);
        JSONObject reqJson = new JSONObject(req.body());
        String fileUri = reqJson.getString("fileUri");
        int id = KecsUtils.getId(fileUri);
        FileInfo parentFile = (FileInfo)this.manager.getFileInfoStorage().get(id);
        if (parentFile.isDirectory()) {
            FolderInfo parent = (FolderInfo)parentFile;
            list = this.manager.getFileInfoStorage().getTree(parent);
        } else {
            list = new ArrayList<FileInfo>();
            list.add(parentFile);
        }
        for (StorageItem storageItem : list) {
            FileInfo fi = (FileInfo)storageItem;
            Resource fileResource = KecsApp.creator.createResource(new JSONObject(fi.getMeta()).getString("uri"));
            List<Assertion> posAssertions = this.manager.getAssertionPool().getAssertions(fileResource, KECS.containsDomainTerm, null, Phase.DomainTerminologyExtraction, null, null, Rating.Positive, 0.0);
            for (Assertion assertion : posAssertions) {
                this.manager.getAssertionPool().assertStatement(assertion.getStatement(), Phase.DomainTerminologyExtraction, Intelligence.NI, userP.getUserName(), Rating.Negative, 1.0);
            }
        }
        this.manager.getAssertionPool().commit();
        JSONObject result = this.browseChild(fileUri);
        resp.type("application/json");
        return result.toString(2);
    }

    private Object assertNewConcept(Request req, Response resp) {
        this.saveRequest(req);
        UserPrincipal userP = this.authController.getUserPrincipal(req);
        String username = userP.getUserName();
        JSONObject reqJson = new JSONObject(req.body());
        String prefLabel = reqJson.getString("prefLabel");
        String typeUri = reqJson.getString("type");
        Resource type = KecsApp.creator.createResource(typeUri);
        AssertionPool pool = this.manager.getAssertionPool();
        Resource newConcept = pool.createConcept();
        pool.assertStatement(newConcept, RDF.type, ConceptDiscovery.DEFAULT_TYPE, Phase.ConceptDiscovery, Intelligence.NI, username, Rating.Positive, 1.0);
        pool.assertStatement(newConcept, SKOS.prefLabel, prefLabel, Phase.ConceptDiscovery, Intelligence.NI, username, Rating.Positive, 1.0);
        pool.assertStatement(newConcept, SKOS.hiddenLabel, prefLabel, Phase.ConceptDiscovery, Intelligence.NI, username, Rating.Positive, 1.0);
        pool.assertStatement(newConcept, RDF.type, type, Phase.OntologyPopulation, Intelligence.NI, username, Rating.Positive, 1.0);
        pool.commit();
        pool.notifyListenersRecursively(this.manager.getFileInfoStorage());
        JSONObject conceptObj = this.browseConcept(newConcept, 0, 10, 0, 10);
        resp.type("application/json");
        return conceptObj.toString(2);
    }

    public static void addTypeAssertion(Resource concept, Resource type, Rating rating, String username, List<Assertion> assertions, AssertionPool pool) {
        Statement positiveStmt = KecsApp.creator.createStatement(concept, RDF.type, type);
        if (rating == Rating.Positive) {
            for (Assertion typeAssertion : pool.getAssertions(concept, RDF.type, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0)) {
                if (positiveStmt.equals(typeAssertion.getStatement())) continue;
                Assertion changeAssertion = new Assertion();
                changeAssertion.setStatement(typeAssertion.getStatement());
                changeAssertion.setPhase(Phase.OntologyPopulation);
                changeAssertion.setOpinion(Intelligence.NI, username, LocalDateTime.now(), Rating.Negative, 1.0);
                assertions.add(changeAssertion);
            }
        }
        if (!type.equals(ConceptDiscovery.DEFAULT_TYPE)) {
            Assertion changeAssertion = new Assertion();
            changeAssertion.setStatement(positiveStmt);
            changeAssertion.setPhase(Phase.OntologyPopulation);
            changeAssertion.setOpinion(Intelligence.NI, username, LocalDateTime.now(), rating, 1.0);
            assertions.add(changeAssertion);
        }
    }

    private void addMergeAssertion(Resource left, Resource right, Rating rating, String username, List<Assertion> assertions) {
        if (rating == Rating.Positive) {
            Statement subst;
            Statement stmt;
            AssertionPool pool = this.manager.getAssertionPool();
            List<Assertion> outgoing = pool.getAssertions(right, null, null, null, null, null, null, 0.0);
            List<Assertion> incoming = pool.getAssertions(null, null, right, null, null, null, null, 0.0);
            for (Assertion out : outgoing) {
                stmt = out.getStatement();
                if (stmt.getPredicate().equals(SKOS.prefLabel) || stmt.getPredicate().equals(RDF.type) || out.getStatement().getPredicate().equals(OWL.sameAs) && left.equals(stmt.getObject())) continue;
                subst = KecsApp.creator.createStatement(left, stmt.getPredicate(), stmt.getObject());
                out.setStatement(subst);
                assertions.add(out);
            }
            for (Assertion in : incoming) {
                if (in.getStatement().getPredicate().equals(OWL.sameAs)) continue;
                stmt = in.getStatement();
                subst = KecsApp.creator.createStatement(stmt.getSubject(), stmt.getPredicate(), left);
                in.setStatement(subst);
                assertions.add(in);
            }
            pool.removeAllAbout(right);
        } else if (rating == Rating.Negative) {
            ArrayList<Statement> stmts = new ArrayList<Statement>();
            stmts.add(KecsApp.creator.createStatement(left, OWL.sameAs, right));
            stmts.add(KecsApp.creator.createStatement(right, OWL.sameAs, left));
            for (Statement negStatement : stmts) {
                Assertion changeAssertion = new Assertion();
                changeAssertion.setStatement(negStatement);
                changeAssertion.setPhase(Phase.ConceptDiscovery);
                changeAssertion.setOpinion(Intelligence.NI, username, LocalDateTime.now(), rating, 1.0);
                assertions.add(changeAssertion);
            }
        }
    }

    private Object explorerSearchCreate(Request req, Response resp) {
        this.saveRequest(req);
        UserPrincipal userP = this.authController.getUserPrincipal(req);
        JSONObject result = new JSONObject(req.body());
        String typeUri = result.getString("typeUri");
        Resource type = typeUri.isEmpty() ? null : KecsApp.creator.createResource(typeUri);
        DomainTerminologyExtraction dte = this.manager.getDomainTerminologyExtraction();
        ArrayList<Object[]> fileTermList = new ArrayList<Object[]>();
        JSONArray matches = result.getJSONArray("matches");
        for (int i = 0; i < matches.length(); ++i) {
            JSONObject match = matches.getJSONObject(i);
            if (!match.getBoolean("selected")) continue;
            fileTermList.add(new Object[]{KecsApp.creator.createResource(match.getString("uri")), match.getString("middle")});
        }
        dte.createFromSearch(fileTermList, type, this.manager.getAssertionPool(), userP.getUserName(), result.getBoolean("regex"));
        resp.type("application/json");
        return "{}";
    }

    private Object assertTypes(Request req, Response resp) {
        this.saveRequest(req);
        UserPrincipal userP = this.authController.getUserPrincipal(req);
        JSONObject reqJson = new JSONObject(req.body());
        JSONArray suggested = reqJson.getJSONArray("suggested");
        Rating rating = reqJson.getEnum(Rating.class, "rating");
        HashSet<Resource> visited = new HashSet<Resource>();
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        for (int i = 0; i < suggested.length(); ++i) {
            JSONObject entry = suggested.getJSONObject(i);
            Resource concept = KecsApp.creator.createResource(entry.getJSONObject("uris").getString("subject"));
            Resource type = KecsApp.creator.createResource(entry.getJSONObject("uris").getString("object"));
            if (rating == Rating.Positive && visited.contains(concept)) continue;
            visited.add(concept);
            KecsHumlServer.addTypeAssertion(concept, type, rating, userP.getUserName(), assertions, this.manager.getAssertionPool());
        }
        this.sendAssertion(assertions, userP.getUserName());
        resp.status(200);
        return "";
    }

    private Object assertMerges(Request req, Response resp) {
        this.saveRequest(req);
        UserPrincipal userP = this.authController.getUserPrincipal(req);
        JSONObject reqJson = new JSONObject(req.body());
        JSONArray suggested = reqJson.getJSONArray("suggested");
        Rating rating = reqJson.getEnum(Rating.class, "rating");
        HashSet<Resource> visited = new HashSet<Resource>();
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        for (int i = 0; i < suggested.length(); ++i) {
            JSONObject entry = suggested.getJSONObject(i);
            Resource left = KecsApp.creator.createResource(entry.getJSONObject("uris").getString("subject"));
            Resource right = KecsApp.creator.createResource(entry.getJSONObject("uris").getString("object"));
            if (rating == Rating.Positive && visited.contains(right)) continue;
            visited.add(right);
            this.addMergeAssertion(left, right, rating, userP.getUserName(), assertions);
        }
        this.sendAssertion(assertions, userP.getUserName());
        resp.status(200);
        return "";
    }

    private Object sendAssertion(Request req, Response resp) {
        this.saveRequest(req);
        UserPrincipal userP = this.authController.getUserPrincipal(req);
        boolean isArray = req.body().trim().startsWith("[");
        boolean isObject = req.body().trim().startsWith("{");
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        if (isObject) {
            JSONObject json = new JSONObject(req.body());
            assertions.add(Assertion.fromJson(json));
        } else if (isArray) {
            JSONArray array = new JSONArray(req.body());
            for (int i = 0; i < array.length(); ++i) {
                assertions.add(Assertion.fromJson(array.getJSONObject(i)));
            }
        }
        this.sendAssertion(assertions, userP.getUserName());
        resp.status(200);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAssertion(List<Assertion> assertions, String username) {
        KecsManager kecsManager = this.manager;
        synchronized (kecsManager) {
            long begin = System.currentTimeMillis();
            assertions.forEach(a -> {
                if (a.hasNaturalOpinion()) {
                    a.getNaturalOpinion().setName(username);
                }
            });
            JSONObject historyEntry = new JSONObject();
            historyEntry.put("when", LocalDateTime.now().toString());
            historyEntry.put("list", Assertion.toJsonArrayOrderByRating(assertions));
            KecsUtils.saveHistoryEntry(historyEntry, this.resultFolder);
            for (Assertion assertion : assertions) {
                this.manager.getAssertionPool().assertAssertion(assertion);
            }
            this.manager.getAssertionPool().commit();
            this.manager.getAssertionPool().notifyListenersRecursively(this.manager.getFileInfoStorage());
            long l = System.currentTimeMillis();
        }
    }

    private Object sendEvent(Request req, Response resp) {
        UserPrincipal userP = this.authController.getUserPrincipal(req);
        if (userP.getUserName().equals("readonly")) {
            return "";
        }
        this.saveRequest(req);
        ++this.eventCounter;
        if (this.eventCounter == 0 || this.eventCounter >= this.manager.getSettings().getSaveStatusThreshold()) {
            StatusManager status = this.manager.getStatusManager();
            Thread thread = new Thread(() -> status.calculateAll(true));
            thread.start();
            this.eventCounter = 0;
        }
        return "";
    }

    protected <T> List<T> calculateList(Integer offsetParam, Integer limitParam, List<T> resources, JSONObject result) {
        int startPage;
        int limit;
        int offset;
        int total = resources.size();
        int n = offset = offsetParam == null ? 0 : offsetParam;
        if (offset < 0) {
            offset = 0;
        }
        if (offset >= total) {
            offset = 0;
        }
        int n2 = limit = limitParam == null ? 10 : limitParam;
        int pages = limit == 0 ? 0 : (int)((float)total / (float)limit) + (total % limit == 0 ? 0 : 1);
        int page = (limit == 0 ? 0 : offset / limit) + 1;
        List<T> sublist = resources.subList(offset, Math.min(offset + limit, resources.size()));
        int shown = sublist.size();
        result.put("total", total);
        result.put("shown", shown);
        result.put("offset", offset);
        result.put("limit", limit);
        result.put("page", page);
        int rightRestPages = 5 - Math.min(5, pages - page);
        JSONArray pageArray = new JSONArray();
        for (int i = startPage = Math.max(1, page - 5 - rightRestPages); i <= Math.min(pages, startPage + 10); ++i) {
            JSONObject obj = new JSONObject();
            obj.put("active", i == page);
            obj.put("number", i);
            obj.put("offset", (i - 1) * limit);
            pageArray.put(obj);
        }
        result.put("pages", pageArray);
        return sublist;
    }

    private JSONObject toJson(FileInfo fi) {
        if (fi == null) {
            return null;
        }
        JSONObject meta = new JSONObject(fi.getMeta());
        JSONObject obj = new JSONObject();
        obj.put("uri", meta.getString("uri"));
        obj.put("prefLabel", fi.getName());
        obj.put("isFile", !fi.isDirectory());
        obj.put("path", fi.getPath());
        return obj;
    }

    private void conceptToJson(String prefLabel, Assertion conceptAssertion, TypeWithIntel typeWithIntel, Map<Resource, String> typeMap, JSONObject resultEntry) {
        resultEntry.put("prefLabel", prefLabel);
        resultEntry.put("uri", conceptAssertion.getSubject());
        resultEntry.put("assertion", Assertion.toJson(conceptAssertion));
        if (typeWithIntel != null) {
            JSONObject typeObj = new JSONObject();
            typeObj.put("prefLabel", typeMap.get(typeWithIntel.getType()));
            typeObj.put("uri", typeWithIntel.getType().getURI());
            typeObj.put("intelligence", typeWithIntel.getIntel().name());
            resultEntry.put("type", typeObj);
        }
    }

    private void saveRequest(Request req) {
        JSONObject interaction = new JSONObject();
        interaction.put("when", LocalDateTime.now().toString());
        interaction.put("uri", req.uri());
        try {
            UserPrincipal userP = this.authController.getUserPrincipal(req);
            interaction.put("username", userP.getUserName());
        }
        catch (Exception userP) {
            // empty catch block
        }
        try {
            JSONObject body = new JSONObject(req.body());
            interaction.put("body", body);
        }
        catch (Exception e1) {
            try {
                JSONArray array = new JSONArray(req.body());
                JSONObject body = new JSONObject();
                body.put("array", array);
                interaction.put("body", body);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        KecsUtils.saveInteraction(interaction, this.resultFolder);
    }
}

