/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs.modules;

import de.dfki.sds.hephaistos.storage.assertion.Assertion;
import de.dfki.sds.hephaistos.storage.assertion.AssertionPool;
import de.dfki.sds.hephaistos.storage.assertion.Intelligence;
import de.dfki.sds.hephaistos.storage.assertion.Phase;
import de.dfki.sds.hephaistos.storage.assertion.Rating;
import de.dfki.sds.hephaistos.storage.file.FileInfoStorage;
import de.dfki.sds.kecs.KecsApp;
import de.dfki.sds.kecs.KecsSettings;
import de.dfki.sds.kecs.ml.PredictionManager;
import de.dfki.sds.kecs.modules.ConceptDiscovery;
import de.dfki.sds.kecs.modules.Module;
import de.dfki.sds.kecs.util.ExceptionUtility;
import de.dfki.sds.kecs.util.Prediction;
import de.dfki.sds.stringanalyzer.string.StringEntity;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.SKOS;
import org.json.JSONArray;
import org.json.JSONObject;
import weka.core.Attribute;

public class OntologyPopulation
extends Module {
    private static final Phase aiPhase = Phase.OntologyPopulation;
    private static final String aiName = "OntologyPopulation";
    public static final Resource CONCEPT_TYPE = SKOS.Concept;
    private PredictionManager predictionManager;

    private void initPredictionManager() {
        if (!this.embeddingIsLoaded()) {
            return;
        }
        this.predictionManager = new PredictionManager();
        this.predictionManager.randomForest();
        this.predictionManager.setPrintClassifier(false);
        this.predictionManager.setPrintEvaluation(false);
        this.predictionManager.setSchemaDefinition(attrs -> this.embedding.getFeatures().forEach(f -> attrs.add(new Attribute((String)f))));
        this.predictionManager.setFeatureDefinition(ctx -> {
            Resource cpt = ctx.getAssertion().getSubject();
            List<Assertion> prefLabels = ctx.getAssertionPool().getAssertions(cpt, SKOS.prefLabel, null, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0);
            String prefLabel = prefLabels.get(0).getStatement().getString();
            StringEntity se = new StringEntity(cpt.getURI(), prefLabel);
            this.embedding.add(se);
            double[] vector = this.embedding.getVector(se);
            for (int i = 0; i < vector.length; ++i) {
                ctx.getInstance().setValue(i, vector[i]);
            }
        });
        this.predictionManager.setClassProvider(assertion -> assertion.getObject().getURI());
        this.predictionManager.setTrainSetProvider(ctx -> {
            List<Assertion> typeAssertions = ctx.getAssertionPool().getAssertions(null, RDF.type, null, Phase.OntologyPopulation, Intelligence.NI, null, Rating.Positive, 0.0);
            typeAssertions.removeIf(a -> a.getObject().equals(RDFS.Class) || a.getObject().equals(RDF.Property));
            ctx.getAssertionSet().addAll(typeAssertions);
        });
        this.predictionManager.setTestSetProvider(ctx -> {
            List<Assertion> conceptAssertions = ctx.getAssertionPool().getAssertions(null, RDF.type, ConceptDiscovery.DEFAULT_TYPE, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0);
            conceptAssertions.removeIf(cptAs -> {
                List<Assertion> typeAssertions = ctx.getAssertionPool().getAssertions(cptAs.getSubject(), RDF.type, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
                return typeAssertions.stream().anyMatch(a -> a.getIntelligence() == Intelligence.NI);
            });
            ctx.getAssertionSet().addAll(conceptAssertions);
        });
        this.predictionManager.setPredictionsConsumer(ctx -> {
            String aiPredName = "OntologyPopulationPrediction";
            List<Assertion> assertions = ctx.getAssertionPool().getAssertions(null, null, null, aiPhase, Intelligence.AI, aiPredName, Rating.Positive, 0.0);
            for (Assertion assertion : assertions) {
                ctx.getAssertionPool().assertStatement(assertion.getStatement(), aiPhase, Intelligence.AI, aiPredName, Rating.Negative, 1.0);
            }
            HashSet<Resource> visited = new HashSet<Resource>();
            for (Prediction prediction : ctx.getPredictions()) {
                Resource cpt = prediction.getAssertion().getSubject();
                Resource type = KecsApp.creator.createResource(prediction.getClassLabel());
                List<Assertion> niFeedback = ctx.getAssertionPool().getAssertions(cpt, RDF.type, type, aiPhase, Intelligence.NI, null, Rating.Negative, 0.0);
                if (visited.contains(cpt) || !niFeedback.isEmpty()) continue;
                ctx.getAssertionPool().assertStatement(cpt, RDF.type, type, aiPhase, Intelligence.AI, aiPredName, Rating.Positive, prediction.getConfidence());
                visited.add(cpt);
            }
        });
    }

    @Override
    public void init(FileInfoStorage fileInfoStorage, AssertionPool pool, KecsSettings settings) {
        this.settings = settings;
        this.initPredictionManager();
    }

    @Override
    public void bootstrap(FileInfoStorage fileInfoStorage, AssertionPool pool, KecsSettings settings) {
        pool.assertStatement(CONCEPT_TYPE, RDF.type, RDFS.Class, aiPhase, Intelligence.AI, aiName, Rating.Positive, 1.0);
        pool.assertStatement(CONCEPT_TYPE, SKOS.prefLabel, OntologyPopulation.getTopicName(settings), aiPhase, Intelligence.AI, aiName, Rating.Positive, 1.0);
        pool.assertStatement(ConceptDiscovery.DEFAULT_TYPE, RDF.type, RDFS.Class, aiPhase, Intelligence.AI, aiName, Rating.Positive, 1.0);
        pool.assertStatement(ConceptDiscovery.DEFAULT_TYPE, SKOS.prefLabel, ConceptDiscovery.getIndividualName(settings), aiPhase, Intelligence.AI, aiName, Rating.Positive, 1.0);
        if (settings.getOntologyFile().exists()) {
            JSONObject ontology;
            try {
                ontology = new JSONObject(FileUtils.readFileToString(settings.getOntologyFile(), StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                ExceptionUtility.save(ex);
                throw new RuntimeException(ex);
            }
            OntologyPopulation.loadOntology(ontology, pool, settings);
        } else if (settings.isLoadDefaultOntology()) {
            JSONObject ontology;
            try {
                ontology = new JSONObject(IOUtils.toString(OntologyPopulation.class.getResourceAsStream("/de/dfki/sds/kecs/auxiliary/ontology_" + settings.getLanguage().name() + ".json"), StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                ExceptionUtility.save(ex);
                throw new RuntimeException(ex);
            }
            OntologyPopulation.loadOntology(ontology, pool, settings);
        }
        pool.commit();
    }

    public static void loadOntology(JSONObject ontology, AssertionPool pool, KecsSettings settings) {
        JSONArray classes = ontology.getJSONArray("classes");
        List typeNames = classes.toList().stream().map(o -> (String)o).collect(Collectors.toList());
        typeNames.sort((a, b) -> a.compareTo((String)b));
        HashMap<String, Resource> typeName2Resource = new HashMap<String, Resource>();
        typeName2Resource.put(OntologyPopulation.getTopicName(settings), CONCEPT_TYPE);
        typeName2Resource.put(ConceptDiscovery.getIndividualName(settings), ConceptDiscovery.DEFAULT_TYPE);
        Map<Resource, String> typePrefLabelMap = pool.getTypePrefLabelMap();
        for (Map.Entry<Resource, String> entry : typePrefLabelMap.entrySet()) {
            typeName2Resource.put(entry.getValue(), entry.getKey());
        }
        HashSet<String> typeNameSet = new HashSet<String>(typePrefLabelMap.values());
        HashSet<String> propertyNameSet = new HashSet<String>(pool.getPropertyPrefLabelMap().values());
        for (String typeName : typeNames) {
            if (typeNameSet.contains(typeName)) continue;
            Resource type = pool.createType();
            pool.assertStatement(type, RDF.type, RDFS.Class, aiPhase, Intelligence.AI, aiName, Rating.Positive, 1.0);
            pool.assertStatement(type, SKOS.prefLabel, typeName, aiPhase, Intelligence.AI, aiName, Rating.Positive, 1.0);
            typeName2Resource.put(typeName, type);
            typeNameSet.add(typeName);
        }
        JSONArray properties = ontology.getJSONArray("properties");
        for (int i = 0; i < properties.length(); ++i) {
            JSONArray entry = properties.getJSONArray(i);
            if (propertyNameSet.contains(entry.getString(1))) continue;
            OntologyPopulation.addProperty(entry.getString(0), entry.getString(1), entry.getString(2), typeName2Resource, pool);
            propertyNameSet.add(entry.getString(1));
        }
    }

    private static String getTopicName(KecsSettings settings) {
        if (settings.getLanguage() == KecsSettings.Language.de) {
            return "Thema";
        }
        if (settings.getLanguage() == KecsSettings.Language.semweb) {
            return "skos:Concept";
        }
        return "Topic";
    }

    @Override
    public void updateOnChanges(FileInfoStorage fileInfoStorage, AssertionPool pool, List<Assertion> changes) {
        this.timeStat(aiName, () -> {
            if (this.embeddingIsLoaded()) {
                this.suggestType(fileInfoStorage, pool, changes);
            }
        });
        this.saveTimeStat();
    }

    private void suggestType(FileInfoStorage fileInfoStorage, AssertionPool pool, List<Assertion> changes) {
        boolean changed;
        boolean bl = changed = !AssertionPool.filter(changes, null, RDF.type, ConceptDiscovery.DEFAULT_TYPE, Phase.ConceptDiscovery, null, null, null, 0.0).isEmpty() || !AssertionPool.filter(changes, null, RDF.type, null, Phase.OntologyPopulation, Intelligence.NI, null, null, 0.0).isEmpty() || !AssertionPool.filter(changes, null, SKOS.prefLabel, null, Phase.ConceptDiscovery, null, null, null, 0.0).isEmpty();
        if (changed) {
            this.timeStat("suggestType.predictionManager.trainAndPredict", () -> this.predictionManager.trainAndPredict(fileInfoStorage, pool));
        }
    }

    private static void addProperty(String domainTypeName, String propertyName, String rangeTypeName, Map<String, Resource> typeName2Resource, AssertionPool pool) {
        if (!typeName2Resource.containsKey(domainTypeName) || !typeName2Resource.containsKey(rangeTypeName)) {
            return;
        }
        Resource prop = pool.createProperty();
        pool.assertStatement(prop, RDF.type, RDF.Property, aiPhase, Intelligence.AI, aiName, Rating.Positive, 1.0);
        pool.assertStatement(prop, SKOS.prefLabel, propertyName, aiPhase, Intelligence.AI, aiName, Rating.Positive, 1.0);
        pool.assertStatement(prop, RDFS.domain, typeName2Resource.get(domainTypeName), aiPhase, Intelligence.AI, aiName, Rating.Positive, 1.0);
        pool.assertStatement(prop, RDFS.range, typeName2Resource.get(rangeTypeName), aiPhase, Intelligence.AI, aiName, Rating.Positive, 1.0);
    }
}

