/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs.modules;

import de.dfki.sds.hephaistos.storage.assertion.Assertion;
import de.dfki.sds.hephaistos.storage.assertion.AssertionPool;
import de.dfki.sds.hephaistos.storage.assertion.Intelligence;
import de.dfki.sds.hephaistos.storage.assertion.Phase;
import de.dfki.sds.hephaistos.storage.assertion.Rating;
import de.dfki.sds.hephaistos.storage.file.FileInfoStorage;
import de.dfki.sds.kecs.KecsApp;
import de.dfki.sds.kecs.KecsSettings;
import de.dfki.sds.kecs.ml.Datasets;
import de.dfki.sds.kecs.ml.FileNode;
import de.dfki.sds.kecs.ml.GraphManager;
import de.dfki.sds.kecs.modules.Module;
import de.dfki.sds.kecs.modules.OntologyPopulation;
import de.dfki.sds.kecs.util.Prediction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.LinkPredictionAlgorithm;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultUndirectedWeightedGraph;
import org.jgrapht.graph.DefaultWeightedEdge;

public class NonTaxonomicRelationLearning
extends Module {
    private final Phase aiPhase = Phase.NonTaxonomicRelationLearning;
    private final String aiName = "NonTaxonomicRelationLearning";
    private GraphManager graphManager;
    private Graph<FileNode, DefaultEdge> fileNodeGraph;
    private DistanceMeasure distanceMeasure = new EuclideanDistance();

    @Override
    public void bootstrap(FileInfoStorage fileInfoStorage, AssertionPool pool, KecsSettings settings) {
    }

    @Override
    public void init(FileInfoStorage fileInfoStorage, AssertionPool pool, KecsSettings settings) {
        this.settings = settings;
        this.graphManager = new GraphManager();
        if (settings.getMode() == KecsSettings.Mode.Load || settings.getMode() == KecsSettings.Mode.Demo) {
            this.fileNodeGraph = this.graphManager.loadCachedFileNodeGraphSiblings(fileInfoStorage, settings.getNonTaxonomicTimeout(), settings.getNonTaxonomicDepthThreshold());
            System.out.println("\tfileNodeGraph: " + this.fileNodeGraph.vertexSet().size() + " nodes, " + this.fileNodeGraph.edgeSet().size() + " edges");
            this.nonTaxonomicLinkPrediction(pool);
            pool.commit();
        }
    }

    @Override
    public void updateOnChanges(FileInfoStorage fileInfoStorage, AssertionPool pool, List<Assertion> changes) {
        this.timeStat("NonTaxonomicRelationLearning", () -> {
            boolean typeAsserted;
            boolean humanNonTaxonomyFeedback = !AssertionPool.filter(changes, null, null, null, Phase.NonTaxonomicRelationLearning, Intelligence.NI, null, null, 0.0).isEmpty();
            boolean bl = typeAsserted = !AssertionPool.filter(changes, null, RDF.type, null, Phase.OntologyPopulation, null, null, null, 0.0).isEmpty();
            if (humanNonTaxonomyFeedback || typeAsserted) {
                this.timeStat("nonTaxonomicLinkPrediction", () -> this.nonTaxonomicLinkPrediction(pool));
            }
        });
        this.saveTimeStat();
    }

    private void nonTaxonomicLinkPrediction(AssertionPool pool) {
        long begin = System.currentTimeMillis();
        List<Assertion> topicAssertions = pool.getAssertions(null, FOAF.topic, null, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0);
        long end = System.currentTimeMillis();
        boolean removeConcepts = false;
        if (removeConcepts) {
            topicAssertions.removeIf(a -> {
                List<Assertion> typeAssertions = pool.getAssertions(a.getObject(), RDF.type, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
                if (typeAssertions.isEmpty()) {
                    return true;
                }
                return typeAssertions.get(0).getObject().equals(OntologyPopulation.CONCEPT_TYPE);
            });
        }
        if (topicAssertions.isEmpty()) {
            return;
        }
        List<Assertion> assertions = pool.getAssertions(null, null, null, Phase.NonTaxonomicRelationLearning, Intelligence.NI, null, null, 0.0);
        if (assertions.isEmpty()) {
            return;
        }
        this.graphManager.updateCachedFileNodeGraph(topicAssertions);
        DefaultUndirectedWeightedGraph<Resource, DefaultWeightedEdge> topicGraph = this.graphManager.getTopicGraphV2(this.fileNodeGraph);
        if (topicGraph.vertexSet().isEmpty()) {
            return;
        }
        List<LinkPredictionAlgorithm<Resource, DefaultWeightedEdge>> algos = GraphManager.allLinkPredictionAlgorithms(topicGraph);
        algos.remove(6);
        List<Statement> toTest = this.getPotentialRelations(pool);
        if (toTest.isEmpty()) {
            return;
        }
        Datasets datasets = this.graphManager.linkPrediction(topicGraph, algos, assertions, toTest);
        double distanceThreshold = 1.0;
        List<Prediction> predictions = this.graphManager.distanceBasedPrediction(datasets, this.distanceMeasure, distanceThreshold, pool);
        this.assertPredictions(predictions, pool, distanceThreshold);
    }

    private void assertPredictions(List<Prediction> predictions, AssertionPool pool, double distanceThreshold) {
        for (Assertion assertion : pool.getAssertions(null, null, null, this.aiPhase, Intelligence.AI, "NonTaxonomicRelationLearning", Rating.Positive, 0.0)) {
            pool.assertStatement(assertion.getStatement(), this.aiPhase, Intelligence.AI, "NonTaxonomicRelationLearning", Rating.Negative, 1.0);
        }
        for (Prediction pred : predictions) {
            Statement stmt = pred.getStatement();
            Rating rating = stmt.getPredicate().equals(GraphManager.NEGATIVE_CLASS) ? Rating.Negative : Rating.Positive;
            List<Assertion> stmtAssertions = pool.getAssertions(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), this.aiPhase, null, null, null, 0.0);
            double confidence = 1.0 - pred.getDistance() / distanceThreshold;
            if (!stmtAssertions.isEmpty() && stmtAssertions.get(0).getIntelligence() != Intelligence.AI) continue;
            pool.assertStatement(stmt, this.aiPhase, Intelligence.AI, "NonTaxonomicRelationLearning", rating, confidence);
        }
    }

    private List<Statement> getPotentialRelations(AssertionPool pool) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        HashMap<Resource, Resource> domainMap = new HashMap<Resource, Resource>();
        for (Assertion assertion : pool.getAssertions(null, RDFS.domain, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0)) {
            domainMap.put(assertion.getSubject(), assertion.getObject());
        }
        HashMap<Resource, Resource> rangeMap = new HashMap<Resource, Resource>();
        for (Assertion rangeAssertion : pool.getAssertions(null, RDFS.range, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0)) {
            rangeMap.put(rangeAssertion.getSubject(), rangeAssertion.getObject());
        }
        HashSet<Resource> hashSet = new HashSet<Resource>();
        HashMap<Resource, Set> type2insts = new HashMap<Resource, Set>();
        for (Assertion typeAssertion : pool.getAssertions(null, RDF.type, null, Phase.OntologyPopulation, Intelligence.NI, null, Rating.Positive, 0.0)) {
            Resource clazz = typeAssertion.getObject();
            if (clazz.equals(RDF.Property) || clazz.equals(RDFS.Class)) continue;
            type2insts.computeIfAbsent(clazz, r -> new HashSet()).add(typeAssertion.getSubject());
            hashSet.add(typeAssertion.getSubject());
        }
        for (Assertion propertyAssertion : pool.getAssertions(null, RDF.type, RDF.Property, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0)) {
            Resource property = propertyAssertion.getSubject();
            Resource domain = (Resource)domainMap.get(property);
            Resource range = (Resource)rangeMap.get(property);
            Set<Resource> domainInsts = domain == null ? hashSet : (Set)type2insts.get(domain);
            Set<Resource> rangeInsts = range == null ? hashSet : (Set)type2insts.get(range);
            if (domainInsts == null || rangeInsts == null) continue;
            Property predicate = KecsApp.creator.createProperty(property.getURI());
            for (Resource subject : domainInsts) {
                for (Resource object : rangeInsts) {
                    Statement stmt = KecsApp.creator.createStatement(subject, predicate, object);
                    result.add(stmt);
                }
            }
        }
        return result;
    }
}

