/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs.modules;

import de.dfki.sds.kecs.util.Lemmatizer;
import de.dfki.sds.mschroeder.commons.lang.StringUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;

public class ModuleUtils {
    private static Lemmatizer lemmatizer = new Lemmatizer("/de/dfki/sds/kecs/auxiliary/lemma.bin.gz");

    public static Set<String> variations(String term) {
        HashSet<String> variations = new HashSet<String>();
        variations.add(term);
        String[] segments = StringUtils.splitByCharacterTypeCamelCase(term);
        ArrayList<String> segmentList = new ArrayList<String>(Arrays.asList(segments));
        List<String> separators = Arrays.asList("", " ", "_", "-");
        String separatorsStr = " _-";
        segmentList.removeIf(seg -> StringUtils.containsOnly((CharSequence)seg, separatorsStr));
        if (segmentList.size() > 3) {
            return variations;
        }
        if (segmentList.size() > 1) {
            ArrayList separatorInput = new ArrayList();
            for (int i = 0; i < segmentList.size() - 1; ++i) {
                separatorInput.add(separators);
            }
            List combinations = ModuleUtils.cartesianProductList(separatorInput);
            for (List list : combinations) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < segmentList.size(); ++i) {
                    sb.append((String)segmentList.get(i));
                    if (i >= list.size()) continue;
                    sb.append((String)list.get(i));
                }
                variations.add(sb.toString());
            }
        }
        HashMap<String, String> umlautMap = new HashMap<String, String>();
        umlautMap.put("\u00dc", "Ue");
        umlautMap.put("\u00d6", "Oe");
        umlautMap.put("\u00c4", "Ae");
        umlautMap.put("\u00fc", "ue");
        umlautMap.put("\u00f6", "oe");
        umlautMap.put("\u00e4", "ae");
        boolean containedUmlaut = false;
        for (Map.Entry entry : umlautMap.entrySet()) {
            if (!term.contains((CharSequence)entry.getKey())) continue;
            containedUmlaut = true;
            term = term.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        if (containedUmlaut) {
            variations.addAll(ModuleUtils.variations(term));
        }
        return variations;
    }

    public static String toPrefLabel(String term) {
        String prefLabel = term;
        if (!prefLabel.matches("[A-Z\u00dc\u00d6\u00c40-9]+") && !StringUtility.isCamelCase(term)) {
            prefLabel = ModuleUtils.umlautFixV2(prefLabel);
            if ((prefLabel = prefLabel.replace("_", " ")).length() >= 4) {
                prefLabel = lemmatizer.lookupOr(prefLabel, lbl -> lbl);
            }
            prefLabel = ModuleUtils.toProperCaseWords(prefLabel);
        }
        return prefLabel;
    }

    public static String toProperCase(String s) {
        int start;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        for (start = 1; start < s.length() && Character.isDigit(s.charAt(start - 1)); ++start) {
        }
        return s.substring(0, start).toUpperCase() + s.substring(start).toLowerCase();
    }

    public static String toProperCaseWords(String s) {
        StringJoiner sj = new StringJoiner(" ");
        for (String word : s.split("[ ]+")) {
            sj.add(ModuleUtils.toProperCase(word));
        }
        return sj.toString();
    }

    public static String umlautFix(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("Ue", "\u00dc").replace("Oe", "\u00d6").replace("Ae", "\u00c4").replace("ue", "\u00fc").replace("oe", "\u00f6").replace("ae", "\u00e4");
    }

    public static String umlautFixV2(String s) {
        if (s == null) {
            return null;
        }
        HashMap<String, String> umlautMap = new HashMap<String, String>();
        umlautMap.put("Ue", "\u00dc");
        umlautMap.put("Oe", "\u00d6");
        umlautMap.put("Ae", "\u00c4");
        umlautMap.put("ue", "\u00fc");
        umlautMap.put("oe", "\u00f6");
        umlautMap.put("ae", "\u00e4");
        block0: for (Map.Entry e2 : umlautMap.entrySet()) {
            String esc = (String)e2.getKey();
            String umlaut = (String)e2.getValue();
            int index = s.length();
            int i = 0;
            while ((i = s.lastIndexOf(esc, index)) != -1) {
                char c;
                boolean substitute = true;
                if (i > 0 && ((c = s.toLowerCase().charAt(i - 1)) == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u')) {
                    substitute = false;
                }
                if (substitute) {
                    s = s.substring(0, i) + umlaut + s.substring(i + 2, s.length());
                }
                if ((index = i - 1) >= 0) continue;
                continue block0;
            }
        }
        return s;
    }

    public static <T> List<List<T>> cartesianProductList(List<List<T>> lists) {
        if (lists.size() < 2) {
            ArrayList<List<T>> l = new ArrayList<List<T>>();
            for (T t : lists.get(0)) {
                l.add(new ArrayList<Object>(Arrays.asList(t)));
            }
            return l;
        }
        return ModuleUtils._cartesianProductList(0, lists);
    }

    private static <T> List<List<T>> _cartesianProductList(int index, List<List<T>> lists) {
        LinkedList<List<T>> ret = new LinkedList<List<T>>();
        if (index == lists.size()) {
            ret.add(new LinkedList());
        } else {
            for (T obj : lists.get(index)) {
                for (List<T> set : ModuleUtils._cartesianProductList(index + 1, lists)) {
                    set.add(obj);
                    ret.add(set);
                }
            }
        }
        return ret;
    }

    public static String getSymbols() {
        String str2 = "";
        for (int i = 33; i <= 126; ++i) {
            char c = (char)i;
            if (Character.isLetter(i) || Character.isDigit(c)) continue;
            str2 = str2 + c;
        }
        return str2;
    }
}

