/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs.modules;

import de.dfki.sds.hephaistos.storage.assertion.Assertion;
import de.dfki.sds.hephaistos.storage.assertion.AssertionListener;
import de.dfki.sds.hephaistos.storage.assertion.AssertionPool;
import de.dfki.sds.hephaistos.storage.file.FileInfoStorage;
import de.dfki.sds.kecs.KecsSettings;
import de.dfki.sds.kecs.ml.DefaultItemEmbedding;
import de.dfki.sds.kecs.util.KecsUtils;
import de.dfki.sds.mschroeder.commons.lang.math.MinAvgMaxSdDouble;
import de.dfki.sds.stringanalyzer.helper.GermaNet;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Module
implements AssertionListener {
    protected DefaultItemEmbedding embedding = null;
    protected GermaNet germaNet = null;
    protected KecsSettings settings;
    protected Map<String, MinAvgMaxSdDouble> statMap = new HashMap<String, MinAvgMaxSdDouble>();

    protected boolean embeddingIsLoaded() {
        return this.embedding != null;
    }

    protected boolean languageResourceIsLoaded() {
        return this.germaNet != null;
    }

    public abstract void bootstrap(FileInfoStorage var1, AssertionPool var2, KecsSettings var3);

    public void init(FileInfoStorage fileInfoStorage, AssertionPool pool, KecsSettings settings) {
    }

    protected void print(List<Assertion> changes) {
        System.out.println();
        System.out.println(this.getClass().getSimpleName() + " updateOnChanges");
        changes.forEach(a -> System.out.println("\t" + a));
    }

    protected void timeStat(String name, Runnable runnable) {
        MinAvgMaxSdDouble stat = this.statMap.computeIfAbsent(name, nm -> new MinAvgMaxSdDouble());
        long begin = System.currentTimeMillis();
        runnable.run();
        long end = System.currentTimeMillis();
        stat.add(end - begin);
    }

    protected void printTimeStat() {
        ArrayList<Map.Entry<String, MinAvgMaxSdDouble>> entryList = new ArrayList<Map.Entry<String, MinAvgMaxSdDouble>>(this.statMap.entrySet());
        entryList.sort((a, b) -> Double.compare(((MinAvgMaxSdDouble)b.getValue()).getAvg(), ((MinAvgMaxSdDouble)a.getValue()).getAvg()));
        System.out.println();
        for (Map.Entry entry : entryList) {
            System.out.println((String)entry.getKey() + " takes " + ((MinAvgMaxSdDouble)entry.getValue()).toStringInt());
        }
    }

    protected void saveTimeStat() {
        ArrayList<Map.Entry<String, MinAvgMaxSdDouble>> entryList = new ArrayList<Map.Entry<String, MinAvgMaxSdDouble>>(this.statMap.entrySet());
        entryList.sort((a, b) -> Double.compare(((MinAvgMaxSdDouble)b.getValue()).getAvg(), ((MinAvgMaxSdDouble)a.getValue()).getAvg()));
        StringWriter sw = new StringWriter();
        sw.append("\n");
        sw.append(LocalDateTime.now().toString() + "\n");
        for (Map.Entry entry : entryList) {
            sw.append((String)entry.getKey() + " takes " + ((MinAvgMaxSdDouble)entry.getValue()).toStringInt() + "\n");
        }
        KecsUtils.saveTime(this.settings.getOutputFolder(), sw.toString());
    }

    public void setEmbedding(DefaultItemEmbedding embedding) {
        this.embedding = embedding;
    }

    public void setGermaNet(GermaNet germaNet) {
        this.germaNet = germaNet;
    }
}

