/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs.modules;

import de.dfki.sds.hephaistos.storage.assertion.Assertion;
import de.dfki.sds.hephaistos.storage.assertion.AssertionPool;
import de.dfki.sds.hephaistos.storage.assertion.Intelligence;
import de.dfki.sds.hephaistos.storage.assertion.Phase;
import de.dfki.sds.hephaistos.storage.assertion.Rating;
import de.dfki.sds.hephaistos.storage.file.FileInfoStorage;
import de.dfki.sds.kecs.KecsApp;
import de.dfki.sds.kecs.KecsSettings;
import de.dfki.sds.kecs.modules.ConceptDiscovery;
import de.dfki.sds.kecs.modules.Module;
import de.dfki.sds.kecs.modules.OntologyPopulation;
import de.dfki.sds.stringanalyzer.helper.GermaNet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.SKOS;

public class ConceptHierarchyDerivation
extends Module {
    private final Phase aiPhase = Phase.ConceptHierarchyDerivation;
    private final String aiName = "ConceptHierarchyDerivation";
    private final double stepAvgThreshold = 3.0;

    @Override
    public void bootstrap(FileInfoStorage fileInfoStorage, AssertionPool pool, KecsSettings settings) {
    }

    @Override
    public void init(FileInfoStorage fileInfoStorage, AssertionPool pool, KecsSettings settings) {
        this.settings = settings;
    }

    @Override
    public void updateOnChanges(FileInfoStorage fileInfoStorage, AssertionPool pool, List<Assertion> changes) {
        this.timeStat("ConceptHierarchyDerivation", () -> {
            List<Assertion> broaderChanges;
            if (this.languageResourceIsLoaded()) {
                this.suggestBroaderWithLanguageResource(pool, changes);
            }
            if (!(broaderChanges = AssertionPool.filter(changes, null, SKOS.broader, null, Phase.ConceptHierarchyDerivation, Intelligence.NI, null, null, 0.0)).isEmpty()) {
                this.timeStat("broaderEffectsSubjectObject", () -> this.broaderEffectsSubjectObject(broaderChanges, pool));
            }
        });
        this.saveTimeStat();
    }

    private void suggestBroaderWithLanguageResource(AssertionPool pool, List<Assertion> changes) {
        boolean conceptRenamed;
        boolean conceptOccurred = !AssertionPool.filter(changes, null, RDF.type, OntologyPopulation.CONCEPT_TYPE, Phase.OntologyPopulation, Intelligence.NI, null, Rating.Positive, 0.0).isEmpty();
        boolean bl = conceptRenamed = !AssertionPool.filter(changes, null, SKOS.prefLabel, null, Phase.ConceptDiscovery, Intelligence.NI, null, Rating.Positive, 0.0).isEmpty();
        if (conceptOccurred || conceptRenamed) {
            this.timeStat("suggestBroader", () -> this.suggestBroaderWithLanguageResource(pool));
        }
    }

    private void suggestBroaderWithLanguageResource(AssertionPool pool) {
        boolean print2 = false;
        Map<Resource, String> cpt2prefLbl = pool.getConceptPrefLabelMap(ConceptDiscovery.DEFAULT_TYPE, null);
        List<Assertion> skosConceptAssertions = pool.getAssertions(null, RDF.type, OntologyPopulation.CONCEPT_TYPE, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
        Node root2 = new Node("ROOT");
        HashMap<String, Node> id2node = new HashMap<String, Node>();
        for (Assertion assertion : skosConceptAssertions) {
            String prefLabel;
            List<GermaNet.SynSet> synsets;
            Resource leftConcept = assertion.getSubject();
            List<Assertion> topicRelations = pool.getAssertions(null, FOAF.topic, leftConcept, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0);
            if (topicRelations.isEmpty() || (synsets = this.germaNet.lookup(prefLabel = cpt2prefLbl.get(leftConcept))).isEmpty()) continue;
            for (GermaNet.SynSet start : synsets) {
                List<GermaNet.SynSet> parentPath = start.getParentPathDisambig(4);
                parentPath.add(start);
                int depth = 0;
                Node cur = root2;
                for (GermaNet.SynSet synset : parentPath) {
                    cur = cur.getOrCreate(synset, depth);
                    ++depth;
                    id2node.put(cur.id, cur);
                }
                int step = 0;
                while (cur != root2) {
                    if (step > 0) {
                        cur.steps.add(new SynSetWithStep(start, step, leftConcept));
                    }
                    ++step;
                    cur = cur.parent;
                }
                if (!print2) continue;
                System.out.println("[SynSet] " + prefLabel + ": " + parentPath);
            }
        }
        ArrayList nodes = new ArrayList(id2node.values());
        nodes.removeIf(n -> n.steps.size() <= 1);
        for (Node node : nodes) {
            node.stepAvg = node.steps.stream().mapToInt(s -> ((SynSetWithStep)s).step).average().getAsDouble();
        }
        nodes.removeIf(n -> n.stepAvg > 3.0);
        nodes.sort((a, b) -> Double.compare(a.stepAvg, b.stepAvg));
        if (print2) {
            for (Node node : nodes) {
                System.out.println(node);
            }
        }
        HashSet<Resource> hashSet = new HashSet<Resource>();
        HashSet<Resource> usedInBroader = new HashSet<Resource>();
        for (Node node : nodes) {
            List<Assertion> broadTopicAssertions = pool.getAssertions(node.concept, RDF.type, OntologyPopulation.CONCEPT_TYPE, Phase.OntologyPopulation, null, null, null, 0.0);
            boolean createBroaderTopic = broadTopicAssertions.isEmpty() && !hashSet.contains(node.concept);
            ArrayList<SynSetWithStep> suggested = new ArrayList<SynSetWithStep>();
            int positiveCount = 0;
            for (SynSetWithStep entry : node.steps) {
                if (usedInBroader.contains(entry.concept)) continue;
                List<Assertion> assertions = pool.getAssertions(entry.concept, SKOS.broader, node.concept, Phase.ConceptHierarchyDerivation, null, null, null, 0.0);
                if (!assertions.isEmpty()) {
                    Assertion assertion = assertions.get(0);
                    if (assertion.getRating() != Rating.Positive) continue;
                    ++positiveCount;
                    usedInBroader.add(entry.concept);
                    continue;
                }
                suggested.add(entry);
            }
            if (suggested.isEmpty() || suggested.size() + positiveCount <= 1) continue;
            if (createBroaderTopic) {
                pool.assertStatement(node.concept, RDF.type, ConceptDiscovery.DEFAULT_TYPE, Phase.ConceptDiscovery, Intelligence.AI, "ConceptHierarchyDerivation", Rating.Undecided, 1.0);
                pool.assertStatement(node.concept, RDF.type, OntologyPopulation.CONCEPT_TYPE, Phase.OntologyPopulation, Intelligence.AI, "ConceptHierarchyDerivation", Rating.Positive, 1.0);
                List<GermaNet.LexUnit> parentLexUnits = node.synset.getLexUnits();
                for (int luIndex = 0; luIndex < parentLexUnits.size(); ++luIndex) {
                    GermaNet.LexUnit lexUnit = parentLexUnits.get(luIndex);
                    if (luIndex == 0) {
                        pool.assertStatement(node.concept, SKOS.prefLabel, lexUnit.getOrthForm(), Phase.ConceptDiscovery, Intelligence.AI, "ConceptHierarchyDerivation", Rating.Positive, 1.0);
                    }
                    pool.assertStatement(node.concept, SKOS.hiddenLabel, lexUnit.getOrthForm(), Phase.ConceptDiscovery, Intelligence.AI, "ConceptHierarchyDerivation", Rating.Positive, 1.0);
                }
                hashSet.add(node.concept);
            }
            for (SynSetWithStep entry : suggested) {
                double conf = 1.0 - ((double)entry.step - 1.0) / 6.0;
                pool.assertStatement(entry.concept, SKOS.broader, node.concept, this.aiPhase, Intelligence.AI, "ConceptHierarchyDerivation", Rating.Positive, conf);
                usedInBroader.add(entry.concept);
            }
        }
    }

    private void broaderEffectsSubjectObject(List<Assertion> broaderChanges, AssertionPool pool) {
        for (Assertion broaderAssertion : broaderChanges) {
            if (broaderAssertion.getRating() != Rating.Positive) continue;
            for (Resource res : Arrays.asList(broaderAssertion.getSubject(), broaderAssertion.getObject())) {
                pool.assertStatement(res, RDF.type, ConceptDiscovery.DEFAULT_TYPE, Phase.ConceptDiscovery, broaderAssertion.getIntelligence(), broaderAssertion.getName(), Rating.Positive, 1.0);
                pool.assertStatement(res, RDF.type, OntologyPopulation.CONCEPT_TYPE, Phase.OntologyPopulation, broaderAssertion.getIntelligence(), broaderAssertion.getName(), Rating.Positive, 1.0);
            }
        }
    }

    private class Node {
        String id;
        Map<String, Node> childMap = new HashMap<String, Node>();
        GermaNet.SynSet synset;
        Node parent;
        int depth;
        int stepSum;
        double stepAvg;
        Set<SynSetWithStep> steps = new HashSet<SynSetWithStep>();
        Resource concept;

        public Node() {
        }

        public Node(String id) {
            this.id = id;
        }

        public Node(GermaNet.SynSet synset) {
            this.synset = synset;
            this.id = synset.getId();
            this.concept = KecsApp.creator.createResource("urn:concept:" + synset.getId());
        }

        public Node getOrCreate(GermaNet.SynSet synset, int depth) {
            if (this.childMap.containsKey(synset.getId())) {
                return this.childMap.get(synset.getId());
            }
            Node n = new Node(synset);
            n.depth = depth;
            this.childMap.put(n.id, n);
            n.parent = this;
            return n;
        }

        public String toString() {
            return "depth=" + this.depth + ", stepAvg=" + this.stepAvg + " " + this.concept + " " + (this.synset != null ? this.synset.getLexSimple() : "") + " => " + this.steps.toString();
        }

        public List<Node> getChildren() {
            return new ArrayList<Node>(this.childMap.values());
        }

        public String toStringTree() {
            StringBuilder sb = new StringBuilder();
            this.toStringTree("", true, sb);
            return sb.toString();
        }

        private void toStringTree(String prefix, boolean isTail, StringBuilder sb) {
            List<Node> children = this.getChildren();
            sb.append(prefix).append(isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(this.toString()).append("\n");
            for (int i = 0; i < children.size() - 1; ++i) {
                children.get(i).toStringTree(prefix + (isTail ? "    " : "\u2502   "), false, sb);
            }
            if (children.size() > 0) {
                children.get(children.size() - 1).toStringTree(prefix + (isTail ? "    " : "\u2502   "), true, sb);
            }
        }
    }

    private class SynSetWithStep {
        private GermaNet.SynSet synset;
        private int step;
        private Resource concept;

        public SynSetWithStep(GermaNet.SynSet synset, int step, Resource concept) {
            this.synset = synset;
            this.step = step;
            this.concept = concept;
        }

        public String toString() {
            return "(" + this.step + ":" + this.synset.getLexSimple() + " " + this.concept + ")";
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + Objects.hashCode(this.synset.getId());
            hash = 41 * hash + this.step;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SynSetWithStep other = (SynSetWithStep)obj;
            if (this.step != other.step) {
                return false;
            }
            return Objects.equals(this.synset.getId(), other.synset.getId());
        }
    }
}

