/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs.modules;

import de.dfki.sds.hephaistos.storage.assertion.Assertion;
import de.dfki.sds.hephaistos.storage.assertion.AssertionPool;
import de.dfki.sds.hephaistos.storage.assertion.Concept;
import de.dfki.sds.hephaistos.storage.assertion.Intelligence;
import de.dfki.sds.hephaistos.storage.assertion.Phase;
import de.dfki.sds.hephaistos.storage.assertion.Rating;
import de.dfki.sds.hephaistos.storage.file.FileInfoStorage;
import de.dfki.sds.kecs.KecsApp;
import de.dfki.sds.kecs.KecsSettings;
import de.dfki.sds.kecs.modules.Module;
import de.dfki.sds.kecs.vocab.KECS;
import de.dfki.sds.mschroeder.commons.lang.SetUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.SKOS;

public class ConceptDiscovery
extends Module {
    public static final Resource DEFAULT_TYPE = OWL2.NamedIndividual;
    private final Phase aiPhase = Phase.ConceptDiscovery;
    private final String aiName = "ConceptDiscovery";

    @Override
    public void bootstrap(FileInfoStorage fileInfoStorage, AssertionPool pool, KecsSettings settings) {
    }

    @Override
    public void init(FileInfoStorage fileInfoStorage, AssertionPool pool, KecsSettings settings) {
        this.settings = settings;
    }

    @Override
    public void updateOnChanges(FileInfoStorage fileInfoStorage, AssertionPool pool, List<Assertion> changes) {
        this.timeStat("ConceptDiscovery", () -> {
            this.timeStat("prefLabelEffectsTechLabel", () -> this.prefLabelEffectsTechLabel(pool, changes));
            this.timeStat("termNegativeTopicRelationNegative", () -> this.termNegativeTopicRelationNegative(pool, changes));
            this.timeStat("hiddenLabelsEffectsTopicRelation", () -> this.hiddenLabelsEffectsTopicRelation(pool, changes));
            this.timeStat("conceptRatingEffectsVariousRelationsRating", () -> this.conceptRatingEffectsVariousRelationsRating(pool, changes));
            this.timeStat("labelsLeadToSameAsSuggestions", () -> this.labelsLeadToSameAsSuggestions(pool, changes));
        });
        this.saveTimeStat();
    }

    private void termNegativeTopicRelationNegative(AssertionPool pool, List<Assertion> changes) {
        for (Assertion assertion : AssertionPool.filter(changes, null, KECS.containsDomainTerm, null, Phase.DomainTerminologyExtraction, null, null, Rating.Negative, 0.0)) {
            Resource node = assertion.getStatement().getSubject();
            String changedDomainTerm = assertion.getStatement().getString();
            for (Assertion topicAssertion : pool.getAssertions(node, FOAF.topic, null, this.aiPhase, null, null, Rating.Positive, 0.0)) {
                Assertion conceptAssertion = pool.getConceptAssertion(topicAssertion.getObject());
                Concept concept = pool.getConcept(conceptAssertion);
                for (Assertion techLabelAssertion : concept.getHiddenLabels()) {
                    String techLabel;
                    if (techLabelAssertion.getRating() != Rating.Positive || !changedDomainTerm.equals(techLabel = techLabelAssertion.getStatement().getString())) continue;
                    pool.assertStatement(topicAssertion.getStatement(), this.aiPhase, Intelligence.AI, "ConceptDiscovery", Rating.Negative, 1.0);
                }
            }
        }
    }

    private void conceptRatingEffectsVariousRelationsRating(AssertionPool pool, List<Assertion> changes) {
        double conf = 0.75;
        for (Assertion assertion : AssertionPool.filter(changes, null, RDF.type, DEFAULT_TYPE, this.aiPhase, null, null, null, 0.0)) {
            for (Assertion topicAssertion : pool.getAssertions(null, FOAF.topic, assertion.getSubject(), this.aiPhase, null, null, null, 0.0)) {
                if (topicAssertion.getRating() == assertion.getRating()) continue;
                pool.assertStatement(topicAssertion.getStatement(), topicAssertion.getPhase(), Intelligence.AI, "ConceptDiscovery", assertion.getRating(), conf);
            }
            for (Assertion sameAsAssertion : pool.getAssertions(null, OWL.sameAs, null, this.aiPhase, null, null, null, 0.0)) {
                if (!sameAsAssertion.getSubject().equals(assertion.getSubject()) && !sameAsAssertion.getObject().equals(assertion.getSubject()) || sameAsAssertion.getRating() == assertion.getRating()) continue;
                pool.assertStatement(sameAsAssertion.getStatement(), sameAsAssertion.getPhase(), Intelligence.AI, "ConceptDiscovery", assertion.getRating(), conf);
            }
            for (Assertion broaderAssertion : pool.getAssertions(null, SKOS.broader, null, Phase.ConceptHierarchyDerivation, null, null, null, 0.0)) {
                if (!broaderAssertion.getSubject().equals(assertion.getSubject()) && !broaderAssertion.getObject().equals(assertion.getSubject()) || broaderAssertion.getRating() == assertion.getRating()) continue;
                pool.assertStatement(broaderAssertion.getStatement(), broaderAssertion.getPhase(), Intelligence.AI, "ConceptDiscovery", assertion.getRating(), conf);
            }
            for (Assertion nonTaxAssertion : pool.getAssertions(null, null, null, Phase.NonTaxonomicRelationLearning, null, null, null, 0.0)) {
                if (!nonTaxAssertion.getSubject().equals(assertion.getSubject()) && !nonTaxAssertion.getObject().equals(assertion.getSubject()) || nonTaxAssertion.getRating() == assertion.getRating()) continue;
                pool.assertStatement(nonTaxAssertion.getStatement(), nonTaxAssertion.getPhase(), Intelligence.AI, "ConceptDiscovery", assertion.getRating(), conf);
            }
        }
    }

    private void prefLabelEffectsTechLabel(AssertionPool pool, List<Assertion> changes) {
        for (Assertion assertion : AssertionPool.filter(changes, null, SKOS.prefLabel, null, this.aiPhase, null, null, null, 0.0)) {
            boolean assertIt = true;
            String techLabel = assertion.getStatement().getString();
            if (assertion.getRating() == Rating.Negative) {
                for (Assertion topicAssertion : pool.getAssertions(null, FOAF.topic, assertion.getSubject(), this.aiPhase, null, null, Rating.Positive, 0.0)) {
                    Resource node = topicAssertion.getSubject();
                    for (Assertion termAssertion : pool.getAssertions(node, KECS.containsDomainTerm, null, Phase.DomainTerminologyExtraction, null, null, Rating.Positive, 0.0)) {
                        String domainTerm = termAssertion.getStatement().getString();
                        if (!techLabel.equals(domainTerm)) continue;
                        assertIt = false;
                        break;
                    }
                    if (assertIt) continue;
                    break;
                }
            }
            if (!assertIt) continue;
            pool.assertStatement(assertion.getSubject(), SKOS.hiddenLabel, assertion.getStatement().getObject(), assertion.getPhase(), assertion.getIntelligence(), assertion.getName(), assertion.getRating(), assertion.getConfidence());
        }
    }

    private void hiddenLabelsEffectsTopicRelation(AssertionPool pool, List<Assertion> changes) {
        boolean ignoreCase = false;
        for (Assertion assertion : AssertionPool.filter(changes, null, SKOS.hiddenLabel, null, this.aiPhase, Intelligence.NI, null, null, 0.0)) {
            Resource conceptWithTechLabel = assertion.getSubject();
            String techLabel = assertion.getStatement().getString();
            if (assertion.getRating() == Rating.Negative) {
                Assertion conceptAssertion = pool.getConceptAssertion(conceptWithTechLabel);
                Concept concept = pool.getConcept(conceptAssertion);
                HashSet<String> hiddenLabels = new HashSet<String>();
                for (Assertion techLabelAssertion : concept.getHiddenLabels()) {
                    if (techLabelAssertion.getRating() != Rating.Positive) continue;
                    String str2 = techLabelAssertion.getStatement().getString();
                    hiddenLabels.add(ignoreCase ? str2.toLowerCase() : str2);
                }
                for (Assertion topicAssertion : pool.getAssertions(null, FOAF.topic, conceptWithTechLabel, this.aiPhase, null, null, Rating.Positive, 0.0)) {
                    Resource node = topicAssertion.getSubject();
                    if (hiddenLabels.isEmpty()) {
                        pool.assertStatement(node, FOAF.topic, conceptWithTechLabel, this.aiPhase, Intelligence.AI, "ConceptDiscovery", Rating.Negative, 1.0);
                        continue;
                    }
                    HashSet<String> domainTerms = new HashSet<String>();
                    for (Assertion termAssertion : pool.getAssertions(node, KECS.containsDomainTerm, null, Phase.DomainTerminologyExtraction, null, null, Rating.Positive, 0.0)) {
                        String str3 = termAssertion.getStatement().getString();
                        domainTerms.add(ignoreCase ? str3.toLowerCase() : str3);
                    }
                    Set intersection = SetUtility.intersection(hiddenLabels, domainTerms);
                    if (!intersection.isEmpty()) continue;
                    pool.assertStatement(node, FOAF.topic, conceptWithTechLabel, this.aiPhase, Intelligence.AI, "ConceptDiscovery", Rating.Negative, 1.0);
                }
                continue;
            }
            if (assertion.getRating() != Rating.Positive) continue;
            if (!ignoreCase) {
                Literal techLblLit = KecsApp.creator.createLiteral(techLabel);
                for (Assertion termAssertion : pool.getAssertions(null, KECS.containsDomainTerm, techLblLit, Phase.DomainTerminologyExtraction, null, null, Rating.Positive, 0.0)) {
                    pool.assertStatement(termAssertion.getSubject(), FOAF.topic, conceptWithTechLabel, this.aiPhase, Intelligence.AI, "ConceptDiscovery", Rating.Positive, 1.0);
                }
                continue;
            }
            for (Assertion termAssertion : pool.getAssertions(null, KECS.containsDomainTerm, null, Phase.DomainTerminologyExtraction, null, null, Rating.Positive, 0.0)) {
                Resource node = termAssertion.getSubject();
                String domainTerm = termAssertion.getStatement().getString();
                boolean match = ignoreCase ? domainTerm.equalsIgnoreCase(techLabel) : domainTerm.equals(techLabel);
                if (!match) continue;
                pool.assertStatement(node, FOAF.topic, conceptWithTechLabel, this.aiPhase, Intelligence.AI, "ConceptDiscovery", Rating.Positive, 1.0);
            }
        }
    }

    private void labelsLeadToSameAsSuggestions(AssertionPool pool, List<Assertion> changes) {
        int levenshteinThreshold = 2;
        int levenshteinLengthThreshold = 5;
        ArrayList<Assertion> triggerAssertions = new ArrayList<Assertion>();
        triggerAssertions.addAll(AssertionPool.filter(changes, null, SKOS.prefLabel, null, this.aiPhase, Intelligence.NI, null, null, 0.0));
        triggerAssertions.addAll(AssertionPool.filter(changes, null, SKOS.hiddenLabel, null, this.aiPhase, Intelligence.NI, null, null, 0.0));
        triggerAssertions.addAll(AssertionPool.filter(changes, null, RDF.type, DEFAULT_TYPE, this.aiPhase, null, null, Rating.Positive, 0.0));
        if (triggerAssertions.isEmpty()) {
            return;
        }
        HashSet alreadyNegative = new HashSet();
        pool.getAssertions(null, OWL.sameAs, null, this.aiPhase, null, null, Rating.Negative, 0.0).forEach(a -> alreadyNegative.add(a.getSubject().getURI() + a.getObject().getURI()));
        HashSet concepts = new HashSet();
        triggerAssertions.forEach(a -> concepts.add(a.getSubject()));
        Map<Resource, String> prefLabelMap = pool.getConceptPrefLabelMap(DEFAULT_TYPE, Rating.Positive);
        HashMap ownPrefLabelMap = new HashMap();
        concepts.forEach(cpt -> {
            if (prefLabelMap.containsKey(cpt)) {
                ownPrefLabelMap.put(cpt, prefLabelMap.get(cpt));
                prefLabelMap.remove(cpt);
            }
        });
        for (Resource src : concepts) {
            String prefLblSrc = (String)ownPrefLabelMap.get(src);
            HashSet srcHiddenLabels = new HashSet();
            pool.getAssertions(src, SKOS.hiddenLabel, null, this.aiPhase, null, null, Rating.Positive, 0.0).forEach(a -> srcHiddenLabels.add(a.getStatement().getString()));
            for (Map.Entry<Resource, String> entry : prefLabelMap.entrySet()) {
                HashSet<String> dstSet;
                String regex;
                HashSet<String> srcSet;
                int dist;
                Resource dst = entry.getKey();
                if (alreadyNegative.contains(src.getURI() + dst.getURI())) continue;
                String prefLblDst = prefLabelMap.get(dst);
                if (prefLblSrc == null || prefLblDst == null) continue;
                double conf = 0.0;
                boolean match = false;
                Resource left = src;
                Resource right = dst;
                if (prefLblSrc.startsWith(prefLblDst) || prefLblSrc.endsWith(prefLblDst) || prefLblDst.startsWith(prefLblSrc) || prefLblDst.endsWith(prefLblSrc) || prefLblDst.equals(prefLblSrc)) {
                    if (prefLblSrc.length() > prefLblDst.length()) {
                        left = src;
                        right = dst;
                        conf = (double)prefLblDst.length() / (double)prefLblSrc.length();
                    } else {
                        left = dst;
                        right = src;
                        conf = (double)prefLblSrc.length() / (double)prefLblDst.length();
                    }
                    match = true;
                }
                if (!match && prefLblSrc.length() >= levenshteinLengthThreshold && prefLblDst.length() >= levenshteinLengthThreshold && (dist = StringUtils.getLevenshteinDistance(prefLblSrc, prefLblDst, levenshteinThreshold)) >= 0) {
                    conf = (double)(levenshteinThreshold - dist) / (double)levenshteinThreshold;
                    conf = 0.66 + 0.33 * conf;
                    match = true;
                }
                if (!match && (match = (srcSet = new HashSet<String>(Arrays.asList(prefLblSrc.split(regex = "[ \\-_]+")))).equals(dstSet = new HashSet<String>(Arrays.asList(prefLblDst.split(regex)))))) {
                    conf = 1.0;
                }
                if (!match) {
                    HashSet dstHiddenLabels = new HashSet();
                    pool.getAssertions(dst, SKOS.hiddenLabel, null, this.aiPhase, null, null, Rating.Positive, 0.0).forEach(a -> dstHiddenLabels.add(a.getStatement().getString()));
                    Set intersection = SetUtility.intersection(srcHiddenLabels, dstHiddenLabels);
                    boolean bl = match = !intersection.isEmpty();
                    if (match) {
                        conf = (double)intersection.size() / (double)SetUtility.union(srcHiddenLabels, dstHiddenLabels).size();
                    }
                }
                if (!match) continue;
                pool.assertStatement(left, OWL.sameAs, right, Phase.ConceptDiscovery, Intelligence.AI, "ConceptDiscovery", Rating.Positive, conf);
            }
        }
    }

    public static String getIndividualName(KecsSettings settings) {
        if (settings.getLanguage() == KecsSettings.Language.de) {
            return "(Schlagwort)";
        }
        if (settings.getLanguage() == KecsSettings.Language.semweb) {
            return "owl:NamedIndividual";
        }
        return "(Tag)";
    }
}

