/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs.ml;

import de.dfki.sds.hephaistos.storage.assertion.Assertion;
import de.dfki.sds.hephaistos.storage.assertion.AssertionPool;
import de.dfki.sds.hephaistos.storage.assertion.Intelligence;
import de.dfki.sds.hephaistos.storage.assertion.Phase;
import de.dfki.sds.hephaistos.storage.assertion.Rating;
import de.dfki.sds.hephaistos.storage.file.FileInfo;
import de.dfki.sds.hephaistos.storage.file.FileInfoStorage;
import de.dfki.sds.kecs.KecsSettings;
import de.dfki.sds.kecs.ml.GraphManager;
import de.dfki.sds.kecs.modules.ConceptDiscovery;
import de.dfki.sds.kecs.modules.OntologyPopulation;
import de.dfki.sds.kecs.util.KecsUtils;
import de.dfki.sds.kecs.util.PropertyEdge;
import de.dfki.sds.kecs.vocab.DOT;
import de.dfki.sds.kecs.vocab.NFO;
import de.dfki.sds.mschroeder.commons.lang.MemoryUtility;
import de.dfki.sds.mschroeder.commons.lang.SetUtility;
import de.dfki.sds.mschroeder.commons.lang.math.MinAvgMaxSdDouble;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.SKOS;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.shortestpath.GraphMeasurer;
import org.jgrapht.graph.AsSubgraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultUndirectedGraph;
import org.json.JSONArray;
import org.json.JSONObject;

public class StatusManager {
    private FileInfoStorage fileInfoStorage;
    private AssertionPool assertionPool;
    private KecsSettings settings;
    private GraphManager graphManager;
    private long branchCount;
    private long leafCount;
    private double conceptDiscoveryMetric;
    private int positiveTopics;
    private int positiveTerms;
    private Resource conceptDiscoveryNextFileResource;
    private FileInfo conceptDiscoveryNextFile;
    private double ontologyPopulationMetric;
    private int positiveTypes;
    private int positiveConcepts;
    private double taxonomyMetric;
    private int taxComponents;
    private int taxVertices;
    private int taxConcepts;
    private int taxBroader;
    private double taxGeneralization;
    private double taxConnectedness;
    private double nonTaxonomicMetric;
    private int nonTaxComponents;
    private int nonTaxVertices;
    private double nonTaxConnectedness;
    private double nonTaxDiameter;
    private double nonTaxCloseness;
    private int effortClick;
    private int effortKeydown;
    private int effortInteractions;
    private long memoryUsed;
    private long memoryTotal;
    private long memoryMax;
    private double overallRating;
    private long duration;
    private JSONObject chartData;
    private double productivity;
    private final Object syncPoint = new Object();

    public StatusManager(FileInfoStorage fileInfoStorage, AssertionPool assertionPool, KecsSettings settings) {
        this.fileInfoStorage = fileInfoStorage;
        this.assertionPool = assertionPool;
        this.settings = settings;
        this.graphManager = new GraphManager();
        this.fileInfoStatus();
    }

    public final void fileInfoStatus() {
        if (this.branchCount == 0L && this.leafCount == 0L) {
            this.branchCount = this.fileInfoStorage.getBranchCount();
            this.leafCount = this.fileInfoStorage.getLeafCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateAll(boolean fastTopicStatistics) {
        Object object = this.syncPoint;
        synchronized (object) {
            long begin = System.currentTimeMillis();
            this.topicStatistics(fastTopicStatistics);
            this.ontologyPopulationStatistics();
            this.taxonomyStatistics();
            this.nonTaxonomicStatistics();
            this.effortStatistics();
            this.overallRating();
            this.productivityStatistics();
            this.memoryStatistics();
            long end = System.currentTimeMillis();
            this.duration = end - begin;
            KecsUtils.saveStatus(this, this.settings.getOutputFolder());
            this.chartData();
        }
    }

    @Deprecated
    public void termStatistics() {
    }

    /*
     * Exception decompiling
     */
    public void topicStatistics(boolean fastTopicStatistics) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AssignmentExpression.applyExpressionRewriter(AssignmentExpression.java:68)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void ontologyPopulationStatistics() {
        List<Assertion> typeAssertions = this.assertionPool.getAssertions(null, RDF.type, null, Phase.OntologyPopulation, Intelligence.NI, null, Rating.Positive, 0.0);
        typeAssertions.removeIf(a -> {
            Resource type = a.getObject();
            return type.equals(RDFS.Class) || type.equals(RDF.Property);
        });
        HashSet hasType = new HashSet();
        typeAssertions.forEach(a -> hasType.add(a.getSubject()));
        List<Assertion> conceptAssertions = this.assertionPool.getAssertions(null, RDF.type, ConceptDiscovery.DEFAULT_TYPE, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0);
        HashSet isConcept = new HashSet();
        conceptAssertions.forEach(a -> isConcept.add(a.getSubject()));
        this.positiveTypes = SetUtility.intersection(hasType, isConcept).size();
        this.positiveConcepts = conceptAssertions.size();
        if (this.positiveConcepts > 0) {
            this.ontologyPopulationMetric = (double)this.positiveTypes / (double)this.positiveConcepts;
        }
        if (this.ontologyPopulationMetric > 1.0) {
            this.ontologyPopulationMetric = 1.0;
        }
    }

    public void taxonomyStatistics() {
        DefaultUndirectedGraph<Resource, DefaultEdge> graph = this.graphManager.getTaxonomyGraph(this.assertionPool);
        ConnectivityInspector<Resource, DefaultEdge> connectivityInspector = new ConnectivityInspector<Resource, DefaultEdge>(graph);
        List<Set<Resource>> connectedSets = connectivityInspector.connectedSets();
        Set vertexSet = graph.vertexSet();
        this.taxComponents = connectedSets.size();
        this.taxVertices = vertexSet.size();
        double disconnection = this.taxVertices <= 1 ? 1.0 : (double)(this.taxComponents - 1) / (double)(this.taxVertices - 1);
        this.taxConnectedness = 1.0 - disconnection;
        this.taxConcepts = 0;
        this.taxBroader = 0;
        List<Assertion> conceptAssertions = this.assertionPool.getAssertions(null, RDF.type, OntologyPopulation.CONCEPT_TYPE, Phase.OntologyPopulation, Intelligence.NI, null, Rating.Positive, 0.0);
        for (Assertion conceptAssertion : conceptAssertions) {
            boolean isAnnotated = !this.assertionPool.getAssertions(null, FOAF.topic, conceptAssertion.getSubject(), Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0).isEmpty();
            if (!isAnnotated) continue;
            ++this.taxConcepts;
            boolean hasBroader = !this.assertionPool.getAssertions(conceptAssertion.getSubject(), SKOS.broader, null, Phase.ConceptHierarchyDerivation, Intelligence.NI, null, Rating.Positive, 0.0).isEmpty();
            if (!hasBroader) continue;
            ++this.taxBroader;
        }
        if (this.taxConcepts > 0) {
            this.taxGeneralization = (double)this.taxBroader / (double)this.taxConcepts;
        }
        this.taxonomyMetric = (this.taxGeneralization + this.taxConnectedness) / 2.0;
    }

    public void nonTaxonomicStatistics() {
        DefaultUndirectedGraph<Resource, PropertyEdge> graph = this.graphManager.getNonTaxonomicGraph(this.assertionPool);
        ConnectivityInspector<Resource, PropertyEdge> connectivityInspector = new ConnectivityInspector<Resource, PropertyEdge>(graph);
        List<Set<Resource>> connectedSets = connectivityInspector.connectedSets();
        Set vertexSet = graph.vertexSet();
        this.nonTaxComponents = connectedSets.size();
        this.nonTaxVertices = vertexSet.size();
        double disconnection = vertexSet.size() <= 1 ? 1.0 : (double)(connectedSets.size() - 1) / (double)(vertexSet.size() - 1);
        this.nonTaxConnectedness = 1.0 - disconnection;
        this.nonTaxDiameter = 0.0;
        this.nonTaxCloseness = 0.0;
        ArrayList<Double> nonTaxDiameterList = new ArrayList<Double>();
        ArrayList<Double> nonTaxClosenessList = new ArrayList<Double>();
        for (Set<Resource> connectedSet : connectedSets) {
            double worstDiameter;
            double bestDiameter;
            double nonTaxClosenessLocal;
            AsSubgraph<Resource, PropertyEdge> subgraph = new AsSubgraph<Resource, PropertyEdge>(graph, connectedSet);
            GraphMeasurer<Resource, PropertyEdge> graphMeasurer = new GraphMeasurer<Resource, PropertyEdge>(subgraph);
            double nonTaxDiameterLocal = graphMeasurer.getDiameter();
            if (nonTaxDiameterLocal != 0.0 && nonTaxDiameterLocal != Double.POSITIVE_INFINITY && !Double.isNaN(nonTaxClosenessLocal = 1.0 - (nonTaxDiameterLocal - (bestDiameter = 2.0)) / ((worstDiameter = (double)(graph.vertexSet().size() - 1)) - bestDiameter))) {
                if (nonTaxClosenessLocal > 1.0) {
                    nonTaxClosenessLocal = 1.0;
                }
                nonTaxClosenessList.add(nonTaxClosenessLocal);
            }
            if (nonTaxDiameterLocal == Double.POSITIVE_INFINITY) {
                nonTaxDiameterLocal = -1.0;
            }
            if (!(nonTaxDiameterLocal > 0.0)) continue;
            nonTaxDiameterList.add(nonTaxDiameterLocal);
        }
        OptionalDouble closenessOpt = nonTaxClosenessList.stream().mapToDouble(d -> d).average();
        OptionalDouble diameterOpt = nonTaxDiameterList.stream().mapToDouble(d -> d).average();
        if (closenessOpt.isPresent()) {
            this.nonTaxCloseness = closenessOpt.getAsDouble();
        }
        if (diameterOpt.isPresent()) {
            this.nonTaxDiameter = diameterOpt.getAsDouble();
        }
        this.nonTaxonomicMetric = (this.nonTaxConnectedness + this.nonTaxCloseness) / 2.0;
    }

    public void overallRating() {
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(this.conceptDiscoveryMetric);
        values.add(this.ontologyPopulationMetric);
        values.add(this.taxonomyMetric);
        values.add(this.nonTaxonomicMetric);
        this.overallRating = values.stream().mapToDouble(d -> d).average().getAsDouble();
    }

    public void effortStatistics() {
        this.effortClick = 0;
        this.effortKeydown = 0;
        this.effortInteractions = 0;
        File file = new File(this.settings.getOutputFolder(), "interactions.jsonl.gz");
        if (!file.exists()) {
            return;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                if (line.contains("\"type\":\"click\"")) {
                    ++this.effortClick;
                    continue;
                }
                if (!line.contains("\"type\":\"keydown\"")) continue;
                ++this.effortKeydown;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.effortInteractions = this.effortClick + this.effortKeydown;
    }

    public void productivityStatistics() {
        if (this.effortInteractions > 0) {
            this.productivity = this.overallRating / (double)this.effortInteractions;
        }
    }

    public void memoryStatistics() {
        Runtime instance = Runtime.getRuntime();
        StringBuilder sb = new StringBuilder();
        long t = instance.totalMemory();
        long f = instance.freeMemory();
        long u = t - f;
        long m = instance.maxMemory();
        this.memoryTotal = t;
        this.memoryUsed = u;
        this.memoryMax = m;
    }

    public void chartData() {
        this.chartData = new JSONObject();
        JSONArray datasets = new JSONArray();
        this.chartData.put("datasets", datasets);
        File file = new File(this.settings.getOutputFolder(), "status.jsonl.gz");
        if (!file.exists()) {
            return;
        }
        JSONObject dataset = new JSONObject();
        datasets.put(dataset);
        dataset.put("label", "Fortschritt");
        dataset.put("borderColor", "#007bff");
        dataset.put("backgroundColor", "#007bff");
        JSONArray data = new JSONArray();
        dataset.put("data", data);
        JSONArray labels = new JSONArray();
        this.chartData.put("labels", labels);
        double lastX = -1.0;
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                JSONObject entry = new JSONObject(line);
                double x = entry.getDouble("effortInteractions");
                if (!(x > lastX)) continue;
                labels.put(x);
                data.put(entry.getDouble("overallRating") * 100.0);
                lastX = x;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Map<String, Object> stats(List<Assertion> assertions) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("total", Double.valueOf(assertions.size()));
        int niCount = 0;
        int aiCount = 0;
        int posCount = 0;
        int negCount = 0;
        int undCount = 0;
        MinAvgMaxSdDouble strLengthStat = new MinAvgMaxSdDouble();
        HashSet<Resource> distinctSubjects = new HashSet<Resource>();
        HashSet<RDFNode> distinctObjects = new HashSet<RDFNode>();
        for (Assertion assertion : assertions) {
            Intelligence intel = assertion.getIntelligence();
            switch (intel) {
                case AI: {
                    ++aiCount;
                    break;
                }
                case NI: {
                    ++niCount;
                }
            }
            Rating rating = assertion.getRating();
            switch (rating) {
                case Positive: {
                    ++posCount;
                    break;
                }
                case Negative: {
                    ++negCount;
                    break;
                }
                case Undecided: {
                    ++undCount;
                }
            }
            if (assertion.getStatement().getObject().isLiteral()) {
                strLengthStat.add(assertion.getStatement().getString().length());
            }
            distinctSubjects.add(assertion.getSubject());
            distinctObjects.add(assertion.getStatement().getObject());
        }
        m.put("natural", niCount);
        m.put("artifical", aiCount);
        m.put("distinctSubjects", distinctSubjects.size());
        m.put("distinctObjects", distinctObjects.size());
        double totalCount = posCount + negCount + undCount;
        m.put("positive", posCount);
        m.put("positiveRate", (double)posCount / totalCount);
        m.put("negative", negCount);
        m.put("negativeRate", (double)negCount / totalCount);
        m.put("undecided", undCount);
        m.put("undecidedRate", (double)undCount / totalCount);
        m.put("stringLength", strLengthStat.toMap());
        return m;
    }

    public void fillJSON(JSONObject result) {
        result.put("leafCount", this.getLeafCount());
        result.put("branchCount", this.getBranchCount());
        result.put("positiveConcepts", this.getPositiveConcepts());
        result.put("positiveTerms", this.getPositiveTerms());
        result.put("positiveTopics", this.getPositiveTopics());
        result.put("positiveTypes", this.getPositiveTypes());
        if (this.conceptDiscoveryNextFileResource != null) {
            JSONObject conceptDiscoveryNextFileObj = new JSONObject();
            conceptDiscoveryNextFileObj.put("uri", this.conceptDiscoveryNextFileResource.getURI());
            conceptDiscoveryNextFileObj.put("name", this.conceptDiscoveryNextFile.getName());
            conceptDiscoveryNextFileObj.put("isFile", !this.conceptDiscoveryNextFile.isDirectory());
            result.put("conceptDiscoveryNextFile", conceptDiscoveryNextFileObj);
        }
        result.put("ontologyPopulationMetric", this.getOntologyPopulationMetric());
        result.put("conceptDiscoveryMetric", this.getConceptDiscoveryMetric());
        result.put("taxonomyMetric", this.getTaxonomyMetric());
        result.put("nonTaxonomicMetric", this.getNonTaxonomicMetric());
        result.put("taxBroader", this.getTaxBroader());
        result.put("taxComponents", this.getTaxComponents());
        result.put("taxConcepts", this.getTaxConcepts());
        result.put("taxConnectedness", this.getTaxConnectedness());
        result.put("taxGeneralization", this.getTaxGeneralization());
        result.put("taxVertices", this.getTaxVertices());
        result.put("nonTaxComponents", this.getNonTaxComponents());
        result.put("nonTaxVertices", this.getNonTaxVertices());
        result.put("nonTaxConnectedness", this.getNonTaxConnectedness());
        result.put("nonTaxDiameter", this.getNonTaxDiameter());
        result.put("nonTaxCloseness", this.getNonTaxCloseness());
        result.put("effortClick", this.getEffortClick());
        result.put("effortKeydown", this.getEffortKeydown());
        result.put("effortInteractions", this.getEffortInteractions());
        result.put("memoryTotalBytes", this.getMemoryTotal());
        result.put("memoryUsedBytes", this.getMemoryUsed());
        result.put("memoryMaxBytes", this.getMemoryMax());
        result.put("memoryTotal", MemoryUtility.humanReadableByteCount(this.getMemoryTotal()));
        result.put("memoryUsed", MemoryUtility.humanReadableByteCount(this.getMemoryUsed()));
        result.put("memoryMax", MemoryUtility.humanReadableByteCount(this.getMemoryMax()));
        result.put("overallRating", this.getOverallRating());
        result.put("productivity", this.getProductivity());
        result.put("duration", this.getDuration());
        result.put("data", this.getChartData());
    }

    public Model getTerminologyModel() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefixes(PrefixMapping.Standard);
        model.setNsPrefix("skos", "http://www.w3.org/2004/02/skos/core#");
        for (Assertion a : this.assertionPool.getAssertions(null, RDF.type, RDFS.Class, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0)) {
            model.add(a.getStatement());
            for (Assertion b : this.assertionPool.getAssertions(a.getSubject(), null, null, null, null, null, Rating.Positive, 0.0)) {
                model.add(b.getStatement());
            }
        }
        for (Assertion a : this.assertionPool.getAssertions(null, RDF.type, RDF.Property, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0)) {
            model.add(a.getStatement());
            for (Assertion b : this.assertionPool.getAssertions(a.getSubject(), null, null, null, null, null, Rating.Positive, 0.0)) {
                model.add(b.getStatement());
            }
        }
        return model;
    }

    public Model getAssertionModel() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefixes(PrefixMapping.Standard);
        model.setNsPrefix("skos", "http://www.w3.org/2004/02/skos/core#");
        for (Assertion a : this.assertionPool.getAssertions(null, RDF.type, ConceptDiscovery.DEFAULT_TYPE, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0)) {
            model.add(a.getStatement());
            for (Assertion b : this.assertionPool.getAssertions(a.getSubject(), null, null, null, null, null, Rating.Positive, 0.0)) {
                model.add(b.getStatement());
            }
        }
        for (Assertion a : this.assertionPool.getAssertions(null, null, null, Phase.ConceptHierarchyDerivation, null, null, Rating.Positive, 0.0)) {
            model.add(a.getStatement());
        }
        for (Assertion a : this.assertionPool.getAssertions(null, null, null, Phase.NonTaxonomicRelationLearning, null, null, Rating.Positive, 0.0)) {
            model.add(a.getStatement());
        }
        return model;
    }

    public Model getTopicModel() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefixes(PrefixMapping.Standard);
        model.setNsPrefix("skos", "http://www.w3.org/2004/02/skos/core#");
        model.setNsPrefix("dot", "https://w3id.org/dot#");
        model.setNsPrefix("foaf", "http://xmlns.com/foaf/0.1/");
        model.setNsPrefix("nfo", "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#");
        for (Assertion a : this.assertionPool.getAssertions(null, FOAF.topic, null, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0)) {
            model.add(a.getStatement());
            FileInfo fi = (FileInfo)this.fileInfoStorage.get(KecsUtils.getId(a.getSubject().getURI()));
            model.add(a.getSubject(), RDF.type, fi.isDirectory() ? NFO.Folder : NFO.LocalFileDataObject);
            model.add(a.getSubject(), SKOS.prefLabel, fi.getName());
            model.add(a.getSubject(), DOT.filePath, fi.getPath());
        }
        return model;
    }

    public long getBranchCount() {
        return this.branchCount;
    }

    public long getLeafCount() {
        return this.leafCount;
    }

    public int getPositiveTopics() {
        return this.positiveTopics;
    }

    public int getPositiveTerms() {
        return this.positiveTerms;
    }

    public Resource getConceptDiscoveryNextFileResource() {
        return this.conceptDiscoveryNextFileResource;
    }

    public FileInfo getConceptDiscoveryNextFile() {
        return this.conceptDiscoveryNextFile;
    }

    public double getOntologyPopulationMetric() {
        return this.ontologyPopulationMetric;
    }

    public int getPositiveTypes() {
        return this.positiveTypes;
    }

    public int getPositiveConcepts() {
        return this.positiveConcepts;
    }

    public int getNonTaxComponents() {
        return this.nonTaxComponents;
    }

    public int getNonTaxVertices() {
        return this.nonTaxVertices;
    }

    public double getNonTaxConnectedness() {
        return this.nonTaxConnectedness;
    }

    public double getNonTaxDiameter() {
        return this.nonTaxDiameter;
    }

    public double getNonTaxCloseness() {
        return this.nonTaxCloseness;
    }

    public double getNonTaxonomicMetric() {
        return this.nonTaxonomicMetric;
    }

    public double getConceptDiscoveryMetric() {
        return this.conceptDiscoveryMetric;
    }

    public int getTaxComponents() {
        return this.taxComponents;
    }

    public int getTaxVertices() {
        return this.taxVertices;
    }

    public int getTaxConcepts() {
        return this.taxConcepts;
    }

    public int getTaxBroader() {
        return this.taxBroader;
    }

    public double getTaxGeneralization() {
        return this.taxGeneralization;
    }

    public double getTaxConnectedness() {
        return this.taxConnectedness;
    }

    public double getTaxonomyMetric() {
        return this.taxonomyMetric;
    }

    public int getEffortClick() {
        return this.effortClick;
    }

    public int getEffortKeydown() {
        return this.effortKeydown;
    }

    public int getEffortInteractions() {
        return this.effortInteractions;
    }

    public double getOverallRating() {
        return this.overallRating;
    }

    public long getDuration() {
        return this.duration;
    }

    public JSONObject getChartData() {
        return this.chartData;
    }

    public double getProductivity() {
        return this.productivity;
    }

    public long getMemoryUsed() {
        return this.memoryUsed;
    }

    public long getMemoryTotal() {
        return this.memoryTotal;
    }

    public long getMemoryMax() {
        return this.memoryMax;
    }

    private static /* synthetic */ Integer[] lambda$topicStatistics$1(Resource s) {
        return new Integer[]{0, 0};
    }
}

