/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs.ml;

import de.dfki.sds.hephaistos.storage.StorageItem;
import de.dfki.sds.hephaistos.storage.assertion.Assertion;
import de.dfki.sds.hephaistos.storage.assertion.AssertionPool;
import de.dfki.sds.hephaistos.storage.assertion.Intelligence;
import de.dfki.sds.hephaistos.storage.assertion.Phase;
import de.dfki.sds.hephaistos.storage.assertion.Rating;
import de.dfki.sds.hephaistos.storage.file.FileInfo;
import de.dfki.sds.hephaistos.storage.file.FileInfoStorage;
import de.dfki.sds.hephaistos.storage.file.FolderInfo;
import de.dfki.sds.kecs.ml.Datasets;
import de.dfki.sds.kecs.ml.FileNode;
import de.dfki.sds.kecs.modules.ConceptDiscovery;
import de.dfki.sds.kecs.modules.OntologyPopulation;
import de.dfki.sds.kecs.util.KecsUtils;
import de.dfki.sds.kecs.util.Prediction;
import de.dfki.sds.kecs.util.PropertyEdge;
import de.dfki.sds.mschroeder.commons.lang.math.MinAvgMaxSdDouble;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.SKOS;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.LinkPredictionAlgorithm;
import org.jgrapht.alg.linkprediction.AdamicAdarIndexLinkPrediction;
import org.jgrapht.alg.linkprediction.CommonNeighborsLinkPrediction;
import org.jgrapht.alg.linkprediction.HubDepressedIndexLinkPrediction;
import org.jgrapht.alg.linkprediction.HubPromotedIndexLinkPrediction;
import org.jgrapht.alg.linkprediction.JaccardCoefficientLinkPrediction;
import org.jgrapht.alg.linkprediction.LeichtHolmeNewmanIndexLinkPrediction;
import org.jgrapht.alg.linkprediction.PreferentialAttachmentLinkPrediction;
import org.jgrapht.alg.linkprediction.ResourceAllocationIndexLinkPrediction;
import org.jgrapht.alg.linkprediction.SaltonIndexLinkPrediction;
import org.jgrapht.alg.linkprediction.S\u00f8rensenIndexLinkPrediction;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultUndirectedGraph;
import org.jgrapht.graph.DefaultUndirectedWeightedGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.nio.AttributeType;
import org.jgrapht.nio.DefaultAttribute;
import org.jgrapht.nio.graphml.GraphMLExporter;
import org.jgrapht.traverse.BreadthFirstIterator;

public class GraphManager {
    public static final Resource NEGATIVE_CLASS = ResourceFactory.createResource("urn:ml:negative");
    public static final Resource MISSING_CLASS = ResourceFactory.createResource("urn:ml:missing");
    private DefaultUndirectedGraph<FileNode, DefaultEdge> cachedFileNodeGraph;

    public DefaultUndirectedGraph<FileNode, DefaultEdge> loadCachedFileNodeGraph(FileInfoStorage fileInfoStorage) {
        FileInfo fi;
        if (this.cachedFileNodeGraph != null) {
            return this.cachedFileNodeGraph;
        }
        long begin = System.currentTimeMillis();
        DefaultUndirectedGraph<FileNode, DefaultEdge> graph = new DefaultUndirectedGraph<FileNode, DefaultEdge>(DefaultEdge.class);
        FolderInfo root2 = (FolderInfo)fileInfoStorage.getRoot();
        List<StorageItem> tree = fileInfoStorage.getTree(root2);
        HashMap<Integer, FileNode> id2filenode = new HashMap<Integer, FileNode>();
        for (StorageItem item : tree) {
            fi = (FileInfo)item;
            FileNode node = new FileNode();
            node.setName(fi.getName());
            if (fi.getMeta() != null) {
                node.setFile(KecsUtils.getResource(fi));
            }
            graph.addVertex(node);
            id2filenode.put(fi.getId(), node);
        }
        for (StorageItem item : tree) {
            fi = (FileInfo)item;
            if (fi.getParent() == root2.getId()) continue;
            graph.addEdge((FileNode)id2filenode.get(fi.getParent()), (FileNode)id2filenode.get(fi.getId()));
        }
        long end = System.currentTimeMillis();
        this.cachedFileNodeGraph = graph;
        return graph;
    }

    public DefaultUndirectedGraph<FileNode, DefaultEdge> loadCachedFileNodeGraphSiblings(FileInfoStorage fileInfoStorage, int nonTaxonomicTimeout, int nonTaxonomicDepthThreshold) {
        if (this.cachedFileNodeGraph != null) {
            return this.cachedFileNodeGraph;
        }
        DefaultUndirectedGraph<FileNode, DefaultEdge> graph = new DefaultUndirectedGraph<FileNode, DefaultEdge>(DefaultEdge.class);
        FolderInfo root2 = (FolderInfo)fileInfoStorage.getRoot();
        List<StorageItem> tree = fileInfoStorage.getTree(root2);
        HashMap<Integer, List> fi2children = new HashMap<Integer, List>();
        for (StorageItem storageItem : tree) {
            FileInfo fi = (FileInfo)storageItem;
            fi2children.computeIfAbsent(fi.getParent(), f -> new ArrayList()).add(fi.getId());
        }
        HashMap<Integer, FileNode> id2filenode = new HashMap<Integer, FileNode>();
        for (StorageItem item : tree) {
            FileInfo fi = (FileInfo)item;
            FileNode node = new FileNode();
            node.setName(fi.getName());
            if (fi.getMeta() != null) {
                node.setFile(KecsUtils.getResource(fi));
            }
            graph.addVertex(node);
            id2filenode.put(fi.getId(), node);
        }
        long l = System.currentTimeMillis();
        boolean inTimeout = false;
        MinAvgMaxSdDouble skippedStat = new MinAvgMaxSdDouble();
        for (StorageItem item : tree) {
            long now2;
            FileInfo fi = (FileInfo)item;
            if (fi.getParent() == root2.getId()) continue;
            if (nonTaxonomicTimeout > 0 && (now2 = System.currentTimeMillis()) - l > (long)nonTaxonomicTimeout) {
                inTimeout = true;
                int d = this.getDepth(fi);
                if (d > nonTaxonomicDepthThreshold) {
                    skippedStat.add(d);
                    continue;
                }
            }
            FileNode current = (FileNode)id2filenode.get(fi.getId());
            graph.addEdge((FileNode)id2filenode.get(fi.getParent()), current);
            List children = (List)fi2children.get(fi.getParent());
            if (children == null) continue;
            for (Integer childId : children) {
                FileNode siblingNode = (FileNode)id2filenode.get(childId);
                if (current == siblingNode) continue;
                graph.addEdge(current, siblingNode);
            }
        }
        long end = System.currentTimeMillis();
        System.out.println("took: " + (end - l) + " ms, timeout: " + nonTaxonomicTimeout + " ms, depth threshold: " + nonTaxonomicDepthThreshold + ", in timeout: " + inTimeout + ", skipped: " + skippedStat);
        if (skippedStat.getCount() > 0.0) {
            System.out.println(skippedStat.getHistogram());
        }
        this.cachedFileNodeGraph = graph;
        return graph;
    }

    private int getDepth(FileInfo fi) {
        int d1 = fi.getPath().split("\\\\").length;
        int d2 = fi.getPath().split("/").length;
        return Math.max(d1, d2);
    }

    public DefaultUndirectedGraph<FileNode, DefaultEdge> getCachedFileNodeGraph() {
        return this.cachedFileNodeGraph;
    }

    public void updateCachedFileNodeGraph(List<Assertion> assertions) {
        if (this.cachedFileNodeGraph == null) {
            return;
        }
        HashMap<Resource, Set> file2topics = new HashMap<Resource, Set>();
        for (Assertion assertion : assertions) {
            file2topics.computeIfAbsent(assertion.getSubject(), f -> new HashSet()).add(assertion.getObject());
        }
        for (FileNode fn : this.cachedFileNodeGraph.vertexSet()) {
            fn.getTopics().clear();
            Set topics = (Set)file2topics.get(fn.getFile());
            if (topics == null) continue;
            fn.getTopics().addAll(topics);
        }
    }

    public DefaultUndirectedWeightedGraph<Resource, DefaultWeightedEdge> getTopicGraph(Graph<FileNode, DefaultEdge> fileNodeGraph, int maxDepth) {
        long begin = System.currentTimeMillis();
        DefaultUndirectedWeightedGraph<Resource, DefaultWeightedEdge> topicGraph = new DefaultUndirectedWeightedGraph<Resource, DefaultWeightedEdge>(DefaultWeightedEdge.class);
        for (FileNode vertex : fileNodeGraph.vertexSet()) {
            FileNode f;
            int depth;
            if (vertex.getTopics().isEmpty()) continue;
            ArrayList<Resource> leftList = new ArrayList<Resource>(vertex.getTopics());
            BreadthFirstIterator<FileNode, DefaultEdge> bfs = new BreadthFirstIterator<FileNode, DefaultEdge>(fileNodeGraph, vertex);
            while (bfs.hasNext() && (depth = bfs.getDepth(f = (FileNode)bfs.next())) <= maxDepth) {
                double weight = 1.0 + (double)maxDepth - (double)depth;
                ArrayList<Resource> rightList = new ArrayList<Resource>(f.getTopics());
                for (int i = 0; i < leftList.size(); ++i) {
                    for (int j = 0; j < rightList.size(); ++j) {
                        Resource right;
                        Resource left = (Resource)leftList.get(i);
                        if (left.equals(right = (Resource)rightList.get(j))) continue;
                        topicGraph.addVertex(left);
                        topicGraph.addVertex(right);
                        DefaultWeightedEdge edge = (DefaultWeightedEdge)topicGraph.getEdge(left, right);
                        if (edge != null) {
                            double edgeWeight = topicGraph.getEdgeWeight(edge);
                            if (!(weight > edgeWeight)) continue;
                            topicGraph.setEdgeWeight(edge, weight);
                            continue;
                        }
                        DefaultWeightedEdge newEdge = (DefaultWeightedEdge)topicGraph.addEdge(left, right);
                        topicGraph.setEdgeWeight(newEdge, weight);
                    }
                }
            }
        }
        long end = System.currentTimeMillis();
        return topicGraph;
    }

    public DefaultUndirectedWeightedGraph<Resource, DefaultWeightedEdge> getTopicGraphV2(Graph<FileNode, DefaultEdge> fileNodeGraph) {
        long begin = System.currentTimeMillis();
        DefaultUndirectedWeightedGraph<Resource, DefaultWeightedEdge> topicGraph = new DefaultUndirectedWeightedGraph<Resource, DefaultWeightedEdge>(DefaultWeightedEdge.class);
        for (FileNode vertex : fileNodeGraph.vertexSet()) {
            if (vertex.getTopics().isEmpty()) continue;
            ArrayList<Resource> leftList = new ArrayList<Resource>(vertex.getTopics());
            ArrayList<FileNode> adjacent = new ArrayList<FileNode>();
            adjacent.add(vertex);
            for (DefaultEdge edge : fileNodeGraph.edgesOf(vertex)) {
                FileNode src = fileNodeGraph.getEdgeSource(edge);
                if (!src.equals(vertex)) {
                    adjacent.add(src);
                    continue;
                }
                adjacent.add(fileNodeGraph.getEdgeTarget(edge));
            }
            for (FileNode f : adjacent) {
                double depth = f.equals(vertex) ? 0.0 : 1.0;
                double weight = 2.0 - depth;
                ArrayList<Resource> rightList = new ArrayList<Resource>(f.getTopics());
                for (int i = 0; i < leftList.size(); ++i) {
                    for (int j = 0; j < rightList.size(); ++j) {
                        Resource right;
                        Resource left = (Resource)leftList.get(i);
                        if (left.equals(right = (Resource)rightList.get(j))) continue;
                        topicGraph.addVertex(left);
                        topicGraph.addVertex(right);
                        DefaultWeightedEdge edge = (DefaultWeightedEdge)topicGraph.getEdge(left, right);
                        if (edge != null) {
                            double edgeWeight = topicGraph.getEdgeWeight(edge);
                            if (!(weight > edgeWeight)) continue;
                            topicGraph.setEdgeWeight(edge, weight);
                            continue;
                        }
                        DefaultWeightedEdge newEdge = (DefaultWeightedEdge)topicGraph.addEdge(left, right);
                        topicGraph.setEdgeWeight(newEdge, weight);
                    }
                }
            }
        }
        long end = System.currentTimeMillis();
        return topicGraph;
    }

    public DefaultUndirectedGraph<Resource, PropertyEdge> getNonTaxonomicGraph(AssertionPool pool) {
        DefaultUndirectedGraph<Resource, PropertyEdge> graph = new DefaultUndirectedGraph<Resource, PropertyEdge>(PropertyEdge.class);
        Map<Resource, String> type2prefLbl = pool.getTypePrefLabelMap();
        Optional<Resource> yearTypeOpt = type2prefLbl.entrySet().stream().filter(e2 -> ((String)e2.getValue()).equals("Jahr")).map(e2 -> (Resource)e2.getKey()).findFirst();
        List<Assertion> concepts = pool.getAssertions(null, RDF.type, ConceptDiscovery.DEFAULT_TYPE, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0);
        for (Assertion conceptAssertion : concepts) {
            Resource type;
            List<Assertion> typeAssertions = pool.getAssertions(conceptAssertion.getSubject(), RDF.type, null, Phase.OntologyPopulation, Intelligence.NI, null, Rating.Positive, 0.0);
            if (typeAssertions.isEmpty() || (type = typeAssertions.get(0).getObject()).equals(OntologyPopulation.CONCEPT_TYPE) || yearTypeOpt.isPresent() && type.equals(yearTypeOpt.get())) continue;
            graph.addVertex(conceptAssertion.getSubject());
        }
        List<Assertion> relations = pool.getAssertions(null, null, null, Phase.NonTaxonomicRelationLearning, Intelligence.NI, null, Rating.Positive, 0.0);
        for (Assertion relationAssertion : relations) {
            if (!graph.containsVertex(relationAssertion.getSubject()) || !graph.containsVertex(relationAssertion.getObject())) continue;
            PropertyEdge propertyEdge = new PropertyEdge(relationAssertion.getStatement().getPredicate());
            graph.addEdge(relationAssertion.getSubject(), relationAssertion.getObject(), propertyEdge);
        }
        return graph;
    }

    public DefaultUndirectedGraph<Resource, DefaultEdge> getTaxonomyGraph(AssertionPool pool) {
        DefaultUndirectedGraph<Resource, DefaultEdge> graph = new DefaultUndirectedGraph<Resource, DefaultEdge>(DefaultEdge.class);
        List<Assertion> concepts = pool.getAssertions(null, RDF.type, OntologyPopulation.CONCEPT_TYPE, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
        for (Assertion conceptAssertion : concepts) {
            boolean exists = !pool.getAssertions(conceptAssertion.getSubject(), RDF.type, ConceptDiscovery.DEFAULT_TYPE, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0).isEmpty();
            if (!exists) continue;
            graph.addVertex(conceptAssertion.getSubject());
        }
        List<Assertion> relations = pool.getAssertions(null, SKOS.broader, null, Phase.ConceptHierarchyDerivation, Intelligence.NI, null, Rating.Positive, 0.0);
        for (Assertion relationAssertion : relations) {
            if (!graph.containsVertex(relationAssertion.getSubject()) || !graph.containsVertex(relationAssertion.getObject())) continue;
            graph.addEdge(relationAssertion.getSubject(), relationAssertion.getObject());
        }
        return graph;
    }

    public Datasets linkPrediction(DefaultUndirectedWeightedGraph<Resource, DefaultWeightedEdge> topicGraph, List<LinkPredictionAlgorithm<Resource, DefaultWeightedEdge>> algorithms, List<Assertion> assertions, List<Statement> toTest) {
        Datasets datasets = new Datasets();
        HashMap<Statement, Assertion> stmtAssertionMap = new HashMap<Statement, Assertion>();
        for (Assertion assertion : assertions) {
            stmtAssertionMap.put(assertion.getStatement(), assertion);
        }
        int numPos = 0;
        int numNeg = 0;
        int numUnd = 0;
        HashSet<String> classes = new HashSet<String>();
        for (Assertion assertion : assertions) {
            Object[] record = new Object[algorithms.size() + 1];
            int index = 0;
            for (LinkPredictionAlgorithm<Resource, DefaultWeightedEdge> algo : algorithms) {
                double score = 0.0;
                try {
                    score = algo.predict(assertion.getSubject(), assertion.getObject());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                record[index] = score;
                ++index;
            }
            if (this.isZero(record)) continue;
            switch (assertion.getRating()) {
                case Positive: {
                    record[record.length - 1] = assertion.getStatement().getPredicate().getURI();
                    ++numPos;
                    break;
                }
                case Negative: {
                    record[record.length - 1] = NEGATIVE_CLASS.getURI();
                    ++numNeg;
                    break;
                }
                case Undecided: {
                    record[record.length - 1] = NEGATIVE_CLASS.getURI();
                    ++numUnd;
                }
            }
            classes.add((String)record[record.length - 1]);
            datasets.getRecord2stmt().put(record, assertion.getStatement());
            datasets.getTrainSet().add(record);
        }
        for (Statement testStmt : toTest) {
            Resource src = testStmt.getSubject();
            Resource trg = testStmt.getResource();
            if (stmtAssertionMap.containsKey(testStmt)) continue;
            Object[] record = new Object[algorithms.size() + 1];
            int index = 0;
            for (LinkPredictionAlgorithm<Resource, DefaultWeightedEdge> algo : algorithms) {
                double score = 0.0;
                try {
                    score = algo.predict(src, trg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                record[index] = score;
                ++index;
            }
            if (this.isZero(record)) continue;
            datasets.getRecord2stmt().put(record, testStmt);
            record[record.length - 1] = MISSING_CLASS.getURI();
            classes.add((String)record[record.length - 1]);
            datasets.getTestSet().add(record);
        }
        ArrayList<String> classLabels = new ArrayList<String>(classes);
        classLabels.sort((a, b) -> a.compareTo((String)b));
        datasets.setClassLabels(classLabels);
        return datasets;
    }

    public List<Prediction> distanceBasedPrediction(Datasets datasets, DistanceMeasure distMeasure, double distanceThreshold, AssertionPool pool) {
        ArrayList<Prediction> predictions = new ArrayList<Prediction>();
        HashMap<Statement, Double> stmt2dist = new HashMap<Statement, Double>();
        for (Object[] objectArray : datasets.getTrainSet()) {
            String clazz = (String)objectArray[objectArray.length - 1];
            if (clazz.equals(NEGATIVE_CLASS.getURI())) continue;
            Statement trainStmt = datasets.getRecord2stmt().get(objectArray);
            double[] trainVector = Datasets.toDoubleArray(objectArray);
            for (Object[] testRecord : datasets.getTestSet()) {
                Statement testStmt = datasets.getRecord2stmt().get(testRecord);
                if (!trainStmt.getPredicate().equals(testStmt.getPredicate())) continue;
                double[] testVector = Datasets.toDoubleArray(testRecord);
                double dist = distMeasure.compute(trainVector, testVector);
                Double existingDist = (Double)stmt2dist.get(testStmt);
                if (existingDist != null) {
                    if (!(dist < existingDist)) continue;
                    stmt2dist.put(testStmt, dist);
                    continue;
                }
                stmt2dist.put(testStmt, dist);
            }
        }
        for (Map.Entry entry : stmt2dist.entrySet()) {
            Prediction prediction = new Prediction();
            prediction.setStatement((Statement)entry.getKey());
            prediction.setClassLabel(((Statement)entry.getKey()).getPredicate().getURI());
            prediction.setDistance((Double)entry.getValue());
            predictions.add(prediction);
        }
        predictions.sort((a, b) -> Double.compare(a.getDistance(), b.getDistance()));
        predictions.removeIf(p -> p.getDistance() > distanceThreshold);
        return predictions;
    }

    private boolean isZero(Object[] record) {
        for (int i = 0; i < record.length; ++i) {
            if (record[i] == null || !(record[i] instanceof Double) || (Double)record[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    private String toString(Statement stmt, Map<Resource, String> toPrefLabelMap, Map<Resource, String> propertyPrefLblMap) {
        return Arrays.asList(toPrefLabelMap.get(stmt.getSubject()), propertyPrefLblMap.get(stmt.getPredicate()), toPrefLabelMap.get(stmt.getResource())).toString();
    }

    public void exportTopicGraph(DefaultUndirectedWeightedGraph<Resource, DefaultWeightedEdge> topicGraph, AssertionPool pool, File graphmlFile) {
        GraphMLExporter<Resource, DefaultWeightedEdge> exporter = new GraphMLExporter<Resource, DefaultWeightedEdge>();
        exporter.registerAttribute("uri", GraphMLExporter.AttributeCategory.NODE, AttributeType.STRING);
        exporter.registerAttribute("label", GraphMLExporter.AttributeCategory.NODE, AttributeType.STRING);
        exporter.registerAttribute("distance", GraphMLExporter.AttributeCategory.EDGE, AttributeType.DOUBLE);
        exporter.setExportEdgeWeights(true);
        exporter.setVertexAttributeProvider(res -> {
            HashMap<String, DefaultAttribute<Object>> m = new HashMap<String, DefaultAttribute<Object>>();
            m.put("uri", new DefaultAttribute<Resource>((Resource)res, AttributeType.STRING));
            String prefLabel = AssertionPool.getPrefLabelString(pool.getAssertions((Resource)res, SKOS.prefLabel, null, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0));
            if (prefLabel.isEmpty()) {
                prefLabel = res.getLocalName();
            }
            m.put("label", new DefaultAttribute<String>(prefLabel, AttributeType.STRING));
            return m;
        });
        exporter.exportGraph(topicGraph, graphmlFile);
    }

    public static List<LinkPredictionAlgorithm<Resource, DefaultWeightedEdge>> allLinkPredictionAlgorithms(DefaultUndirectedWeightedGraph<Resource, DefaultWeightedEdge> topicGraph) {
        ArrayList<LinkPredictionAlgorithm<Resource, DefaultWeightedEdge>> algorithms = new ArrayList<LinkPredictionAlgorithm<Resource, DefaultWeightedEdge>>();
        algorithms.add(new AdamicAdarIndexLinkPrediction<Resource, DefaultWeightedEdge>(topicGraph));
        algorithms.add(new CommonNeighborsLinkPrediction<Resource, DefaultWeightedEdge>(topicGraph));
        algorithms.add(new HubDepressedIndexLinkPrediction<Resource, DefaultWeightedEdge>(topicGraph));
        algorithms.add(new HubPromotedIndexLinkPrediction<Resource, DefaultWeightedEdge>(topicGraph));
        algorithms.add(new JaccardCoefficientLinkPrediction<Resource, DefaultWeightedEdge>(topicGraph));
        algorithms.add(new LeichtHolmeNewmanIndexLinkPrediction<Resource, DefaultWeightedEdge>(topicGraph));
        algorithms.add(new PreferentialAttachmentLinkPrediction<Resource, DefaultWeightedEdge>(topicGraph));
        algorithms.add(new ResourceAllocationIndexLinkPrediction<Resource, DefaultWeightedEdge>(topicGraph));
        algorithms.add(new SaltonIndexLinkPrediction<Resource, DefaultWeightedEdge>(topicGraph));
        algorithms.add(new S\u00f8rensenIndexLinkPrediction<Resource, DefaultWeightedEdge>(topicGraph));
        return algorithms;
    }
}

