/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class KecsSettings {
    private File userCsvFile;
    private File ontologyFile;
    private Mode mode;
    private File input;
    private File outputFolder;
    private String charset;
    private boolean filePathList;
    private String fileSeparator;
    private int limit;
    private boolean loadEmbedding;
    private boolean loadLanguageResource;
    private int excelCharacterSumThreshold;
    private int excelContentCountThreshold;
    private String excelWhitelist;
    private boolean loadDefaultOntology;
    private int nonTaxonomicTimeout;
    private int nonTaxonomicDepthThreshold;
    private Language language;
    private boolean runServer;
    private int port;
    private static final int DEFAULT_PORT = 7572;
    private static final int DEFAULT_LIMIT = 100000;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String DEFAULT_SEPARATOR = "\\";
    private static final String DEFAULT_USERS = "users.csv";
    private static final String DEFAULT_ONTOLOGY = "ontology.json";
    private static final int DEFAULT_EXCEL_CHARACTER_SUM_THRESHOLD = 5000;
    private static final int DEFAULT_EXCEL_CONTENT_COUNT_THRESHOLD = 30;
    private boolean openBrowser;
    private static final int DEFAULT_SAVE_STATUS_THRESHOLD = 10;
    private int saveStatusThreshold;

    public static KecsSettings loadCommandline(String[] cmdargs) {
        KecsSettings settings = new KecsSettings();
        Options options = new Options();
        OptionGroup g = new OptionGroup();
        options.addOption("h", "help", false, "Prints this help message.");
        options.addOption("u", "users", true, "A CSV file with user credentials. Default: users.csv");
        options.addOption("O", "ontology", true, "A json file with ontology information. Default: ontology.json");
        options.addOption("m", "mode", true, "Selects the required mode which defines what this program should do. Possible values are: " + Arrays.deepToString((Object[])Mode.values()));
        options.addOption("i", "input", true, "An input file or folder, depending on the selected mode.");
        options.addOption("o", "output", true, "A required folder where the feedback progress is loaded and stored.");
        options.addOption("s", "server", false, "Runs a localhost server which provides the user interface.");
        options.addOption("p", "port", true, "Changes the server port. Default: 7572");
        options.addOption("b", "browser", false, "Opens the webapp in a standard browser.");
        options.addOption("c", "charset", true, "Changes character encoding in " + (Object)((Object)Mode.BootstrapFilesystemDump) + " mode. Default: " + DEFAULT_CHARSET);
        options.addOption("fpl", "file-path-list", false, "Changes reading behavior in " + (Object)((Object)Mode.BootstrapFilesystemDump) + " mode.");
        options.addOption("fs", "file-separator", true, "Changes separation behavior in " + (Object)((Object)Mode.BootstrapFilesystemDump) + " mode. Default: " + DEFAULT_SEPARATOR);
        options.addOption("l", "limit", true, "Changes file crawl limit in " + (Object)((Object)Mode.BootstrapFilesystem) + " mode. Default: " + 100000);
        options.addOption("ew", "excel-whitelist", true, "A whitelist to filter columns in " + (Object)((Object)Mode.BootstrapExcel) + " mode.");
        options.addOption("E", "no-embedding", false, "Disables the loading of the embedding files.");
        options.addOption("G", "no-language-resource", false, "Disables the loading of the language resource files.");
        options.addOption("D", "no-default-ontology", false, "Disables the loading of the default ontology.");
        options.addOption("ntt", "non-taxonomic-timeout", true, "Sets timeout for init module NonTaxonomicRelationLearning.");
        options.addOption("ntdt", "non-taxonomic-depth-threshold", true, "Sets depth threshold for init module NonTaxonomicRelationLearning.");
        options.addOption("lang", "language", true, "Sets language (en or de). Default: en");
        DefaultParser parser2 = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        String cmdLineSyntax = "java -jar kecs.jar";
        String header = "";
        String footer = "\nVisit https://github.com/mschroeder-github/kecs for more information.\nVersion: 2022-03-14\n";
        CommandLine cmd = null;
        try {
            cmd = parser2.parse(options, cmdargs);
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            formatter.printHelp(cmdLineSyntax, header, options, footer);
            System.exit(0);
        }
        if (cmd.hasOption("h")) {
            formatter.printHelp(cmdLineSyntax, header, options, footer);
            System.out.println();
            System.exit(0);
        }
        if (!cmd.hasOption("m")) {
            System.err.println("Mode required.");
            formatter.printHelp(cmdLineSyntax, header, options, footer);
            System.exit(0);
        }
        try {
            settings.mode = Mode.valueOf(cmd.getOptionValue("m"));
        }
        catch (IllegalArgumentException e2) {
            System.err.println("Mode required.");
            formatter.printHelp(cmdLineSyntax, header, options, footer);
            System.exit(0);
        }
        settings.userCsvFile = new File(DEFAULT_USERS);
        if (cmd.hasOption("u")) {
            settings.userCsvFile = new File(cmd.getOptionValue("u"));
        }
        settings.ontologyFile = new File(DEFAULT_ONTOLOGY);
        if (cmd.hasOption("O")) {
            settings.ontologyFile = new File(cmd.getOptionValue("O"));
        }
        if (cmd.hasOption("i")) {
            settings.input = new File(cmd.getOptionValue("i"));
        }
        if (cmd.hasOption("o")) {
            settings.outputFolder = new File(cmd.getOptionValue("o"));
        }
        settings.charset = DEFAULT_CHARSET;
        if (cmd.hasOption("c")) {
            settings.charset = cmd.getOptionValue("c");
        }
        settings.fileSeparator = DEFAULT_SEPARATOR;
        if (cmd.hasOption("fs")) {
            settings.fileSeparator = cmd.getOptionValue("fs");
        }
        settings.filePathList = cmd.hasOption("fpl");
        settings.port = 7572;
        if (cmd.hasOption("p")) {
            try {
                settings.port = Integer.parseInt(cmd.getOptionValue("p"));
            }
            catch (NumberFormatException e3) {
                System.err.println("Port number could not be parsed.");
                formatter.printHelp(cmdLineSyntax, header, options, footer);
                System.exit(0);
            }
        }
        settings.limit = 100000;
        if (cmd.hasOption("l")) {
            try {
                settings.limit = Integer.parseInt(cmd.getOptionValue("l"));
            }
            catch (NumberFormatException e4) {
                System.err.println("Limit number could not be parsed.");
                formatter.printHelp(cmdLineSyntax, header, options, footer);
                System.exit(0);
            }
        }
        settings.runServer = cmd.hasOption("s");
        settings.openBrowser = cmd.hasOption("b");
        settings.loadEmbedding = !cmd.hasOption("E");
        settings.loadLanguageResource = !cmd.hasOption("G");
        settings.loadDefaultOntology = !cmd.hasOption("D");
        settings.saveStatusThreshold = 10;
        settings.excelCharacterSumThreshold = 5000;
        settings.excelContentCountThreshold = 30;
        settings.nonTaxonomicTimeout = 10000;
        if (cmd.hasOption("ntt")) {
            try {
                settings.nonTaxonomicTimeout = Integer.parseInt(cmd.getOptionValue("ntt"));
            }
            catch (NumberFormatException e5) {
                System.err.println("Non-taxonomic timeout could not be parsed.");
                formatter.printHelp(cmdLineSyntax, header, options, footer);
                System.exit(0);
            }
        }
        settings.nonTaxonomicDepthThreshold = 5;
        if (cmd.hasOption("ntdt")) {
            try {
                settings.nonTaxonomicDepthThreshold = Integer.parseInt(cmd.getOptionValue("ntdt"));
            }
            catch (NumberFormatException e6) {
                System.err.println("Non-taxonomic depth threshold could not be parsed.");
                formatter.printHelp(cmdLineSyntax, header, options, footer);
                System.exit(0);
            }
        }
        if (cmd.hasOption("ew")) {
            settings.excelWhitelist = cmd.getOptionValue("ew");
        }
        settings.language = Language.semweb;
        if (cmd.hasOption("lang")) {
            try {
                settings.language = Language.valueOf(cmd.getOptionValue("lang"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (settings.mode == Mode.Demo) {
            settings.runServer = true;
            settings.outputFolder = new File("kecs-demo");
        }
        return settings;
    }

    public File getUserCsvFile() {
        return this.userCsvFile;
    }

    public Mode getMode() {
        return this.mode;
    }

    public File getInput() {
        return this.input;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean isFilePathList() {
        return this.filePathList;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public boolean isRunServer() {
        return this.runServer;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isOpenBrowser() {
        return this.openBrowser;
    }

    public int getLimit() {
        return this.limit;
    }

    public File getOntologyFile() {
        return this.ontologyFile;
    }

    public boolean isLoadEmbedding() {
        return this.loadEmbedding;
    }

    public boolean isLoadLanguageResource() {
        return this.loadLanguageResource;
    }

    public int getSaveStatusThreshold() {
        return this.saveStatusThreshold;
    }

    public int getExcelCharacterSumThreshold() {
        return this.excelCharacterSumThreshold;
    }

    public int getExcelContentCountThreshold() {
        return this.excelContentCountThreshold;
    }

    public String getExcelWhitelist() {
        return this.excelWhitelist;
    }

    public boolean isLoadDefaultOntology() {
        return this.loadDefaultOntology;
    }

    public int getNonTaxonomicTimeout() {
        return this.nonTaxonomicTimeout;
    }

    public int getNonTaxonomicDepthThreshold() {
        return this.nonTaxonomicDepthThreshold;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public static enum Language {
        semweb,
        en,
        de;

    }

    public static enum Mode {
        BootstrapFilesystem,
        BootstrapFilesystemDump,
        BootstrapExcel,
        Load,
        Demo;

    }
}

